/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core.v2;

import java.util.Vector;
import org.postgresql.core.ParameterList;
import org.postgresql.core.Query;
import org.postgresql.core.v2.SimpleParameterList;

class V2Query
implements Query {
    private static final ParameterList NO_PARAMETERS = new SimpleParameterList(0);
    private final String[] fragments;

    V2Query(String query, boolean withParameters) {
        int i;
        if (!withParameters) {
            this.fragments = new String[]{query};
            return;
        }
        Vector<String> v = new Vector<String>();
        int lastParmEnd = 0;
        boolean inSingleQuotes = false;
        boolean inDoubleQuotes = false;
        block6: for (i = 0; i < query.length(); ++i) {
            char c = query.charAt(i);
            switch (c) {
                case '\\': {
                    if (!inSingleQuotes) continue block6;
                    ++i;
                    continue block6;
                }
                case '\'': {
                    inSingleQuotes = !inDoubleQuotes && !inSingleQuotes;
                    continue block6;
                }
                case '\"': {
                    inDoubleQuotes = !inSingleQuotes && !inDoubleQuotes;
                    continue block6;
                }
                case '?': {
                    if (inSingleQuotes || inDoubleQuotes) continue block6;
                    v.addElement(query.substring(lastParmEnd, i));
                    lastParmEnd = i + 1;
                    continue block6;
                }
            }
        }
        v.addElement(query.substring(lastParmEnd, query.length()));
        this.fragments = new String[v.size()];
        for (i = 0; i < this.fragments.length; ++i) {
            this.fragments[i] = (String)v.elementAt(i);
        }
    }

    public ParameterList createParameterList() {
        if (this.fragments.length == 1) {
            return NO_PARAMETERS;
        }
        return new SimpleParameterList(this.fragments.length - 1);
    }

    public String toString(ParameterList parameters) {
        StringBuffer sbuf = new StringBuffer(this.fragments[0]);
        for (int i = 1; i < this.fragments.length; ++i) {
            if (parameters == null) {
                sbuf.append("?");
            } else {
                sbuf.append(parameters.toString(i));
            }
            sbuf.append(this.fragments[i]);
        }
        return sbuf.toString();
    }

    public void close() {
    }

    String[] getFragments() {
        return this.fragments;
    }
}

