/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.datamanager.parser.eml;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerException;
import org.apache.xpath.CachedXPathAPI;
import org.ecoinformatics.datamanager.parser.Attribute;
import org.ecoinformatics.datamanager.parser.AttributeList;
import org.ecoinformatics.datamanager.parser.DataPackage;
import org.ecoinformatics.datamanager.parser.DateTimeDomain;
import org.ecoinformatics.datamanager.parser.Domain;
import org.ecoinformatics.datamanager.parser.Entity;
import org.ecoinformatics.datamanager.parser.EnumeratedDomain;
import org.ecoinformatics.datamanager.parser.NumericDomain;
import org.ecoinformatics.datamanager.parser.StorageType;
import org.ecoinformatics.datamanager.parser.TextComplexDataFormat;
import org.ecoinformatics.datamanager.parser.TextDelimitedDataFormat;
import org.ecoinformatics.datamanager.parser.TextDomain;
import org.ecoinformatics.datamanager.parser.TextWidthFixedDataFormat;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Eml200Parser {
    public static final String DATATABLEENTITY = "//dataset/dataTable";
    public static final String SPATIALRASTERENTITY = "//dataset/spatialRaster";
    public static final String SPATIALVECTORENTITY = "//dataset/spatialVector";
    public static final String STOREDPROCEDUREENTITY = "//dataset/storedProcedure";
    public static final String VIEWENTITY = "//dataset/view";
    public static final String OTHERENTITY = "//dataset/otherEntity";
    private static final String PACKAGEIDPATH = "//eml/@packageId";
    private static boolean isDebugging;
    private static final String ID = "id";
    private static final String TYPE_SYSTEM = "typeSystem";
    private int numEntities = 0;
    private Entity entityObject = null;
    private int elementId = 0;
    private int numberOfComplexFormats = 0;
    private Hashtable<String, AttributeList> attributeListIdHash = new Hashtable();
    private DataPackage emlDataPackage = null;

    public void parse(InputSource source) throws Exception {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = builder.parse(source);
        this.parseDocument(doc);
    }

    public void parse(InputStream is) throws Exception {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = builder.parse(is);
        this.parseDocument(doc);
    }

    private void parseDocument(Document doc) throws Exception {
        NodeList viewEntities;
        NodeList otherEntities;
        NodeList spatialVectorEntities;
        NodeList spatialRasterEntities;
        NodeList dataTableEntities;
        CachedXPathAPI xpathapi = new CachedXPathAPI();
        String packageId = null;
        try {
            Node packageIdNode = xpathapi.selectSingleNode((Node)doc, PACKAGEIDPATH);
            if (packageIdNode != null) {
                packageId = packageIdNode.getNodeValue();
            }
            this.emlDataPackage = new DataPackage(packageId);
            dataTableEntities = xpathapi.selectNodeList((Node)doc, DATATABLEENTITY);
            spatialRasterEntities = xpathapi.selectNodeList((Node)doc, SPATIALRASTERENTITY);
            spatialVectorEntities = xpathapi.selectNodeList((Node)doc, SPATIALVECTORENTITY);
            otherEntities = xpathapi.selectNodeList((Node)doc, OTHERENTITY);
            viewEntities = xpathapi.selectNodeList((Node)doc, VIEWENTITY);
        }
        catch (Exception e) {
            throw new Exception("Error extracting entities from eml2.0.0 package.");
        }
        try {
            this.processEntities(xpathapi, dataTableEntities, DATATABLEENTITY, packageId);
            this.processEntities(xpathapi, spatialRasterEntities, SPATIALRASTERENTITY, packageId);
            this.processEntities(xpathapi, spatialVectorEntities, SPATIALVECTORENTITY, packageId);
            this.processEntities(xpathapi, otherEntities, OTHERENTITY, packageId);
            this.processEntities(xpathapi, viewEntities, VIEWENTITY, packageId);
        }
        catch (Exception e) {
            throw new Exception("Error processing entities: " + e.getMessage());
        }
    }

    public DataPackage getDataPackage() {
        return this.emlDataPackage;
    }

    private void processAttributeList(CachedXPathAPI xpathapi, NodeList attributeListNodeList, Entity entObj) throws Exception {
        int numberOfAttributes;
        Node idNode;
        AttributeList attributeList = new AttributeList();
        Node attributeListNode = attributeListNodeList.item(0);
        NamedNodeMap attributeListNodeAttributes = attributeListNode.getAttributes();
        String idString = null;
        if (attributeListNodeAttributes != null && (idNode = attributeListNodeAttributes.getNamedItem(ID)) != null) {
            idString = idNode.getNodeValue();
            attributeList.setId(idString);
            if (isDebugging) {
                // empty if block
            }
        }
        NodeList attributeNodeList = xpathapi.selectNodeList(attributeListNode, "attribute");
        NodeList referencesNodeList = xpathapi.selectNodeList(attributeListNode, "references");
        if (attributeNodeList != null && attributeNodeList.getLength() > 0) {
            this.processAttributes(xpathapi, attributeNodeList, attributeList);
            if (idString != null) {
                this.attributeListIdHash.put(idString, attributeList);
            }
        } else if (referencesNodeList != null && referencesNodeList.getLength() > 0) {
            Node referencesNode = referencesNodeList.item(0);
            if (isDebugging) {
                // empty if block
            }
            String referencesId = referencesNode.getFirstChild().getNodeValue();
            if (isDebugging) {
                // empty if block
            }
            attributeList = this.attributeListIdHash.get(referencesId);
        } else {
            throw new Exception(" couldn't be a child of attributeList");
        }
        if (!this.entityObject.isSimpleDelimited() && ((numberOfAttributes = attributeList.getAttributes().length) != this.numberOfComplexFormats || numberOfAttributes == this.numberOfComplexFormats && this.numberOfComplexFormats == 0)) {
            throw new Exception("Complex format elements should have same number as attribute number");
        }
        this.entityObject.setAttributeList(attributeList);
    }

    private void processAttributes(CachedXPathAPI xpathapi, NodeList attributesNodeList, AttributeList attributeList) throws Exception {
        int attributesNodeListLength = attributesNodeList.getLength();
        for (int i = 0; i < attributesNodeListLength; ++i) {
            Node idNode;
            Node attributeNode = attributesNodeList.item(i);
            NodeList attributeNodeChildren = attributeNode.getChildNodes();
            String attName = "";
            String attLabel = "";
            String attDefinition = "";
            String attUnit = "";
            String attUnitType = "";
            String attMeasurementScale = "";
            String attPrecision = "";
            Domain domain = null;
            String id = null;
            Vector<String> missingValueCodeVector = new Vector<String>();
            double numberPrecision = 0.0;
            ArrayList<StorageType> storageTypeArray = new ArrayList<StorageType>();
            NamedNodeMap attributeNodeAttributesMap = attributeNode.getAttributes();
            if (attributeNodeAttributesMap != null && (idNode = attributeNodeAttributesMap.getNamedItem(ID)) != null) {
                id = idNode.getNodeValue();
            }
            ++this.elementId;
            for (int j = 0; j < attributeNodeChildren.getLength(); ++j) {
                Node childNode = attributeNodeChildren.item(j);
                String childNodeName = childNode.getNodeName();
                if (childNodeName.equals("attributeName")) {
                    attName = childNode.getFirstChild().getNodeValue().trim().replace('.', '_');
                    continue;
                }
                if (childNodeName.equals("attributeLabel")) {
                    attLabel = childNode.getFirstChild().getNodeValue().trim();
                    continue;
                }
                if (childNodeName.equals("attributeDefinition")) {
                    attDefinition = childNode.getFirstChild().getNodeValue().trim();
                    continue;
                }
                if (childNodeName.equals("storageType")) {
                    String storageTypeTextValue = childNode.getFirstChild().getNodeValue().trim();
                    NamedNodeMap storageTypeAttributesMap = childNode.getAttributes();
                    String typeSystem = "";
                    Node typeSystemNode = null;
                    if (storageTypeAttributesMap != null && (typeSystemNode = storageTypeAttributesMap.getNamedItem(TYPE_SYSTEM)) != null) {
                        typeSystem = typeSystemNode.getNodeValue();
                    }
                    StorageType storageType = !typeSystem.equals("") ? new StorageType(storageTypeTextValue, typeSystem) : new StorageType(storageTypeTextValue);
                    storageTypeArray.add(storageType);
                    continue;
                }
                if (childNodeName.equals("measurementScale")) {
                    NodeList measurementScaleChildNodes = childNode.getChildNodes();
                    for (int k = 0; k < measurementScaleChildNodes.getLength(); ++k) {
                        Node measurementScaleChildNode = measurementScaleChildNodes.item(k);
                        String measurementScaleChildNodeName = measurementScaleChildNode.getNodeName();
                        if (measurementScaleChildNodeName.equals("interval") || measurementScaleChildNodeName.equals("ratio")) {
                            String numberType = null;
                            String min = "";
                            String max = "";
                            Node standardUnitNode = xpathapi.selectSingleNode(measurementScaleChildNode, "unit/standardUnit");
                            Node customUnitNode = xpathapi.selectSingleNode(measurementScaleChildNode, "unit/customUnit");
                            if (standardUnitNode != null) {
                                attUnit = standardUnitNode.getFirstChild().getNodeValue();
                                attUnitType = Attribute.STANDARDUNIT;
                            } else if (customUnitNode != null) {
                                attUnit = customUnitNode.getFirstChild().getNodeValue();
                                attUnitType = Attribute.CUSTOMUNIT;
                            } else {
                                System.err.println("Unable to determine attribute unit.");
                            }
                            Node precisionNode = xpathapi.selectSingleNode(measurementScaleChildNode, "precision");
                            if (precisionNode != null) {
                                attPrecision = precisionNode.getFirstChild().getNodeValue();
                                numberPrecision = new Double(attPrecision);
                            }
                            Node numericDomainNode = xpathapi.selectSingleNode(measurementScaleChildNode, "numericDomain");
                            NodeList numericDomainChildNodes = numericDomainNode.getChildNodes();
                            for (int index = 0; index < numericDomainChildNodes.getLength(); ++index) {
                                String numericDomainChildNodeName = numericDomainChildNodes.item(index).getNodeName();
                                if (numericDomainChildNodeName.equals("numberType")) {
                                    numberType = numericDomainChildNodes.item(index).getFirstChild().getNodeValue();
                                    if (!isDebugging) continue;
                                    continue;
                                }
                                if (!numericDomainChildNodeName.equals("boundsGroup")) continue;
                                NodeList boundsNodeList = xpathapi.selectNodeList(numericDomainNode, "./bounds");
                                for (i = 0; i < boundsNodeList.getLength(); ++i) {
                                    try {
                                        NodeList aNodeList = xpathapi.selectNodeList(boundsNodeList.item(i), "./minimum");
                                        Node boundsNode = aNodeList.item(0);
                                        min = boundsNode.getFirstChild().getNodeValue();
                                        aNodeList = xpathapi.selectNodeList(boundsNodeList.item(0), "./maximum");
                                        boundsNode = aNodeList.item(0);
                                        max = boundsNode.getFirstChild().getNodeValue();
                                        continue;
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            }
                            Double minNum = null;
                            Double maxNum = null;
                            if (!min.trim().equals("")) {
                                minNum = new Double(min);
                            }
                            if (!max.trim().equals("")) {
                                maxNum = new Double(max);
                            }
                            NumericDomain numericDomain = new NumericDomain(numberType, minNum, maxNum);
                            numericDomain.setPrecision(numberPrecision);
                            domain = numericDomain;
                            continue;
                        }
                        if (measurementScaleChildNodeName.equals("nominal") || measurementScaleChildNodeName.equals("ordinal")) {
                            NodeList nonNumericDomainChildNodes = xpathapi.selectSingleNode(measurementScaleChildNode, "nonNumericDomain").getChildNodes();
                            for (int m = 0; m < nonNumericDomainChildNodes.getLength(); ++m) {
                                Node nonNumericDomainChildNode = nonNumericDomainChildNodes.item(m);
                                String nonNumericDomainChildNodeName = nonNumericDomainChildNode.getNodeName();
                                if (nonNumericDomainChildNodeName.equals("textDomain")) {
                                    TextDomain textDomain = new TextDomain();
                                    NodeList definitionNodeList = xpathapi.selectNodeList(nonNumericDomainChildNode, "./definition");
                                    Node defintionNode = definitionNodeList.item(0);
                                    String definition = defintionNode.getFirstChild().getNodeValue();
                                    if (isDebugging) {
                                        // empty if block
                                    }
                                    textDomain.setDefinition(definition);
                                    NodeList patternNodeList = xpathapi.selectNodeList(nonNumericDomainChildNode, "./pattern");
                                    String[] patternList = new String[patternNodeList.getLength()];
                                    for (int l = 0; l < patternNodeList.getLength(); ++l) {
                                        patternList[l] = patternNodeList.item(l).getFirstChild().getNodeValue();
                                    }
                                    if (patternList.length > 0) {
                                        textDomain.setPattern(patternList);
                                    }
                                    domain = textDomain;
                                    continue;
                                }
                                if (!nonNumericDomainChildNodeName.equals("enumeratedDomain")) continue;
                                EnumeratedDomain enumeratedDomain = new EnumeratedDomain();
                                Vector<String> info = new Vector<String>();
                                NodeList codeDefinitionNodeList = xpathapi.selectNodeList(nonNumericDomainChildNode, "./codeDefinition");
                                for (int l = 0; l < codeDefinitionNodeList.getLength(); ++l) {
                                    info.add(codeDefinitionNodeList.item(l).getFirstChild().getNodeValue());
                                }
                                enumeratedDomain.setInfo(info);
                                domain = enumeratedDomain;
                            }
                            continue;
                        }
                        if (!measurementScaleChildNodeName.equalsIgnoreCase("datetime")) continue;
                        DateTimeDomain date = new DateTimeDomain();
                        String formatString = xpathapi.selectSingleNode(measurementScaleChildNode, "./formatString").getFirstChild().getNodeValue();
                        if (isDebugging) {
                            // empty if block
                        }
                        date.setFormatString(formatString);
                        domain = date;
                    }
                    continue;
                }
                if (!childNodeName.equals("missingValueCode")) continue;
                NodeList missingValueCodeChildNodes = childNode.getChildNodes();
                for (int k = 0; k < missingValueCodeChildNodes.getLength(); ++k) {
                    Node missingValueCodeTextNode;
                    Node missingValueCodeChildNode = missingValueCodeChildNodes.item(k);
                    String missingValueCodeChildNodeName = missingValueCodeChildNode.getNodeName();
                    if (!missingValueCodeChildNodeName.equals("code") || (missingValueCodeTextNode = missingValueCodeChildNode.getFirstChild()) == null) continue;
                    String missingValueCode = missingValueCodeTextNode.getNodeValue();
                    if (isDebugging) {
                        // empty if block
                    }
                    missingValueCodeVector.add(missingValueCode);
                }
            }
            Attribute attObj = new Attribute(id, attName, attLabel, attDefinition, attUnit, attUnitType, attMeasurementScale, domain);
            for (StorageType storageType : storageTypeArray) {
                attObj.addStorageType(storageType);
            }
            for (int k = 0; k < missingValueCodeVector.size(); ++k) {
                String missingValueCode = (String)missingValueCodeVector.elementAt(k);
                if (isDebugging) {
                    // empty if block
                }
                attObj.addMissingValueCode(missingValueCode);
            }
            attributeList.add(attObj);
        }
    }

    private void processEntities(CachedXPathAPI xpathapi, NodeList entitiesNodeList, String xpath, String packageId) throws SAXException, TransformerException, Exception {
        if (entitiesNodeList == null) {
            return;
        }
        int entityNodeListLength = entitiesNodeList.getLength();
        this.numEntities += entityNodeListLength;
        String entityName = "";
        String entityDescription = "";
        String entityOrientation = "";
        String entityCaseSensitive = "";
        String entityNumberOfRecords = "-1";
        String onlineUrl = "";
        String numHeaderLines = "0";
        int numFooterLines = 0;
        String fieldDelimiter = null;
        String recordDelimiter = "";
        String compressionMethod = "";
        String encodingMethod = "";
        String quoteCharacter = null;
        String literalCharacter = null;
        boolean isImageEntity = false;
        boolean isGZipDataFile = false;
        boolean isZipDataFile = false;
        boolean isTarDataFile = false;
        boolean isSimpleDelimited = true;
        boolean isCollapseDelimiters = false;
        TextComplexDataFormat[] formatArray = null;
        for (int i = 0; i < entityNodeListLength; ++i) {
            NodeList encodingMethodNodeList;
            NodeList compressionMethodNodeList;
            NodeList recordDelimiterNodeList;
            NodeList complexNodeList;
            NodeList literalCharacterNodeList;
            NodeList quoteCharacterNodeList;
            String collapseDelimiters;
            NodeList collapseDelimitersNodeList;
            NodeList fieldDelimiterNodeList;
            Node numFooterLinesNode;
            NodeList numFooterLinesNodeList;
            Node numHeaderLinesNode;
            NodeList numHeaderLinesNodeList;
            Node idNode;
            if (xpath != null && (xpath.equals(SPATIALRASTERENTITY) || xpath.equals(SPATIALVECTORENTITY))) {
                isImageEntity = true;
            }
            ++this.elementId;
            Node entityNode = entitiesNodeList.item(i);
            String id = null;
            NamedNodeMap entityNodeAttributes = entityNode.getAttributes();
            if (entityNodeAttributes != null && (idNode = entityNodeAttributes.getNamedItem(ID)) != null) {
                id = idNode.getNodeValue();
            }
            NodeList entityNodeChildren = entityNode.getChildNodes();
            for (int j = 0; j < entityNodeChildren.getLength(); ++j) {
                Node childNode = entityNodeChildren.item(j);
                String childName = childNode.getNodeName();
                if (childName.equals("entityName")) {
                    entityName = childNode.getFirstChild().getNodeValue();
                    continue;
                }
                if (childName.equals("entityDescription")) {
                    entityDescription = childNode.getFirstChild().getNodeValue();
                    continue;
                }
                if (childName.equals("caseSensitive")) {
                    entityCaseSensitive = childNode.getFirstChild().getNodeValue();
                    continue;
                }
                if (!childName.equals("numberOfRecords")) continue;
                entityNumberOfRecords = childNode.getFirstChild().getNodeValue();
            }
            NodeList attributeOrientationNodeList = xpathapi.selectNodeList(entityNode, "physical/dataFormat/textFormat/attributeOrientation");
            if (attributeOrientationNodeList != null && attributeOrientationNodeList.getLength() > 0) {
                entityOrientation = attributeOrientationNodeList.item(0).getFirstChild().getNodeValue();
            }
            if ((numHeaderLinesNodeList = xpathapi.selectNodeList(entityNode, "physical/dataFormat/textFormat/numHeaderLines")) != null && numHeaderLinesNodeList.getLength() > 0 && (numHeaderLinesNode = numHeaderLinesNodeList.item(0)) != null) {
                numHeaderLines = numHeaderLinesNode.getFirstChild().getNodeValue();
            }
            if ((numFooterLinesNodeList = xpathapi.selectNodeList(entityNode, "physical/dataFormat/textFormat/numFooterLines")) != null && numFooterLinesNodeList.getLength() > 0 && (numFooterLinesNode = numFooterLinesNodeList.item(0)) != null) {
                String numFooterLinesStr = numFooterLinesNode.getFirstChild().getNodeValue();
                numFooterLines = new Integer(numFooterLinesStr.trim());
            }
            if ((fieldDelimiterNodeList = xpathapi.selectNodeList(entityNode, "physical/dataFormat/textFormat/simpleDelimited/fieldDelimiter")) != null && fieldDelimiterNodeList.getLength() > 0) {
                fieldDelimiter = fieldDelimiterNodeList.item(0).getFirstChild().getNodeValue();
            }
            if ((collapseDelimitersNodeList = xpathapi.selectNodeList(entityNode, "physical/dataFormat/textFormat/simpleDelimited/collapseDelimiters")) != null && collapseDelimitersNodeList.getLength() > 0 && (collapseDelimiters = collapseDelimitersNodeList.item(0).getFirstChild().getNodeValue()).equalsIgnoreCase("yes")) {
                isCollapseDelimiters = true;
            }
            if ((quoteCharacterNodeList = xpathapi.selectNodeList(entityNode, "physical/dataFormat/textFormat/simpleDelimited/quoteCharacter")) != null && quoteCharacterNodeList.getLength() > 0) {
                quoteCharacter = quoteCharacterNodeList.item(0).getFirstChild().getNodeValue();
            }
            if ((literalCharacterNodeList = xpathapi.selectNodeList(entityNode, "physical/dataFormat/textFormat/simpleDelimited/literalCharacter")) != null && literalCharacterNodeList.getLength() > 0) {
                literalCharacter = literalCharacterNodeList.item(0).getFirstChild().getNodeValue();
            }
            if ((complexNodeList = xpathapi.selectNodeList(entityNode, "physical/dataFormat/textFormat/complex")) != null && complexNodeList.getLength() > 0) {
                isSimpleDelimited = false;
                Node complexNode = complexNodeList.item(0);
                NodeList complexChildNodes = complexNode.getChildNodes();
                int complexChildNodesLength = complexChildNodes.getLength();
                Vector<TextComplexDataFormat> formatVector = new Vector<TextComplexDataFormat>();
                for (int k = 0; k < complexChildNodesLength; ++k) {
                    TextDelimitedDataFormat textDelimitedDataFormat;
                    Node complexChildNode = complexChildNodes.item(k);
                    if (complexChildNode != null && complexChildNode.getNodeName().equals("textFixed")) {
                        TextWidthFixedDataFormat textWidthFixedDataFormat = this.handleTextFixedDataFormatNode(complexChildNode);
                        if (textWidthFixedDataFormat == null) continue;
                        formatVector.add(textWidthFixedDataFormat);
                        continue;
                    }
                    if (complexChildNode == null || !complexChildNode.getNodeName().equals("textDelimited") || (textDelimitedDataFormat = this.handleComplexDelimitedDataFormatNode(complexChildNode)) == null) continue;
                    formatVector.add(textDelimitedDataFormat);
                }
                this.numberOfComplexFormats = formatVector.size();
                formatArray = new TextComplexDataFormat[this.numberOfComplexFormats];
                for (int j = 0; j < this.numberOfComplexFormats; ++j) {
                    formatArray[j] = (TextComplexDataFormat)formatVector.elementAt(j);
                }
            }
            recordDelimiter = (recordDelimiterNodeList = xpathapi.selectNodeList(entityNode, "physical/dataFormat/textFormat/recordDelimiter")) != null && recordDelimiterNodeList.getLength() > 0 ? recordDelimiterNodeList.item(0).getFirstChild().getNodeValue() : "\\r\\n";
            NodeList urlNodeList = xpathapi.selectNodeList(entityNode, "physical/distribution/online/url");
            if (urlNodeList != null && urlNodeList.getLength() > 0) {
                onlineUrl = urlNodeList.item(0).getFirstChild().getNodeValue();
                if (isDebugging) {
                    // empty if block
                }
            }
            if ((compressionMethodNodeList = xpathapi.selectNodeList(entityNode, "physical/compressionMethod")) != null && compressionMethodNodeList.getLength() > 0) {
                compressionMethod = compressionMethodNodeList.item(0).getFirstChild().getNodeValue();
                if (isDebugging) {
                    // empty if block
                }
                if (compressionMethod != null && compressionMethod.equals(Entity.GZIP)) {
                    isGZipDataFile = true;
                } else if (compressionMethod != null && compressionMethod.equals(Entity.ZIP)) {
                    isZipDataFile = true;
                }
            }
            if ((encodingMethodNodeList = xpathapi.selectNodeList(entityNode, "physical/encodingMethod")) != null && encodingMethodNodeList.getLength() > 0) {
                encodingMethod = encodingMethodNodeList.item(0).getFirstChild().getNodeValue();
                if (isDebugging) {
                    // empty if block
                }
                if (encodingMethod != null && encodingMethod.equals(Entity.TAR)) {
                    isTarDataFile = true;
                }
            }
            entityOrientation = entityOrientation.trim().equals("column") ? Entity.COLUMNMAJOR : Entity.ROWMAJOR;
            entityCaseSensitive = entityCaseSensitive.equals("yes") ? "true" : "false";
            this.entityObject = new Entity(id, entityName.trim(), entityDescription.trim(), new Boolean(entityCaseSensitive), entityOrientation, new Integer(entityNumberOfRecords));
            this.entityObject.setNumHeaderLines((int)new Integer(numHeaderLines));
            this.entityObject.setNumFooterLines(numFooterLines);
            this.entityObject.setSimpleDelimited(isSimpleDelimited);
            if (fieldDelimiter != null) {
                this.entityObject.setFieldDelimiter(fieldDelimiter);
            }
            if (quoteCharacter != null) {
                this.entityObject.setQuoteCharacter(quoteCharacter);
            }
            if (literalCharacter != null) {
                this.entityObject.setLiteralCharacter(literalCharacter);
            }
            this.entityObject.setCollapseDelimiters(isCollapseDelimiters);
            this.entityObject.setRecordDelimiter(recordDelimiter);
            this.entityObject.setURL(onlineUrl);
            this.entityObject.setCompressionMethod(compressionMethod);
            this.entityObject.setIsImageEntity(isImageEntity);
            this.entityObject.setHasGZipDataFile(isGZipDataFile);
            this.entityObject.setHasZipDataFile(isZipDataFile);
            this.entityObject.setHasTarDataFile(isTarDataFile);
            this.entityObject.setPackageId(packageId);
            try {
                NodeList attributeListNodeList = xpathapi.selectNodeList(entityNode, "attributeList");
                this.processAttributeList(xpathapi, attributeListNodeList, this.entityObject);
                this.entityObject.setDataFormatArray(formatArray);
            }
            catch (Exception e) {
                throw new Exception("Error parsing attributes: " + e.getMessage());
            }
            this.emlDataPackage.add(this.entityObject);
        }
    }

    private TextWidthFixedDataFormat handleTextFixedDataFormatNode(Node node) throws Exception {
        TextWidthFixedDataFormat textWidthFixedDataFormat = null;
        if (node == null) {
            return textWidthFixedDataFormat;
        }
        NodeList childNodes = node.getChildNodes();
        int length = childNodes.getLength();
        for (int i = 0; i < length; ++i) {
            Node childNode = childNodes.item(i);
            String elementName = childNode.getNodeName();
            if (elementName != null && elementName.equals("fieldWidth")) {
                String fieldWidthStr = childNode.getFirstChild().getNodeValue();
                int fieldWidth = new Integer(fieldWidthStr);
                if (isDebugging) {
                    // empty if block
                }
                textWidthFixedDataFormat = new TextWidthFixedDataFormat(fieldWidth);
                continue;
            }
            if (elementName != null && elementName.equals("fieldStartColumn") && textWidthFixedDataFormat != null) {
                String startColumnStr = childNode.getFirstChild().getNodeValue();
                int startColumn = new Integer(startColumnStr);
                if (isDebugging) {
                    // empty if block
                }
                textWidthFixedDataFormat.setFieldStartColumn(startColumn);
                continue;
            }
            if (elementName == null || !elementName.equals("lineNumber") || textWidthFixedDataFormat == null) continue;
            String lineNumberStr = childNode.getFirstChild().getNodeValue();
            int lineNumber = new Integer(lineNumberStr);
            if (isDebugging) {
                // empty if block
            }
            textWidthFixedDataFormat.setLineNumber(lineNumber);
        }
        return textWidthFixedDataFormat;
    }

    private TextDelimitedDataFormat handleComplexDelimitedDataFormatNode(Node node) throws Exception {
        TextDelimitedDataFormat textDelimitedDataFormat = null;
        if (node == null) {
            return textDelimitedDataFormat;
        }
        NodeList childNodes = node.getChildNodes();
        int length = childNodes.getLength();
        Vector<String> quoteList = new Vector<String>();
        for (int i = 0; i < length; ++i) {
            Node childNode = childNodes.item(i);
            String elementName = childNode.getNodeName();
            if (elementName != null && elementName.equals("fieldDelimiter")) {
                String fieldDelimiter = childNode.getFirstChild().getNodeValue();
                if (isDebugging) {
                    // empty if block
                }
                textDelimitedDataFormat = new TextDelimitedDataFormat(fieldDelimiter);
                continue;
            }
            if (elementName != null && elementName.equals("lineNumber") && textDelimitedDataFormat != null) {
                String lineNumberStr = childNode.getFirstChild().getNodeValue();
                int lineNumber = new Integer(lineNumberStr);
                if (isDebugging) {
                    // empty if block
                }
                textDelimitedDataFormat.setLineNumber(lineNumber);
                continue;
            }
            if (elementName != null && elementName.equals("collapseDelimiters") && textDelimitedDataFormat != null) {
                String collapseDelimiters = childNode.getFirstChild().getNodeValue();
                if (isDebugging) {
                    // empty if block
                }
                textDelimitedDataFormat.setCollapseDelimiters(collapseDelimiters);
                continue;
            }
            if (elementName == null || !elementName.equals("quoteCharacter") || textDelimitedDataFormat == null) continue;
            String quoteCharacter = childNode.getFirstChild().getNodeValue();
            quoteList.add(quoteCharacter);
        }
        if (textDelimitedDataFormat != null) {
            int size = quoteList.size();
            String[] quoteCharacterArray = new String[size];
            for (int i = 0; i < size; ++i) {
                quoteCharacterArray[i] = (String)quoteList.elementAt(i);
            }
            textDelimitedDataFormat.setQuoteCharacterArray(quoteCharacterArray);
        }
        return textDelimitedDataFormat;
    }
}

