/*
 * Decompiled with CFR 0.152.
 */
package ORG.oclc.oai.server.crosswalk;

import ORG.oclc.oai.server.verb.CannotDisseminateFormatException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public abstract class Crosswalk {
    private String schemaLocation;
    private String contentType;
    private String docType;
    private String encoding;

    public Crosswalk(String schemaLocation) {
        this(schemaLocation, null);
    }

    public Crosswalk(String schemaLocation, String contentType) {
        this(schemaLocation, contentType, null);
    }

    public Crosswalk(String schemaLocation, String contentType, String docType) {
        this(schemaLocation, contentType, docType, null);
    }

    public Crosswalk(String schemaLocation, String contentType, String docType, String encoding) {
        this.schemaLocation = schemaLocation;
        if (contentType == null) {
            contentType = "text/xml; charset=UTF-8";
        }
        this.contentType = contentType;
        this.docType = docType;
        this.encoding = encoding;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getDocType() {
        return this.docType;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getSchemaURL() {
        StringTokenizer tokenizer = new StringTokenizer(this.schemaLocation, " ");
        String temp = tokenizer.nextToken();
        try {
            return tokenizer.nextToken();
        }
        catch (NoSuchElementException e) {
            return temp;
        }
    }

    public String getNamespaceURL() {
        StringTokenizer tokenizer = new StringTokenizer(this.schemaLocation, " ");
        return tokenizer.nextToken();
    }

    public abstract boolean isAvailableFor(Object var1);

    public abstract String createMetadata(Object var1) throws CannotDisseminateFormatException;

    public String toString() {
        return this.schemaLocation;
    }
}

