/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.blocktreeords;

import java.io.IOException;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.fst.Outputs;

final class FSTOrdsOutputs
extends Outputs<Output> {
    public static final Output NO_OUTPUT = new Output(new BytesRef(), 0L, 0L);
    private static final BytesRef NO_BYTES = new BytesRef();

    FSTOrdsOutputs() {
    }

    public Output common(Output output1, Output output2) {
        BytesRef bytes1 = output1.bytes;
        BytesRef bytes2 = output2.bytes;
        assert (bytes1 != null);
        assert (bytes2 != null);
        int pos1 = bytes1.offset;
        int pos2 = bytes2.offset;
        int stopAt1 = pos1 + Math.min(bytes1.length, bytes2.length);
        while (pos1 < stopAt1 && bytes1.bytes[pos1] == bytes2.bytes[pos2]) {
            ++pos1;
            ++pos2;
        }
        BytesRef prefixBytes = pos1 == bytes1.offset ? NO_BYTES : (pos1 == bytes1.offset + bytes1.length ? bytes1 : (pos2 == bytes2.offset + bytes2.length ? bytes2 : new BytesRef(bytes1.bytes, bytes1.offset, pos1 - bytes1.offset)));
        return this.newOutput(prefixBytes, Math.min(output1.startOrd, output2.startOrd), Math.min(output1.endOrd, output2.endOrd));
    }

    public Output subtract(Output output, Output inc) {
        BytesRef suffix;
        assert (output != null);
        assert (inc != null);
        if (inc == NO_OUTPUT) {
            return output;
        }
        assert (StringHelper.startsWith((BytesRef)output.bytes, (BytesRef)inc.bytes));
        if (inc.bytes.length == output.bytes.length) {
            suffix = NO_BYTES;
        } else if (inc.bytes.length == 0) {
            suffix = output.bytes;
        } else {
            assert (inc.bytes.length < output.bytes.length) : "inc.length=" + inc.bytes.length + " vs output.length=" + output.bytes.length;
            assert (inc.bytes.length > 0);
            suffix = new BytesRef(output.bytes.bytes, output.bytes.offset + inc.bytes.length, output.bytes.length - inc.bytes.length);
        }
        assert (output.startOrd >= inc.startOrd);
        assert (output.endOrd >= inc.endOrd);
        return this.newOutput(suffix, output.startOrd - inc.startOrd, output.endOrd - inc.endOrd);
    }

    public Output add(Output prefix, Output output) {
        assert (prefix != null);
        assert (output != null);
        if (prefix == NO_OUTPUT) {
            return output;
        }
        if (output == NO_OUTPUT) {
            return prefix;
        }
        BytesRef bytes = new BytesRef(prefix.bytes.length + output.bytes.length);
        System.arraycopy(prefix.bytes.bytes, prefix.bytes.offset, bytes.bytes, 0, prefix.bytes.length);
        System.arraycopy(output.bytes.bytes, output.bytes.offset, bytes.bytes, prefix.bytes.length, output.bytes.length);
        bytes.length = prefix.bytes.length + output.bytes.length;
        return this.newOutput(bytes, prefix.startOrd + output.startOrd, prefix.endOrd + output.endOrd);
    }

    public void write(Output prefix, DataOutput out) throws IOException {
        out.writeVInt(prefix.bytes.length);
        out.writeBytes(prefix.bytes.bytes, prefix.bytes.offset, prefix.bytes.length);
        out.writeVLong(prefix.startOrd);
        out.writeVLong(prefix.endOrd);
    }

    public Output read(DataInput in) throws IOException {
        BytesRef bytes;
        int len = in.readVInt();
        if (len == 0) {
            bytes = NO_BYTES;
        } else {
            bytes = new BytesRef(len);
            in.readBytes(bytes.bytes, 0, len);
            bytes.length = len;
        }
        long startOrd = in.readVLong();
        long endOrd = in.readVLong();
        Output result = this.newOutput(bytes, startOrd, endOrd);
        return result;
    }

    public void skipOutput(DataInput in) throws IOException {
        int len = in.readVInt();
        in.skipBytes((long)len);
        in.readVLong();
        in.readVLong();
    }

    public void skipFinalOutput(DataInput in) throws IOException {
        this.skipOutput(in);
    }

    public Output getNoOutput() {
        return NO_OUTPUT;
    }

    public String outputToString(Output output) {
        if ((output.endOrd == 0L || output.endOrd == Long.MAX_VALUE) && output.startOrd == 0L) {
            return "";
        }
        return output.toString();
    }

    public Output newOutput(BytesRef bytes, long startOrd, long endOrd) {
        if (bytes.length == 0 && startOrd == 0L && endOrd == 0L) {
            return NO_OUTPUT;
        }
        return new Output(bytes, startOrd, endOrd);
    }

    public long ramBytesUsed(Output output) {
        return 2 * RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 16 + 2 * RamUsageEstimator.NUM_BYTES_OBJECT_REF + RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + 8 + output.bytes.length;
    }

    public static final class Output {
        public final BytesRef bytes;
        public final long startOrd;
        public final long endOrd;

        public Output(BytesRef bytes, long startOrd, long endOrd) {
            assert (startOrd >= 0L) : "startOrd=" + startOrd;
            assert (endOrd >= 0L) : "endOrd=" + endOrd;
            this.bytes = bytes;
            this.startOrd = startOrd;
            this.endOrd = endOrd;
        }

        public String toString() {
            long x;
            if (this.endOrd > 0x3FFFFFFFFFFFFFFFL) {
                x = Long.MAX_VALUE - this.endOrd;
            } else {
                assert (this.endOrd >= 0L);
                x = -this.endOrd;
            }
            return this.startOrd + " to " + x;
        }

        public int hashCode() {
            int hash = this.bytes.hashCode();
            hash = (int)((long)hash ^ this.startOrd);
            hash = (int)((long)hash ^ this.endOrd);
            return hash;
        }

        public boolean equals(Object _other) {
            if (_other instanceof Output) {
                Output other = (Output)_other;
                return this.bytes.equals((Object)other.bytes) && this.startOrd == other.startOrd && this.endOrd == other.endOrd;
            }
            return false;
        }
    }
}

