/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.awt.RenderingHints;
import org.geotools.factory.Hints;
import org.geotools.filter.AbstractFilter;
import org.geotools.filter.Filter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.Converters;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;

public abstract class BinaryComparisonAbstract
extends AbstractFilter
implements BinaryComparisonOperator {
    protected Expression expression1;
    protected Expression expression2;
    boolean matchingCase;

    protected BinaryComparisonAbstract(FilterFactory factory) {
        this(factory, null, null);
    }

    protected BinaryComparisonAbstract(FilterFactory factory, Expression expression1, Expression expression2) {
        this(factory, expression1, expression2, true);
    }

    protected BinaryComparisonAbstract(FilterFactory factory, Expression expression1, Expression expression2, boolean matchingCase) {
        super(factory);
        this.expression1 = expression1;
        this.expression2 = expression2;
        this.matchingCase = matchingCase;
    }

    public Expression getExpression1() {
        return this.expression1;
    }

    public void setExpression1(Expression expression) {
        this.expression1 = expression;
    }

    public Expression getExpression2() {
        return this.expression2;
    }

    public void setExpression2(Expression expression) {
        this.expression2 = expression;
    }

    public boolean isMatchingCase() {
        return this.matchingCase;
    }

    public Filter and(org.opengis.filter.Filter filter) {
        return (Filter)this.factory.and((org.opengis.filter.Filter)this, filter);
    }

    public Filter or(org.opengis.filter.Filter filter) {
        return (Filter)this.factory.or((org.opengis.filter.Filter)this, filter);
    }

    public Filter not() {
        return (Filter)this.factory.not((org.opengis.filter.Filter)this);
    }

    protected Object[] eval(Object object) {
        Object v1 = this.eval(this.getExpression1(), object);
        Object v2 = this.eval(this.getExpression2(), object);
        if (v1 != null && v2 != null) {
            if (v1.getClass().equals(v2.getClass())) {
                return new Object[]{v1, v2};
            }
            Hints hints = new Hints((RenderingHints.Key)ConverterFactory.SAFE_CONVERSION, (Object)Boolean.TRUE);
            Object o = Converters.convert((Object)v2, v1.getClass(), (Hints)hints);
            if (o != null) {
                return new Object[]{v1, o};
            }
            o = Converters.convert((Object)v1, v2.getClass(), (Hints)hints);
            if (o != null) {
                return new Object[]{o, v2};
            }
            hints.put((Object)ConverterFactory.SAFE_CONVERSION, (Object)Boolean.FALSE);
            o = Converters.convert((Object)v2, v1.getClass(), (Hints)hints);
            if (o != null) {
                return new Object[]{v1, o};
            }
            o = Converters.convert((Object)v1, v2.getClass(), (Hints)hints);
            if (o != null) {
                return new Object[]{o, v2};
            }
        }
        return new Object[]{v1, v2};
    }

    protected final Comparable comparable(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Comparable) {
            return (Comparable)value;
        }
        return String.valueOf(value);
    }
}

