/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.util.NoSuchElementException;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringFeatureIterator
implements FeatureIterator<SimpleFeature> {
    protected FeatureIterator<SimpleFeature> delegate;
    protected Filter filter;
    protected SimpleFeature next;

    public FilteringFeatureIterator(FeatureIterator<SimpleFeature> delegate, Filter filter) {
        this.delegate = delegate;
        this.filter = filter;
    }

    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        while (this.delegate.hasNext()) {
            SimpleFeature peek = (SimpleFeature)this.delegate.next();
            if (!this.filter.evaluate((Object)peek)) continue;
            this.next = peek;
            break;
        }
        return this.next != null;
    }

    public SimpleFeature next() throws NoSuchElementException {
        SimpleFeature f = this.next;
        this.next = null;
        return f;
    }

    public void close() {
        this.delegate.close();
        this.delegate = null;
        this.next = null;
        this.filter = null;
    }
}

