/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.AbstractDataStore;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.collection.CollectionDataStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.NameImpl;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.geotools.feature.type.AttributeTypeImpl;
import org.geotools.feature.type.GeometryDescriptorImpl;
import org.geotools.feature.type.GeometryTypeImpl;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.CRS;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.Converters;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataUtilities {
    static Map<String, Class> typeMap = new HashMap<String, Class>();
    static Map<Class, String> typeEncode = new HashMap<Class, String>();
    static FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);

    public static String[] attributeNames(SimpleFeatureType featureType) {
        String[] names = new String[featureType.getAttributeCount()];
        int count = featureType.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            names[i] = featureType.getDescriptor(i).getLocalName();
        }
        return names;
    }

    public static URL fileToURL(File file) {
        try {
            URL url = file.toURI().toURL();
            String string = url.toExternalForm();
            if (string.contains("+")) {
                string = string.replace("+", "%2B");
            }
            if (string.contains(" ")) {
                string = string.replace(" ", "%20");
            }
            return new URL(string);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static File urlToFile(URL url) {
        String path3;
        if (!"file".equals(url.getProtocol())) {
            return null;
        }
        String string = url.toExternalForm();
        if (string.contains("+")) {
            string = string.replace("+", "%2B");
        }
        try {
            string = URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Could not decode the URL to UTF-8 format", e);
        }
        String simplePrefix = "file:/";
        String standardPrefix = "file://";
        String os = System.getProperty("os.name");
        if (os.toUpperCase().contains("WINDOWS") && string.startsWith(standardPrefix)) {
            path3 = string.substring(standardPrefix.length() - 2);
        } else if (string.startsWith(standardPrefix)) {
            path3 = string.substring(standardPrefix.length());
        } else if (string.startsWith(simplePrefix)) {
            path3 = string.substring(simplePrefix.length() - 1);
        } else {
            String auth = url.getAuthority();
            String path2 = url.getPath().replace("%20", " ");
            path3 = auth != null && !auth.equals("") ? "//" + auth + path2 : path2;
        }
        return new File(path3);
    }

    public static String[] attributeNames(Filter filter, SimpleFeatureType featureType) {
        if (filter == null) {
            return new String[0];
        }
        FilterAttributeExtractor attExtractor = new FilterAttributeExtractor(featureType);
        filter.accept((FilterVisitor)attExtractor, null);
        String[] attributeNames = attExtractor.getAttributeNames();
        return attributeNames;
    }

    public static String[] attributeNames(Filter filter) {
        return DataUtilities.attributeNames(filter, null);
    }

    public static String[] attributeNames(Expression expression, SimpleFeatureType featureType) {
        if (expression == null) {
            return new String[0];
        }
        FilterAttributeExtractor attExtractor = new FilterAttributeExtractor(featureType);
        expression.accept((ExpressionVisitor)attExtractor, null);
        String[] attributeNames = attExtractor.getAttributeNames();
        return attributeNames;
    }

    public static String[] attributeNames(Expression expression) {
        return DataUtilities.attributeNames(expression, null);
    }

    public static int compare(SimpleFeatureType typeA, SimpleFeatureType typeB) {
        int countB;
        if (typeA == typeB) {
            return 0;
        }
        if (typeA == null) {
            return -1;
        }
        if (typeB == null) {
            return -1;
        }
        int countA = typeA.getAttributeCount();
        if (countA > (countB = typeB.getAttributeCount())) {
            return -1;
        }
        int match = 0;
        for (int i = 0; i < countA; ++i) {
            AttributeDescriptor a = typeA.getDescriptor(i);
            if (DataUtilities.isMatch(a, typeB.getDescriptor(i))) {
                ++match;
                continue;
            }
            if (DataUtilities.isMatch(a, typeB.getDescriptor(a.getLocalName()))) continue;
            return -1;
        }
        if (countA == countB && match == countA) {
            return 0;
        }
        return 1;
    }

    public static boolean isMatch(AttributeDescriptor a, AttributeDescriptor b) {
        if (a == b) {
            return true;
        }
        if (b == null) {
            return false;
        }
        if (a == null) {
            return false;
        }
        if (a.equals(b)) {
            return true;
        }
        return a.getLocalName().equals(b.getLocalName()) && a.getClass().equals(b.getClass());
    }

    public static SimpleFeature reType(SimpleFeatureType featureType, SimpleFeature feature) throws IllegalAttributeException {
        SimpleFeatureType origional = feature.getFeatureType();
        if (featureType.equals(origional)) {
            return SimpleFeatureBuilder.copy(feature);
        }
        String id = feature.getID();
        int numAtts = featureType.getAttributeCount();
        Object[] attributes = new Object[numAtts];
        for (int i = 0; i < numAtts; ++i) {
            AttributeDescriptor curAttType = featureType.getDescriptor(i);
            String xpath = curAttType.getLocalName();
            attributes[i] = DataUtilities.duplicate(feature.getAttribute(xpath));
        }
        return SimpleFeatureBuilder.build(featureType, attributes, id);
    }

    public static Object duplicate(Object src) {
        if (src == null) {
            return null;
        }
        if (src instanceof String || src instanceof Integer || src instanceof Double || src instanceof Float || src instanceof Byte || src instanceof Boolean || src instanceof Short || src instanceof Long || src instanceof Character || src instanceof Number) {
            return src;
        }
        if (src instanceof Date) {
            return new Date(((Date)src).getTime());
        }
        if (src instanceof URL || src instanceof URI) {
            return src;
        }
        if (src instanceof Object[]) {
            Object[] array = (Object[])src;
            Object[] copy = new Object[array.length];
            for (int i = 0; i < array.length; ++i) {
                copy[i] = DataUtilities.duplicate(array[i]);
            }
            return copy;
        }
        if (src instanceof Geometry) {
            Geometry geometry = (Geometry)src;
            return geometry.clone();
        }
        if (src instanceof SimpleFeature) {
            SimpleFeature feature = (SimpleFeature)src;
            return SimpleFeatureBuilder.copy(feature);
        }
        Class<?> type = src.getClass();
        if (type.isArray() && type.getComponentType().isPrimitive()) {
            int length = Array.getLength(src);
            Object copy = Array.newInstance(type.getComponentType(), length);
            System.arraycopy(src, 0, copy, 0, length);
            return copy;
        }
        if (type.isArray()) {
            int length = Array.getLength(src);
            Object copy = Array.newInstance(type.getComponentType(), length);
            for (int i = 0; i < length; ++i) {
                Array.set(copy, i, DataUtilities.duplicate(Array.get(src, i)));
            }
            return copy;
        }
        if (src instanceof List) {
            List list = (List)src;
            ArrayList<Object> copy = new ArrayList<Object>(list.size());
            Iterator i = list.iterator();
            while (i.hasNext()) {
                copy.add(DataUtilities.duplicate(i.next()));
            }
            return Collections.unmodifiableList(copy);
        }
        if (src instanceof Map) {
            Map map = (Map)src;
            HashMap copy = new HashMap(map.size());
            for (Map.Entry entry : map.entrySet()) {
                copy.put(entry.getKey(), DataUtilities.duplicate(entry.getValue()));
            }
            return Collections.unmodifiableMap(copy);
        }
        if (src instanceof GridCoverage) {
            return src;
        }
        throw new IllegalAttributeException("Do not know how to deep copy " + type.getName());
    }

    public static SimpleFeature template(SimpleFeatureType featureType) throws IllegalAttributeException {
        return SimpleFeatureBuilder.build(featureType, DataUtilities.defaultValues(featureType), null);
    }

    public static SimpleFeature template(SimpleFeatureType featureType, String featureID) throws IllegalAttributeException {
        return SimpleFeatureBuilder.build(featureType, DataUtilities.defaultValues(featureType), featureID);
    }

    public static Object[] defaultValues(SimpleFeatureType featureType) throws IllegalAttributeException {
        return DataUtilities.defaultValues(featureType, null);
    }

    public static SimpleFeature template(SimpleFeatureType featureType, Object[] atts) throws IllegalAttributeException {
        return SimpleFeatureBuilder.build(featureType, DataUtilities.defaultValues(featureType, atts), null);
    }

    public static SimpleFeature template(SimpleFeatureType featureType, String featureID, Object[] atts) throws IllegalAttributeException {
        return SimpleFeatureBuilder.build(featureType, DataUtilities.defaultValues(featureType, atts), featureID);
    }

    public static Object[] defaultValues(SimpleFeatureType featureType, Object[] values) throws IllegalAttributeException {
        if (values == null) {
            values = new Object[featureType.getAttributeCount()];
        } else if (values.length != featureType.getAttributeCount()) {
            throw new ArrayIndexOutOfBoundsException("values");
        }
        for (int i = 0; i < featureType.getAttributeCount(); ++i) {
            values[i] = DataUtilities.defaultValue(featureType.getDescriptor(i));
        }
        return values;
    }

    public static Object defaultValue(AttributeDescriptor attributeType) throws IllegalAttributeException {
        Object value = attributeType.getDefaultValue();
        if (value == null && !attributeType.isNillable()) {
            return null;
        }
        return value;
    }

    public static Object defaultValue(Class type) {
        if (type == String.class || type == Object.class) {
            return "";
        }
        if (type == Integer.class) {
            return new Integer(0);
        }
        if (type == Double.class) {
            return new Double(0.0);
        }
        if (type == Long.class) {
            return new Long(0L);
        }
        if (type == Short.class) {
            return new Short(0);
        }
        if (type == Float.class) {
            return new Float(0.0f);
        }
        if (type == BigDecimal.class) {
            return BigDecimal.valueOf(0L);
        }
        if (type == BigInteger.class) {
            return BigInteger.valueOf(0L);
        }
        if (type == Character.class) {
            return new Character(' ');
        }
        if (type == Boolean.class) {
            return Boolean.FALSE;
        }
        if (type == Timestamp.class) {
            return new Timestamp(System.currentTimeMillis());
        }
        if (type == java.sql.Date.class) {
            return new java.sql.Date(System.currentTimeMillis());
        }
        if (type == Time.class) {
            return new Time(System.currentTimeMillis());
        }
        if (type == Date.class) {
            return new Date();
        }
        GeometryFactory fac = new GeometryFactory();
        Coordinate coordinate = new Coordinate(0.0, 0.0);
        Point point = fac.createPoint(coordinate);
        if (type == Point.class) {
            return point;
        }
        if (type == MultiPoint.class) {
            return fac.createMultiPoint(new Point[]{point});
        }
        if (type == LineString.class) {
            return fac.createLineString(new Coordinate[]{coordinate, coordinate, coordinate, coordinate});
        }
        LinearRing linearRing = fac.createLinearRing(new Coordinate[]{coordinate, coordinate, coordinate, coordinate});
        if (type == LinearRing.class) {
            return linearRing;
        }
        if (type == MultiLineString.class) {
            return fac.createMultiLineString(new LineString[]{linearRing});
        }
        Polygon polygon = fac.createPolygon(linearRing, new LinearRing[0]);
        if (type == Polygon.class) {
            return polygon;
        }
        if (type == MultiPolygon.class) {
            return fac.createMultiPolygon(new Polygon[]{polygon});
        }
        throw new IllegalArgumentException(type + " is not supported by this method");
    }

    public static FeatureReader<SimpleFeatureType, SimpleFeature> reader(final SimpleFeature[] features) throws IOException {
        if (features == null || features.length == 0) {
            throw new IOException("Provided features where empty");
        }
        return new FeatureReader<SimpleFeatureType, SimpleFeature>(){
            SimpleFeature[] array;
            int offset;
            {
                this.array = features;
                this.offset = -1;
            }

            public SimpleFeatureType getFeatureType() {
                return features[0].getFeatureType();
            }

            public SimpleFeature next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No more features");
                }
                return this.array[++this.offset];
            }

            public boolean hasNext() {
                return this.array != null && this.offset < this.array.length - 1;
            }

            public void close() {
                this.array = null;
                this.offset = -1;
            }
        };
    }

    public static FeatureSource<SimpleFeatureType, SimpleFeature> source(final SimpleFeature[] featureArray) {
        final SimpleFeatureType featureType = featureArray == null || featureArray.length == 0 ? FeatureTypes.EMPTY : featureArray[0].getFeatureType();
        AbstractDataStore arrayStore = new AbstractDataStore(){

            @Override
            public String[] getTypeNames() {
                return new String[]{featureType.getTypeName()};
            }

            @Override
            public SimpleFeatureType getSchema(String typeName) throws IOException {
                if (typeName != null && typeName.equals(featureType.getTypeName())) {
                    return featureType;
                }
                throw new IOException(typeName + " not available");
            }

            @Override
            protected FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(String typeName) throws IOException {
                return DataUtilities.reader(featureArray);
            }
        };
        try {
            return arrayStore.getFeatureSource(arrayStore.getTypeNames()[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Something is wrong with the geotools code, this exception should not happen", e);
        }
    }

    public static FeatureSource<SimpleFeatureType, SimpleFeature> source(FeatureCollection<SimpleFeatureType, SimpleFeature> collection) {
        if (collection == null) {
            throw new NullPointerException();
        }
        CollectionDataStore store = new CollectionDataStore(collection);
        try {
            return store.getFeatureSource(store.getTypeNames()[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("FeatureCollection is not consistent, unable to access contents", e);
        }
    }

    public static FeatureCollection<SimpleFeatureType, SimpleFeature> results(SimpleFeature[] featureArray) {
        return DataUtilities.results(DataUtilities.collection(featureArray));
    }

    public static FeatureCollection<SimpleFeatureType, SimpleFeature> results(FeatureCollection<SimpleFeatureType, SimpleFeature> collection) {
        if (collection.size() == 0) {
            // empty if block
        }
        return collection;
    }

    public static FeatureReader<SimpleFeatureType, SimpleFeature> reader(Collection<SimpleFeature> collection) throws IOException {
        return DataUtilities.reader(collection.toArray(new SimpleFeature[collection.size()]));
    }

    public static FeatureReader<SimpleFeatureType, SimpleFeature> reader(FeatureCollection<SimpleFeatureType, SimpleFeature> collection) throws IOException {
        return DataUtilities.reader((SimpleFeature[])collection.toArray((Object[])new SimpleFeature[collection.size()]));
    }

    public static FeatureCollection<SimpleFeatureType, SimpleFeature> collection(SimpleFeature[] features) {
        FeatureCollection<SimpleFeatureType, SimpleFeature> collection = FeatureCollections.newCollection();
        int length = features.length;
        for (int i = 0; i < length; ++i) {
            collection.add((Feature)features[i]);
        }
        return collection;
    }

    public static DefaultFeatureCollection collection(FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection) {
        return new DefaultFeatureCollection(featureCollection);
    }

    public static List<SimpleFeature> list(FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection) {
        final ArrayList<SimpleFeature> list = new ArrayList<SimpleFeature>();
        try {
            featureCollection.accepts(new FeatureVisitor(){

                public void visit(Feature feature) {
                    list.add((SimpleFeature)feature);
                }
            }, null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return list;
    }

    public static Set<String> fidSet(FeatureCollection<?, ?> featureCollection) {
        final HashSet<String> fids = new HashSet<String>();
        try {
            featureCollection.accepts(new FeatureVisitor(){

                public void visit(Feature feature) {
                    fids.add(feature.getIdentifier().getID());
                }
            }, null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return fids;
    }

    public static FeatureCollection<SimpleFeatureType, SimpleFeature> collection(List<SimpleFeature> list) {
        FeatureCollection<SimpleFeatureType, SimpleFeature> collection = FeatureCollections.newCollection();
        for (SimpleFeature feature : list) {
            collection.add((Feature)feature);
        }
        return collection;
    }

    public static FeatureCollection<SimpleFeatureType, SimpleFeature> collection(SimpleFeature feature) {
        FeatureCollection<SimpleFeatureType, SimpleFeature> collection = FeatureCollections.newCollection();
        collection.add((Feature)feature);
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FeatureCollection<SimpleFeatureType, SimpleFeature> collection(FeatureReader<SimpleFeatureType, SimpleFeature> reader) throws IOException {
        FeatureCollection<SimpleFeatureType, SimpleFeature> collection = FeatureCollections.newCollection();
        try {
            while (reader.hasNext()) {
                try {
                    collection.add(reader.next());
                }
                catch (NoSuchElementException e) {
                    throw (IOException)new IOException("EOF").initCause(e);
                }
                catch (IllegalAttributeException e) {
                    throw (IOException)new IOException().initCause(e);
                    return collection;
                }
            }
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FeatureCollection<SimpleFeatureType, SimpleFeature> collection(FeatureIterator<SimpleFeature> reader) throws IOException {
        FeatureCollection<SimpleFeatureType, SimpleFeature> collection = FeatureCollections.newCollection();
        try {
            while (reader.hasNext()) {
                try {
                    collection.add(reader.next());
                }
                catch (NoSuchElementException e) {
                    throw (IOException)new IOException("EOF").initCause(e);
                    return collection;
                }
            }
        }
        finally {
            reader.close();
        }
    }

    public static boolean attributesEqual(Object att, Object otherAtt) {
        if (att == null) {
            if (otherAtt != null) {
                return false;
            }
        } else if (!att.equals(otherAtt)) {
            if (att instanceof Geometry && otherAtt instanceof Geometry) {
                if (!((Geometry)att).equals((Geometry)otherAtt)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public static SimpleFeatureType createSubType(SimpleFeatureType featureType, String[] properties, CoordinateReferenceSystem override) throws SchemaException {
        URI namespaceURI = null;
        if (featureType.getName().getNamespaceURI() != null) {
            try {
                namespaceURI = new URI(featureType.getName().getNamespaceURI());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return DataUtilities.createSubType(featureType, properties, override, featureType.getTypeName(), namespaceURI);
    }

    public static SimpleFeatureType createSubType(SimpleFeatureType featureType, String[] properties, CoordinateReferenceSystem override, String typeName, URI namespace) throws SchemaException {
        if (properties == null && override == null) {
            return featureType;
        }
        if (properties == null) {
            properties = new String[featureType.getAttributeCount()];
            for (int i = 0; i < properties.length; ++i) {
                properties[i] = featureType.getDescriptor(i).getLocalName();
            }
        }
        String namespaceURI = namespace != null ? namespace.toString() : null;
        boolean same = featureType.getAttributeCount() == properties.length && featureType.getTypeName().equals(typeName) && Utilities.equals((Object)featureType.getName().getNamespaceURI(), (Object)namespaceURI);
        for (int i = 0; i < featureType.getAttributeCount() && same; ++i) {
            AttributeDescriptor type = featureType.getDescriptor(i);
            same = type.getLocalName().equals(properties[i]) && (override == null || !(type instanceof GeometryDescriptor) || DataUtilities.assertEquals(override, ((GeometryDescriptor)type).getCoordinateReferenceSystem()));
        }
        if (same) {
            return featureType;
        }
        AttributeDescriptor[] types = new AttributeDescriptor[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            types[i] = featureType.getDescriptor(properties[i]);
            if (override == null || !(types[i] instanceof GeometryDescriptor)) continue;
            AttributeTypeBuilder ab = new AttributeTypeBuilder();
            ab.init(types[i]);
            ab.setCRS(override);
            types[i] = ab.buildDescriptor(types[i].getLocalName(), ab.buildGeometryType());
        }
        if (typeName == null) {
            typeName = featureType.getTypeName();
        }
        if (namespace == null && featureType.getName().getNamespaceURI() != null) {
            try {
                namespace = new URI(featureType.getName().getNamespaceURI());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName(typeName);
        tb.setNamespaceURI(namespace);
        tb.addAll(types);
        return tb.buildFeatureType();
    }

    private static boolean assertEquals(Object o1, Object o2) {
        return o1 == null && o2 == null ? true : (o1 != null ? o1.equals(o2) : false);
    }

    public static SimpleFeatureType createSubType(SimpleFeatureType featureType, String[] properties) throws SchemaException {
        if (properties == null) {
            return featureType;
        }
        boolean same = featureType.getAttributeCount() == properties.length;
        for (int i = 0; i < featureType.getAttributeCount() && same; ++i) {
            same = featureType.getDescriptor(i).getLocalName().equals(properties[i]);
        }
        if (same) {
            return featureType;
        }
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName(featureType.getName());
        for (int i = 0; i < properties.length; ++i) {
            tb.add(featureType.getDescriptor(properties[i]));
        }
        return tb.buildFeatureType();
    }

    public static SimpleFeatureType createType(String identification, String typeSpec) throws SchemaException {
        int split = identification.lastIndexOf(46);
        String namespace = split == -1 ? null : identification.substring(0, split);
        String typeName = split == -1 ? identification : identification.substring(split + 1);
        return DataUtilities.createType(namespace, typeName, typeSpec);
    }

    public static SimpleFeatureType createType(String namespace, String typeName, String typeSpec) throws SchemaException {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName(typeName);
        tb.setNamespaceURI(namespace);
        String[] types = typeSpec.split(",");
        for (int i = 0; i < types.length; ++i) {
            boolean defaultGeometry = types[i].startsWith("*");
            if (types[i].startsWith("*")) {
                types[i] = types[i].substring(1);
            }
            AttributeDescriptor attributeType = DataUtilities.createAttribute(types[i]);
            tb.add(attributeType);
            if (!defaultGeometry) continue;
            tb.setDefaultGeometry(attributeType.getLocalName());
        }
        return tb.buildFeatureType();
    }

    public static SimpleFeature parse(SimpleFeatureType type, String fid, String[] text) throws IllegalAttributeException {
        Object[] attributes = new Object[text.length];
        for (int i = 0; i < text.length; ++i) {
            AttributeType attType = type.getDescriptor(i).getType();
            attributes[i] = Converters.convert((Object)text[i], (Class)attType.getBinding());
        }
        return SimpleFeatureBuilder.build(type, attributes, fid);
    }

    public static String spec(FeatureType featureType) {
        Collection types = featureType.getDescriptors();
        StringBuffer buf = new StringBuffer();
        for (PropertyDescriptor type : types) {
            GeometryDescriptor gd;
            buf.append(type.getName().getLocalPart());
            buf.append(":");
            buf.append(DataUtilities.typeMap(type.getType().getBinding()));
            if (type instanceof GeometryDescriptor && (gd = (GeometryDescriptor)type).getCoordinateReferenceSystem() != null && gd.getCoordinateReferenceSystem().getIdentifiers() != null) {
                for (ReferenceIdentifier id : gd.getCoordinateReferenceSystem().getIdentifiers()) {
                    if (id.getAuthority() == null || !id.getAuthority().getTitle().equals(Citations.EPSG.getTitle())) continue;
                    buf.append(":srid=" + id.getCode());
                    break;
                }
            }
            buf.append(",");
        }
        buf.delete(buf.length() - 1, buf.length());
        return buf.toString();
    }

    static Class type(String typeName) throws ClassNotFoundException {
        if (typeMap.containsKey(typeName)) {
            return typeMap.get(typeName);
        }
        return Class.forName(typeName);
    }

    static String typeMap(Class type) {
        if (typeEncode.containsKey(type)) {
            return typeEncode.get(type);
        }
        return type.getName();
    }

    public static Query mixQueries(Query firstQuery, Query secondQuery, String handle) {
        String version;
        if (firstQuery == null || secondQuery == null) {
            throw new NullPointerException("got a null query argument");
        }
        if (firstQuery.equals(Query.ALL)) {
            return secondQuery;
        }
        if (secondQuery.equals(Query.ALL)) {
            return firstQuery;
        }
        if (firstQuery.getTypeName() != null && secondQuery.getTypeName() != null && !firstQuery.getTypeName().equals(secondQuery.getTypeName())) {
            String msg = "Type names do not match: " + firstQuery.getTypeName() + " != " + secondQuery.getTypeName();
            throw new IllegalArgumentException(msg);
        }
        if (firstQuery.getVersion() != null) {
            if (secondQuery.getVersion() != null && !secondQuery.getVersion().equals(firstQuery.getVersion())) {
                throw new IllegalArgumentException("First and second query refer different versions");
            }
            version = firstQuery.getVersion();
        } else {
            version = secondQuery.getVersion();
        }
        int maxFeatures = Math.min(firstQuery.getMaxFeatures(), secondQuery.getMaxFeatures());
        String[] propNames = DataUtilities.joinAttributes(firstQuery.getPropertyNames(), secondQuery.getPropertyNames());
        Filter filter = firstQuery.getFilter();
        Filter filter2 = secondQuery.getFilter();
        if (filter == null || filter.equals(Filter.INCLUDE)) {
            filter = filter2;
        } else if (filter2 != null && !filter2.equals(Filter.INCLUDE)) {
            filter = ff.and(filter, filter2);
        }
        Integer start = 0;
        if (firstQuery.getStartIndex() != null) {
            start = firstQuery.getStartIndex();
        }
        if (secondQuery.getStartIndex() != null) {
            start = start + secondQuery.getStartIndex();
        }
        String typeName = firstQuery.getTypeName() != null ? firstQuery.getTypeName() : secondQuery.getTypeName();
        DefaultQuery mixed = new DefaultQuery(typeName, filter, maxFeatures, propNames, handle);
        mixed.setVersion(version);
        if (start != 0) {
            mixed.setStartIndex(start);
        }
        return mixed;
    }

    private static String[] joinAttributes(String[] atts1, String[] atts2) {
        String[] propNames = null;
        if (atts1 == null && atts2 == null) {
            return null;
        }
        LinkedList<String> atts = new LinkedList<String>();
        if (atts1 != null) {
            atts.addAll(Arrays.asList(atts1));
        }
        if (atts2 != null) {
            for (int i = 0; i < atts2.length; ++i) {
                if (atts.contains(atts2[i])) continue;
                atts.add(atts2[i]);
            }
        }
        propNames = new String[atts.size()];
        atts.toArray(propNames);
        return propNames;
    }

    static AttributeDescriptor createAttribute(String typeSpec) throws SchemaException {
        String type;
        String name;
        int split = typeSpec.indexOf(":");
        String hint = null;
        if (split == -1) {
            name = typeSpec;
            type = "String";
        } else {
            name = typeSpec.substring(0, split);
            int split2 = typeSpec.indexOf(":", split + 1);
            if (split2 == -1) {
                type = typeSpec.substring(split + 1);
            } else {
                type = typeSpec.substring(split + 1, split2);
                hint = typeSpec.substring(split2 + 1);
            }
        }
        try {
            AttributeTypeImpl at;
            Class clazz;
            boolean nillable = true;
            CoordinateReferenceSystem crs = null;
            if (hint != null) {
                StringTokenizer st = new StringTokenizer(hint, ";");
                while (st.hasMoreTokens()) {
                    String h = st.nextToken();
                    if ((h = h.trim()).equals("nillable")) {
                        nillable = true;
                    }
                    if (!h.startsWith("srid=")) continue;
                    String srid = h.split("=")[1];
                    Integer.parseInt(srid);
                    try {
                        crs = CRS.decode((String)("EPSG:" + srid));
                    }
                    catch (Exception e) {
                        String msg = "Error decoding srs: " + srid;
                        throw new SchemaException(msg, (Throwable)e);
                    }
                }
            }
            if (Geometry.class.isAssignableFrom(clazz = DataUtilities.type(type))) {
                at = new GeometryTypeImpl((Name)new NameImpl(name), clazz, crs, false, false, Collections.EMPTY_LIST, null, null);
                return new GeometryDescriptorImpl((GeometryType)at, (Name)new NameImpl(name), 0, 1, nillable, null);
            }
            at = new AttributeTypeImpl((Name)new NameImpl(name), clazz, false, false, Collections.EMPTY_LIST, null, null);
            return new AttributeDescriptorImpl(at, (Name)new NameImpl(name), 0, 1, nillable, null);
        }
        catch (ClassNotFoundException e) {
            throw new SchemaException("Could not type " + name + " as:" + type, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Envelope bounds(FeatureCollection<? extends FeatureType, ? extends Feature> collection) {
        FeatureIterator i = collection.features();
        try {
            ReferencedEnvelope bounds = new ReferencedEnvelope(collection.getSchema().getCoordinateReferenceSystem());
            if (!i.hasNext()) {
                bounds.setToNull();
                ReferencedEnvelope referencedEnvelope = bounds;
                return referencedEnvelope;
            }
            bounds.init(((SimpleFeature)i.next()).getBounds());
            ReferencedEnvelope referencedEnvelope = bounds;
            return referencedEnvelope;
        }
        finally {
            i.close();
        }
    }

    public static URL changeUrlExt(URL url, String postfix) throws IllegalArgumentException {
        String a = url.toExternalForm();
        int lastDotPos = a.lastIndexOf(46);
        if (lastDotPos >= 0) {
            a = a.substring(0, lastDotPos);
        }
        a = a + "." + postfix;
        try {
            return new URL(a);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("can't create a new URL for " + url + " with new extension " + postfix, e);
        }
    }

    public static URL getParentUrl(URL url) throws MalformedURLException {
        String a = url.toExternalForm();
        int lastDotPos = a.lastIndexOf(47);
        if (lastDotPos >= 0) {
            a = a.substring(0, lastDotPos);
        }
        if (a.endsWith("!")) {
            a = a + "/";
        }
        return new URL(a);
    }

    public static URL extendURL(URL base, String extension) throws MalformedURLException {
        if (base == null) {
            throw new NullPointerException(Errors.format((int)143, (Object)"base"));
        }
        if (extension == null) {
            throw new NullPointerException(Errors.format((int)143, (Object)"extension"));
        }
        String a = base.toExternalForm();
        if (!a.endsWith("/")) {
            a = a + "/";
        }
        a = a + extension;
        return new URL(a);
    }

    public static boolean checkFileReadable(File file, Logger logger) {
        if (logger != null && logger.isLoggable(Level.FINE)) {
            StringBuilder builder = new StringBuilder("Checking file:").append(file.getAbsolutePath()).append("\n").append("canRead:").append(file.canRead()).append("\n").append("isHidden:").append(file.isHidden()).append("\n").append("isFile").append(file.isFile()).append("\n").append("canWrite").append(file.canWrite()).append("\n");
            logger.fine(builder.toString());
        }
        return file.exists() && file.canRead() && file.isFile();
    }

    public static File checkDirectory(File file) throws IllegalArgumentException {
        String directoryPath = file.getPath();
        File inDir = file;
        if (!inDir.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + directoryPath);
        }
        if (!inDir.canRead()) {
            throw new IllegalArgumentException("Not a writable directory: " + directoryPath);
        }
        try {
            directoryPath = inDir.getCanonicalPath();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        inDir = new File(directoryPath);
        if (!inDir.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + directoryPath);
        }
        if (!inDir.canRead()) {
            throw new IllegalArgumentException("Not a writable directory: " + directoryPath);
        }
        return new File(directoryPath);
    }

    public static FilenameFilter excludeFilters(final FilenameFilter inputFilter, final FilenameFilter ... filters) {
        return new FilenameFilter(){

            public boolean accept(File dir, String name) {
                if (inputFilter.accept(dir, name)) {
                    for (FilenameFilter exclude : filters) {
                        if (!exclude.accept(dir, name)) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
        };
    }

    public static FilenameFilter includeFilters(final FilenameFilter inputFilter, final FilenameFilter ... filters) {
        return new FilenameFilter(){

            public boolean accept(File dir, String name) {
                if (inputFilter.accept(dir, name)) {
                    return true;
                }
                for (FilenameFilter include : filters) {
                    if (!include.accept(dir, name)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    static {
        typeEncode.put(String.class, "String");
        typeMap.put("String", String.class);
        typeMap.put("string", String.class);
        typeMap.put("\"\"", String.class);
        typeEncode.put(Integer.class, "Integer");
        typeMap.put("Integer", Integer.class);
        typeMap.put("int", Integer.class);
        typeMap.put("0", Integer.class);
        typeEncode.put(Double.class, "Double");
        typeMap.put("Double", Double.class);
        typeMap.put("double", Double.class);
        typeMap.put("0.0", Double.class);
        typeEncode.put(Float.class, "Float");
        typeMap.put("Float", Float.class);
        typeMap.put("float", Float.class);
        typeMap.put("0.0f", Float.class);
        typeEncode.put(Boolean.class, "Boolean");
        typeMap.put("Boolean", Boolean.class);
        typeMap.put("true", Boolean.class);
        typeMap.put("false", Boolean.class);
        typeEncode.put(Geometry.class, "Geometry");
        typeMap.put("Geometry", Geometry.class);
        typeEncode.put(Point.class, "Point");
        typeMap.put("Point", Point.class);
        typeEncode.put(LineString.class, "LineString");
        typeMap.put("LineString", LineString.class);
        typeEncode.put(Polygon.class, "Polygon");
        typeMap.put("Polygon", Polygon.class);
        typeEncode.put(MultiPoint.class, "MultiPoint");
        typeMap.put("MultiPoint", MultiPoint.class);
        typeEncode.put(MultiLineString.class, "MultiLineString");
        typeMap.put("MultiLineString", MultiLineString.class);
        typeEncode.put(MultiPolygon.class, "MultiPolygon");
        typeMap.put("MultiPolygon", MultiPolygon.class);
        typeEncode.put(GeometryCollection.class, "GeometryCollection");
        typeMap.put("GeometryCollection", GeometryCollection.class);
        typeEncode.put(Date.class, "Date");
        typeMap.put("Date", Date.class);
    }
}

