/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.svg;

import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.transform.TransformerException;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.StringBounderUtils;
import net.sourceforge.plantuml.graphic.UnusedSpace;
import net.sourceforge.plantuml.svg.SvgGraphics;
import net.sourceforge.plantuml.ugraphic.AbstractUGraphic;
import net.sourceforge.plantuml.ugraphic.ClipContainer;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UClip;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UText;
import net.sourceforge.plantuml.ugraphic.svg.DriverEllipseSvg;
import net.sourceforge.plantuml.ugraphic.svg.DriverImageSvg;
import net.sourceforge.plantuml.ugraphic.svg.DriverLineSvg;
import net.sourceforge.plantuml.ugraphic.svg.DriverPathSvg;
import net.sourceforge.plantuml.ugraphic.svg.DriverPolygonSvg;
import net.sourceforge.plantuml.ugraphic.svg.DriverRectangleSvg;
import net.sourceforge.plantuml.ugraphic.svg.DriverTextAsPathSvg;
import net.sourceforge.plantuml.ugraphic.svg.DriverTextSvg;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UGraphicSvg
extends AbstractUGraphic<SvgGraphics>
implements ClipContainer {
    static final Graphics2D imDummy = new BufferedImage(10, 10, 1).createGraphics();
    private UClip clip;
    private final StringBounder stringBounder = StringBounderUtils.asStringBounder(imDummy);

    public UGraphicSvg(ColorMapper colorMapper, String string, boolean bl) {
        this(colorMapper, new SvgGraphics(string), bl);
    }

    public UGraphicSvg(ColorMapper colorMapper, boolean bl) {
        this(colorMapper, new SvgGraphics(), bl);
    }

    private UGraphicSvg(ColorMapper colorMapper, SvgGraphics svgGraphics, boolean bl) {
        super(colorMapper, svgGraphics);
        this.registerDriver(URectangle.class, new DriverRectangleSvg(this));
        bl = false;
        if (bl) {
            this.registerDriver(UText.class, new DriverTextAsPathSvg(imDummy.getFontRenderContext(), this));
        } else {
            this.registerDriver(UText.class, new DriverTextSvg(this.getStringBounder(), this));
        }
        this.registerDriver(ULine.class, new DriverLineSvg(this));
        this.registerDriver(UPolygon.class, new DriverPolygonSvg(this));
        this.registerDriver(UEllipse.class, new DriverEllipseSvg());
        this.registerDriver(UImage.class, new DriverImageSvg());
        this.registerDriver(UPath.class, new DriverPathSvg(this));
    }

    public SvgGraphics getSvgGraphics() {
        return (SvgGraphics)this.getGraphicObject();
    }

    @Override
    public StringBounder getStringBounder() {
        return this.stringBounder;
    }

    public void createXml(OutputStream outputStream) throws IOException {
        try {
            ((SvgGraphics)this.getGraphicObject()).createXml(outputStream);
        }
        catch (TransformerException transformerException) {
            throw new IOException(transformerException.toString());
        }
    }

    @Override
    public void setClip(UClip uClip) {
        this.clip = uClip == null ? null : uClip.translate(this.getTranslateX(), this.getTranslateY());
    }

    @Override
    public UClip getClip() {
        return this.clip;
    }

    @Override
    public void centerChar(double d, double d2, char c, UFont uFont) {
        UnusedSpace unusedSpace = UnusedSpace.getUnusedSpace(uFont, c);
        double d3 = d - unusedSpace.getCenterX() - 0.5;
        double d4 = d2 - unusedSpace.getCenterY() - 0.5;
        TextLayout textLayout = new TextLayout("" + c, uFont.getFont(), imDummy.getFontRenderContext());
        ((SvgGraphics)this.getGraphicObject()).setStrokeColor(StringUtils.getAsHtml(this.getColorMapper().getMappedColor(this.getParam().getColor())));
        DriverTextAsPathSvg.drawPathIterator((SvgGraphics)this.getGraphicObject(), d3 + this.getTranslateX(), d4 + this.getTranslateY(), textLayout.getOutline(null).getPathIterator(null));
    }

    @Override
    public void setAntiAliasing(boolean bl) {
    }

    @Override
    public void setUrl(String string, String string2) {
        if (string == null) {
            ((SvgGraphics)this.getGraphicObject()).closeLink();
        } else {
            ((SvgGraphics)this.getGraphicObject()).openLink(string, string2);
        }
    }
}

