/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.g2d;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import net.sourceforge.plantuml.cucadiagram.dot.CucaDiagramFileMaker;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.StringBounderUtils;
import net.sourceforge.plantuml.graphic.UnusedSpace;
import net.sourceforge.plantuml.posimo.DotPath;
import net.sourceforge.plantuml.skin.UDrawable;
import net.sourceforge.plantuml.ugraphic.AbstractUGraphic;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UClip;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UText;
import net.sourceforge.plantuml.ugraphic.g2d.DriverDotPathG2d;
import net.sourceforge.plantuml.ugraphic.g2d.DriverEllipseG2d;
import net.sourceforge.plantuml.ugraphic.g2d.DriverImageG2d;
import net.sourceforge.plantuml.ugraphic.g2d.DriverLineG2d;
import net.sourceforge.plantuml.ugraphic.g2d.DriverPolygonG2d;
import net.sourceforge.plantuml.ugraphic.g2d.DriverRectangleG2d;
import net.sourceforge.plantuml.ugraphic.g2d.DriverTextG2d;
import net.sourceforge.plantuml.ugraphic.svg.UGraphicSvg;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UGraphicG2d
extends AbstractUGraphic<Graphics2D> {
    private final BufferedImage bufferedImage;
    private final double dpiFactor;

    public UGraphicG2d(ColorMapper colorMapper, Graphics2D graphics2D, BufferedImage bufferedImage, double d) {
        super(colorMapper, graphics2D);
        this.dpiFactor = d;
        if (d != 1.0) {
            AffineTransform affineTransform = graphics2D.getTransform();
            affineTransform.concatenate(AffineTransform.getScaleInstance(d, d));
            graphics2D.setTransform(affineTransform);
        }
        this.bufferedImage = bufferedImage;
        this.registerDriver(URectangle.class, new DriverRectangleG2d());
        this.registerDriver(UText.class, new DriverTextG2d());
        this.registerDriver(ULine.class, new DriverLineG2d());
        this.registerDriver(UPolygon.class, new DriverPolygonG2d());
        this.registerDriver(UEllipse.class, new DriverEllipseG2d());
        this.registerDriver(UImage.class, new DriverImageG2d());
        this.registerDriver(DotPath.class, new DriverDotPathG2d());
    }

    @Override
    public StringBounder getStringBounder() {
        return StringBounderUtils.asStringBounder((Graphics2D)this.getGraphicObject());
    }

    public final BufferedImage getBufferedImage() {
        return this.bufferedImage;
    }

    @Override
    public void setClip(UClip uClip) {
        if (uClip == null) {
            ((Graphics2D)this.getGraphicObject()).setClip(null);
        } else {
            Rectangle2D.Double double_ = new Rectangle2D.Double(uClip.getX() + this.getTranslateX(), uClip.getY() + this.getTranslateY(), uClip.getWidth(), uClip.getHeight());
            ((Graphics2D)this.getGraphicObject()).setClip(double_);
        }
    }

    @Override
    public void centerChar(double d, double d2, char c, UFont uFont) {
        UnusedSpace unusedSpace = UnusedSpace.getUnusedSpace(uFont, c);
        ((Graphics2D)this.getGraphicObject()).setColor(this.getColorMapper().getMappedColor(this.getParam().getColor()));
        double d3 = d - unusedSpace.getCenterX();
        double d4 = d2 - unusedSpace.getCenterY() - 0.5;
        ((Graphics2D)this.getGraphicObject()).setFont(uFont.getFont());
        ((Graphics2D)this.getGraphicObject()).drawString("" + c, (float)(d3 + this.getTranslateX()), (float)(d4 + this.getTranslateY()));
    }

    public static String getSvgString(ColorMapper colorMapper, UDrawable uDrawable) throws IOException {
        UGraphicSvg uGraphicSvg = new UGraphicSvg(colorMapper, false);
        uDrawable.drawU(uGraphicSvg);
        return CucaDiagramFileMaker.getSvg(uGraphicSvg);
    }

    protected final double getDpiFactor() {
        return this.dpiFactor;
    }

    @Override
    public void setAntiAliasing(boolean bl) {
        if (bl) {
            ((Graphics2D)this.getGraphicObject()).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            ((Graphics2D)this.getGraphicObject()).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
    }

    @Override
    public void setUrl(String string, String string2) {
    }
}

