/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.eps;

import java.awt.geom.Rectangle2D;
import net.sourceforge.plantuml.eps.EpsGraphics;
import net.sourceforge.plantuml.ugraphic.ClipContainer;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UClip;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UGradient;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UShape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverRectangleEps
implements UDriver<EpsGraphics> {
    private final ClipContainer clipContainer;

    public DriverRectangleEps(ClipContainer clipContainer) {
        this.clipContainer = clipContainer;
    }

    @Override
    public void draw(UShape uShape, double d, double d2, ColorMapper colorMapper, UParam uParam, EpsGraphics epsGraphics) {
        URectangle uRectangle = (URectangle)uShape;
        double d3 = uRectangle.getWidth();
        double d4 = uRectangle.getHeight();
        UClip uClip = this.clipContainer.getClip();
        if (uClip != null) {
            Rectangle2D.Double double_ = uClip.getClippedRectangle(new Rectangle2D.Double(d, d2, d3, d4));
            d = double_.x;
            d2 = double_.y;
            d3 = double_.width;
            d4 = double_.height;
        }
        double d5 = uRectangle.getRx();
        double d6 = uRectangle.getRy();
        UGradient uGradient = uParam.getGradient();
        if (uGradient == null) {
            epsGraphics.setStrokeColor(colorMapper.getMappedColor(uParam.getColor()));
            epsGraphics.setFillColor(colorMapper.getMappedColor(uParam.getBackcolor()));
            epsGraphics.setStrokeWidth("" + uParam.getStroke().getThickness(), uParam.getStroke().getDashVisible(), uParam.getStroke().getDashSpace());
            epsGraphics.epsRectangle(d, d2, d3, d4, d5 / 2.0, d6 / 2.0);
        } else {
            epsGraphics.epsRectangle(d, d2, d3, d4, d5 / 2.0, d6 / 2.0, uGradient, colorMapper);
        }
    }
}

