/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.swing;

import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import net.sourceforge.plantuml.swing.MainWindow;
import net.sourceforge.plantuml.swing.ScrollablePicture;
import net.sourceforge.plantuml.swing.SimpleLine;

class ImageWindow
extends JFrame {
    private SimpleLine simpleLine;
    private final JScrollPane scrollPane;
    private final JButton next = new JButton("Next");
    private final JButton previous = new JButton("Previous");
    private final ListModel listModel;
    private int index;

    public ImageWindow(SimpleLine simpleLine, final MainWindow mainWindow, ListModel listModel, int n) {
        super(simpleLine.toString());
        this.simpleLine = simpleLine;
        this.listModel = listModel;
        this.index = n;
        JPanel jPanel = new JPanel();
        jPanel.add(this.previous);
        jPanel.add(this.next);
        this.next.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImageWindow.this.next();
            }
        });
        this.previous.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImageWindow.this.previous();
            }
        });
        this.scrollPane = new JScrollPane(this.buildScrollablePicture());
        this.getContentPane().add((Component)jPanel, "North");
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.setSize(640, 400);
        this.setVisible(true);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                super.windowClosing(windowEvent);
                mainWindow.closing(ImageWindow.this);
            }
        });
    }

    private void next() {
        ++this.index;
        this.updateSimpleLine();
    }

    private void previous() {
        --this.index;
        this.updateSimpleLine();
    }

    private void updateSimpleLine() {
        if (this.index < 0) {
            this.index = 0;
        }
        if (this.index > this.listModel.getSize() - 1) {
            this.index = this.listModel.getSize() - 1;
        }
        this.simpleLine = (SimpleLine)this.listModel.getElementAt(this.index);
        this.setTitle(this.simpleLine.toString());
        this.refreshImage();
    }

    private ScrollablePicture buildScrollablePicture() {
        File file = this.simpleLine.getGeneratedImage().getPngFile();
        Image image = Toolkit.getDefaultToolkit().createImage(file.getAbsolutePath());
        ImageIcon imageIcon = new ImageIcon(image, this.simpleLine.toString());
        ScrollablePicture scrollablePicture = new ScrollablePicture(imageIcon, 1);
        return scrollablePicture;
    }

    public SimpleLine getSimpleLine() {
        return this.simpleLine;
    }

    public void refreshImage() {
        this.scrollPane.setViewportView(this.buildScrollablePicture());
        this.force();
    }

    private void force() {
        this.repaint();
    }
}

