/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sudoku;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.png.PngIO;
import net.sourceforge.plantuml.sudoku.ISudoku;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.UFont;

public class GraphicsSudoku {
    private final ISudoku sudoku;
    private final UFont numberFont = new UFont("SansSerif", 1, 20);
    private final UFont font = new UFont("SansSerif", 0, 11);
    private final int xOffset = 5;
    private final int yOffset = 5;
    private final int cellWidth = 30;
    private final int cellHeight = 32;
    private final int numberxOffset = 10;
    private final int numberyOffset = 5;
    private final int textTotalHeight = 50;

    public GraphicsSudoku(ISudoku iSudoku) {
        this.sudoku = iSudoku;
    }

    public void writeImage(OutputStream outputStream) throws IOException {
        BufferedImage bufferedImage = this.createImage();
        PngIO.write((RenderedImage)bufferedImage, outputStream, 96);
    }

    private BufferedImage createImage() {
        int n;
        int n2;
        int n3;
        EmptyImageBuilder emptyImageBuilder = new EmptyImageBuilder(283, 351, Color.WHITE);
        BufferedImage bufferedImage = emptyImageBuilder.getBufferedImage();
        Graphics2D graphics2D = emptyImageBuilder.getGraphics2D();
        graphics2D.translate(5, 5);
        for (n3 = 0; n3 < 9; ++n3) {
            for (n2 = 0; n2 < 9; ++n2) {
                n = this.sudoku.getGiven(n3, n2);
                if (n <= 0) continue;
                TextBlock textBlock = TextBlockUtils.create(Arrays.asList("" + n), new FontConfiguration(this.numberFont, HtmlColor.BLACK), HorizontalAlignement.CENTER);
                textBlock.drawTOBEREMOVED(new ColorMapperIdentity(), graphics2D, 10 + n3 * 30, 5 + n2 * 32);
            }
        }
        for (n3 = 0; n3 < 10; ++n3) {
            n2 = n3 % 3 == 0 ? 1 : 0;
            n = n2 != 0 ? 3 : 1;
            graphics2D.fillRect(0, n3 * 32, 273, n);
        }
        for (n3 = 0; n3 < 10; ++n3) {
            n2 = n3 % 3 == 0 ? 1 : 0;
            n = n2 != 0 ? 3 : 1;
            graphics2D.fillRect(n3 * 30, 0, n, 291);
        }
        graphics2D.translate(0, 301);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("http://plantuml.sourceforge.net");
        arrayList.add("Seed " + Long.toString(this.sudoku.getSeed(), 36));
        arrayList.add("Difficulty " + this.sudoku.getRatting());
        TextBlock textBlock = TextBlockUtils.create(arrayList, new FontConfiguration(this.font, HtmlColor.BLACK), HorizontalAlignement.LEFT);
        textBlock.drawTOBEREMOVED(new ColorMapperIdentity(), graphics2D, 0.0, 0.0);
        graphics2D.dispose();
        return bufferedImage;
    }
}

