/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.AbstractComponent;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;

public class ComponentRoseActiveLine
extends AbstractComponent {
    private final HtmlColor foregroundColor;
    private final HtmlColor lifeLineBackground;
    private final boolean closeUp;
    private final boolean closeDown;

    public ComponentRoseActiveLine(HtmlColor htmlColor, HtmlColor htmlColor2, boolean bl, boolean bl2) {
        this.foregroundColor = htmlColor;
        this.lifeLineBackground = htmlColor2;
        this.closeUp = bl;
        this.closeDown = bl2;
    }

    protected void drawInternalU(UGraphic uGraphic, Dimension2D dimension2D) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        int n = (int)(dimension2D.getWidth() - this.getPreferredWidth(stringBounder)) / 2;
        URectangle uRectangle = new URectangle(this.getPreferredWidth(stringBounder), dimension2D.getHeight());
        if (this.closeUp && this.closeDown) {
            uGraphic.getParam().setBackcolor(this.lifeLineBackground);
            uGraphic.getParam().setColor(this.foregroundColor);
            uGraphic.draw(n, 0.0, uRectangle);
            return;
        }
        uGraphic.getParam().setBackcolor(this.lifeLineBackground);
        uGraphic.getParam().setColor(this.lifeLineBackground);
        uGraphic.draw(n, 0.0, uRectangle);
        uGraphic.getParam().setColor(this.foregroundColor);
        ULine uLine = new ULine(0.0, dimension2D.getHeight());
        uGraphic.draw(n, 0.0, uLine);
        uGraphic.draw((double)n + this.getPreferredWidth(stringBounder), 0.0, uLine);
        ULine uLine2 = new ULine(this.getPreferredWidth(stringBounder), 0.0);
        if (this.closeUp) {
            uGraphic.draw(n, 0.0, uLine2);
        }
        if (this.closeDown) {
            uGraphic.draw(n, dimension2D.getHeight(), uLine2);
        }
    }

    public double getPreferredHeight(StringBounder stringBounder) {
        return 0.0;
    }

    public double getPreferredWidth(StringBounder stringBounder) {
        return 10.0;
    }
}

