/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.skin.AbstractComponent;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;

class GrayComponent
extends AbstractComponent {
    private static final UFont NORMAL = new UFont("SansSerif", 0, 7);
    private final ComponentType type;

    public GrayComponent(ComponentType componentType) {
        this.type = componentType;
    }

    protected void drawInternalU(UGraphic uGraphic, Dimension2D dimension2D) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        uGraphic.getParam().setBackcolor(HtmlColor.LIGHT_GRAY);
        uGraphic.getParam().setColor(HtmlColor.BLACK);
        uGraphic.draw(0.0, 0.0, new URectangle(this.getPreferredWidth(stringBounder), this.getPreferredHeight(stringBounder)));
        String string = this.type.name();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < string.length(); i += 9) {
            arrayList.add(string.substring(i, Math.min(i + 9, string.length())));
        }
        TextBlock textBlock = TextBlockUtils.create(arrayList, new FontConfiguration(NORMAL, HtmlColor.BLACK), HorizontalAlignement.LEFT);
        textBlock.drawU(uGraphic, 0.0, 0.0);
    }

    public double getPreferredHeight(StringBounder stringBounder) {
        return 42.0;
    }

    public double getPreferredWidth(StringBounder stringBounder) {
        return 42.0;
    }
}

