/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import java.util.Collection;
import net.sourceforge.plantuml.SkinParamBackcolored;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.InGroupable;
import net.sourceforge.plantuml.sequencediagram.InGroupableList;
import net.sourceforge.plantuml.sequencediagram.LifeEvent;
import net.sourceforge.plantuml.sequencediagram.Message;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.graphic.Arrow;
import net.sourceforge.plantuml.sequencediagram.graphic.ArrowAndNoteBox;
import net.sourceforge.plantuml.sequencediagram.graphic.ArrowAndParticipant;
import net.sourceforge.plantuml.sequencediagram.graphic.ConstraintSet;
import net.sourceforge.plantuml.sequencediagram.graphic.DrawableSet;
import net.sourceforge.plantuml.sequencediagram.graphic.GraphicalElement;
import net.sourceforge.plantuml.sequencediagram.graphic.LivingParticipantBox;
import net.sourceforge.plantuml.sequencediagram.graphic.MessageArrow;
import net.sourceforge.plantuml.sequencediagram.graphic.MessageSelfArrow;
import net.sourceforge.plantuml.sequencediagram.graphic.NoteBox;
import net.sourceforge.plantuml.sequencediagram.graphic.ParticipantBox;
import net.sourceforge.plantuml.sequencediagram.graphic.Step1Abstract;
import net.sourceforge.plantuml.skin.ArrowDirection;
import net.sourceforge.plantuml.skin.ComponentType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Step1Message
extends Step1Abstract {
    private final MessageArrow messageArrow;

    Step1Message(StringBounder stringBounder, Message message, DrawableSet drawableSet, double d) {
        super(stringBounder, message, drawableSet, d);
        double d2 = this.getParticipantBox1().getCenterX(stringBounder);
        double d3 = this.getParticipantBox2().getCenterX(stringBounder);
        this.setType(this.isSelfMessage() ? this.getSelfArrowType(message) : this.getArrowType(message, d2, d3));
        this.messageArrow = this.isSelfMessage() ? null : new MessageArrow(d, drawableSet.getSkin(), drawableSet.getSkin().createComponent(this.getType(), drawableSet.getSkinParam(), this.getLabelOfMessage(message)), this.getLivingParticipantBox1(), this.getLivingParticipantBox2());
        if (message.getNote() != null) {
            SkinParamBackcolored skinParamBackcolored = new SkinParamBackcolored(drawableSet.getSkinParam(), message.getSpecificBackColor());
            this.setNote(drawableSet.getSkin().createComponent(ComponentType.NOTE, drawableSet.getSkinParam(), message.getNote()));
        }
    }

    @Override
    double prepareMessage(ConstraintSet constraintSet, Collection<InGroupableList> collection) {
        Arrow arrow = this.createArrow();
        double d = arrow.getArrowYStartLevel(this.getStringBounder());
        double d2 = arrow.getArrowYEndLevel(this.getStringBounder());
        for (LifeEvent lifeEvent : this.getMessage().getLiveEvents()) {
            this.beforeMessage(lifeEvent, d + 0.0);
        }
        double d3 = this.isSelfMessage() ? arrow.getArrowOnlyWidth(this.getStringBounder()) + this.getLivingParticipantBox1().getLiveThicknessAt(this.getStringBounder(), d).getSegment().getLength() : arrow.getArrowOnlyWidth(this.getStringBounder()) + this.getLivingParticipantBox(NotePosition.LEFT).getLifeLine().getRightShift(d) + this.getLivingParticipantBox(NotePosition.RIGHT).getLifeLine().getLeftShift(d);
        this.incFreeY(arrow.getPreferredHeight(this.getStringBounder()));
        double d4 = 0.0;
        if (this.getMessage().isActivateAndDeactive()) {
            d4 = 30.0;
            this.incFreeY(d4);
        }
        this.getDrawingSet().addEvent(this.getMessage(), arrow);
        if (this.isSelfMessage()) {
            constraintSet.getConstraintAfter(this.getParticipantBox1()).ensureValue(d3);
        } else {
            constraintSet.getConstraint(this.getParticipantBox1(), this.getParticipantBox2()).ensureValue(d3);
        }
        for (LifeEvent object : this.getMessage().getLiveEvents()) {
            this.afterMessage(this.getStringBounder(), object, d2 + d4 - 0.0);
        }
        assert (arrow instanceof InGroupable);
        if (collection != null && arrow instanceof InGroupable) {
            for (InGroupableList inGroupableList : collection) {
                inGroupableList.addInGroupable(arrow);
                inGroupableList.addInGroupable(this.getLivingParticipantBox1());
                if (this.isSelfMessage()) continue;
                inGroupableList.addInGroupable(this.getLivingParticipantBox2());
            }
        }
        return this.getFreeY();
    }

    private boolean isSelfMessage() {
        return this.getParticipantBox1().equals(this.getParticipantBox2());
    }

    private ParticipantBox getParticipantBox1() {
        return this.getLivingParticipantBox1().getParticipantBox();
    }

    private ParticipantBox getParticipantBox2() {
        return this.getLivingParticipantBox2().getParticipantBox();
    }

    private LivingParticipantBox getLivingParticipantBox1() {
        return this.getDrawingSet().getLivingParticipantBox(((Message)this.getMessage()).getParticipant1());
    }

    private LivingParticipantBox getLivingParticipantBox2() {
        return this.getDrawingSet().getLivingParticipantBox(((Message)this.getMessage()).getParticipant2());
    }

    private LivingParticipantBox getLivingParticipantBox(NotePosition notePosition) {
        if (this.isSelfMessage()) {
            throw new IllegalStateException();
        }
        return this.messageArrow.getParticipantAt(this.getStringBounder(), notePosition);
    }

    private Arrow createArrow() {
        if (this.getMessage().isCreate()) {
            return this.createArrowCreate();
        }
        MessageSelfArrow messageSelfArrow = new MessageSelfArrow(this.getFreeY(), this.getDrawingSet().getSkin(), this.getDrawingSet().getSkin().createComponent(this.getType(), this.getDrawingSet().getSkinParam(), this.getLabelOfMessage(this.getMessage())), this.getLivingParticipantBox1());
        if (this.getMessage().getNote() != null && this.isSelfMessage()) {
            NoteBox noteBox = this.createNoteBox(this.getStringBounder(), messageSelfArrow, this.getNote(), this.getMessage().getNotePosition(), this.getMessage().getUrlNote());
            return new ArrowAndNoteBox(this.getStringBounder(), messageSelfArrow, noteBox);
        }
        if (this.getMessage().getNote() != null) {
            NoteBox noteBox = this.createNoteBox(this.getStringBounder(), this.messageArrow, this.getNote(), this.getMessage().getNotePosition(), this.getMessage().getUrlNote());
            return new ArrowAndNoteBox(this.getStringBounder(), this.messageArrow, noteBox);
        }
        if (this.isSelfMessage()) {
            return messageSelfArrow;
        }
        return this.messageArrow;
    }

    private Arrow createArrowCreate() {
        Arrow arrow = new ArrowAndParticipant(this.getStringBounder(), this.messageArrow, this.getParticipantBox2());
        if (this.getMessage().getNote() != null) {
            NoteBox noteBox = this.createNoteBox(this.getStringBounder(), arrow, this.getNote(), this.getMessage().getNotePosition(), this.getMessage().getUrlNote());
            if (this.getMessage().getNotePosition() == NotePosition.RIGHT) {
                noteBox.pushToRight(this.getParticipantBox2().getPreferredWidth(this.getStringBounder()) / 2.0);
            }
            arrow = new ArrowAndNoteBox(this.getStringBounder(), arrow, noteBox);
        }
        this.getLivingParticipantBox2().create(this.getFreeY() + ((GraphicalElement)arrow).getPreferredHeight(this.getStringBounder()) / 2.0);
        return arrow;
    }

    private ComponentType getSelfArrowType(Message message) {
        ComponentType componentType;
        ComponentType componentType2 = componentType = message.getArrowConfiguration().isDotted() ? ComponentType.getArrow(ArrowDirection.SELF).withDotted() : ComponentType.getArrow(ArrowDirection.SELF);
        if (message.getArrowConfiguration().isDotted()) {
            componentType = componentType.withDotted();
        }
        if (message.getArrowConfiguration().isASync()) {
            componentType = componentType.withAsync();
        }
        componentType = componentType.withPart(message.getArrowConfiguration().getPart());
        return componentType;
    }

    private ComponentType getArrowType(Message message, double d, double d2) {
        ComponentType componentType = null;
        componentType = d2 > d ? ComponentType.getArrow(ArrowDirection.LEFT_TO_RIGHT_NORMAL) : ComponentType.getArrow(ArrowDirection.RIGHT_TO_LEFT_REVERSE);
        if (message.getArrowConfiguration().isDotted()) {
            componentType = componentType.withDotted();
        }
        if (message.getArrowConfiguration().isASync()) {
            componentType = componentType.withAsync();
        }
        componentType = componentType.withPart(message.getArrowConfiguration().getPart());
        return componentType;
    }
}

