/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.AbstractMessage;
import net.sourceforge.plantuml.sequencediagram.InGroupableList;
import net.sourceforge.plantuml.sequencediagram.LifeEvent;
import net.sourceforge.plantuml.sequencediagram.LifeEventType;
import net.sourceforge.plantuml.sequencediagram.MessageNumber;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.graphic.Arrow;
import net.sourceforge.plantuml.sequencediagram.graphic.ConstraintSet;
import net.sourceforge.plantuml.sequencediagram.graphic.DrawableSet;
import net.sourceforge.plantuml.sequencediagram.graphic.LifeDestroy;
import net.sourceforge.plantuml.sequencediagram.graphic.LifeLine;
import net.sourceforge.plantuml.sequencediagram.graphic.LifeSegmentVariation;
import net.sourceforge.plantuml.sequencediagram.graphic.LivingParticipantBox;
import net.sourceforge.plantuml.sequencediagram.graphic.MessageSelfArrow;
import net.sourceforge.plantuml.sequencediagram.graphic.NoteBox;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Step1Abstract {
    private final StringBounder stringBounder;
    private final DrawableSet drawingSet;
    private final AbstractMessage message;
    private double freeY;
    private ComponentType type;
    private Component note;

    Step1Abstract(StringBounder stringBounder, AbstractMessage abstractMessage, DrawableSet drawableSet, double d) {
        this.stringBounder = stringBounder;
        this.message = abstractMessage;
        this.freeY = d;
        this.drawingSet = drawableSet;
    }

    abstract double prepareMessage(ConstraintSet var1, Collection<InGroupableList> var2);

    protected final List<? extends CharSequence> getLabelOfMessage(AbstractMessage abstractMessage) {
        if (abstractMessage.getMessageNumber() == null) {
            return abstractMessage.getLabel();
        }
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>();
        arrayList.add(new MessageNumber(abstractMessage.getMessageNumber()));
        arrayList.addAll(abstractMessage.getLabel());
        return arrayList;
    }

    protected final void beforeMessage(LifeEvent lifeEvent, double d) {
        Participant participant = lifeEvent.getParticipant();
        LifeLine lifeLine = this.drawingSet.getLivingParticipantBox(participant).getLifeLine();
        if (lifeEvent.getType() != LifeEventType.ACTIVATE) {
            return;
        }
        assert (lifeEvent.getType() == LifeEventType.ACTIVATE);
        int n = 0;
        if (this.message.isCreate()) {
            n += 10;
        }
        lifeLine.addSegmentVariation(LifeSegmentVariation.LARGER, d + (double)n, lifeEvent.getSpecificBackColor());
    }

    protected final void afterMessage(StringBounder stringBounder, LifeEvent lifeEvent, double d) {
        Participant participant = lifeEvent.getParticipant();
        LifeLine lifeLine = this.drawingSet.getLivingParticipantBox(participant).getLifeLine();
        if (lifeEvent.getType() == LifeEventType.ACTIVATE || lifeEvent.getType() == LifeEventType.CREATE) {
            return;
        }
        if (lifeEvent.getType() == LifeEventType.DESTROY) {
            Component component = this.drawingSet.getSkin().createComponent(ComponentType.DESTROY, this.drawingSet.getSkinParam(), null);
            double d2 = component.getPreferredHeight(stringBounder) / 2.0;
            LifeDestroy lifeDestroy = new LifeDestroy(d - d2, this.drawingSet.getLivingParticipantBox(participant).getParticipantBox(), component);
            this.drawingSet.addEvent(lifeEvent, lifeDestroy);
        } else if (lifeEvent.getType() != LifeEventType.DEACTIVATE) {
            throw new IllegalStateException();
        }
        lifeLine.addSegmentVariation(LifeSegmentVariation.SMALLER, d, lifeEvent.getSpecificBackColor());
    }

    protected final ComponentType getType() {
        return this.type;
    }

    protected final void setType(ComponentType componentType) {
        this.type = componentType;
    }

    protected final Component getNote() {
        return this.note;
    }

    protected final void setNote(Component component) {
        this.note = component;
    }

    protected final StringBounder getStringBounder() {
        return this.stringBounder;
    }

    protected final AbstractMessage getMessage() {
        return this.message;
    }

    protected final DrawableSet getDrawingSet() {
        return this.drawingSet;
    }

    protected final double getFreeY() {
        return this.freeY;
    }

    protected final void incFreeY(double d) {
        this.freeY += d;
    }

    protected final NoteBox createNoteBox(StringBounder stringBounder, Arrow arrow, Component component, NotePosition notePosition, Url url) {
        LivingParticipantBox livingParticipantBox = arrow.getParticipantAt(stringBounder, notePosition);
        NoteBox noteBox = new NoteBox(arrow.getStartingY(), component, livingParticipantBox, null, notePosition, url);
        if (arrow instanceof MessageSelfArrow && notePosition == NotePosition.RIGHT) {
            noteBox.pushToRight(arrow.getPreferredWidth(stringBounder));
        }
        return noteBox;
    }
}

