/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.InGroupable;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.graphic.GraphicalElement;
import net.sourceforge.plantuml.sequencediagram.graphic.LivingParticipantBox;
import net.sourceforge.plantuml.sequencediagram.graphic.SegmentColored;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.ugraphic.UGraphic;

class NoteBox
extends GraphicalElement
implements InGroupable {
    private final NotePosition position;
    private final Url url;
    private final LivingParticipantBox p1;
    private final LivingParticipantBox p2;
    private final Component comp;
    private double delta = 0.0;

    public NoteBox(double d, Component component, LivingParticipantBox livingParticipantBox, LivingParticipantBox livingParticipantBox2, NotePosition notePosition, Url url) {
        super(d);
        if (livingParticipantBox == null) {
            throw new IllegalArgumentException();
        }
        if (livingParticipantBox2 != null ^ notePosition == NotePosition.OVER_SEVERAL) {
            throw new IllegalArgumentException();
        }
        this.p1 = livingParticipantBox;
        this.p2 = livingParticipantBox2;
        this.position = notePosition;
        this.url = url;
        this.comp = component;
    }

    public final double getPreferredWidth(StringBounder stringBounder) {
        return this.comp.getPreferredWidth(stringBounder);
    }

    public final double getPreferredHeight(StringBounder stringBounder) {
        return this.comp.getPreferredHeight(stringBounder);
    }

    protected void drawInternalU(UGraphic uGraphic, double d, Context2D context2D) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        double d2 = this.getStartingX(stringBounder);
        uGraphic.translate(d2, this.getStartingY());
        Dimension2DDouble dimension2DDouble = new Dimension2DDouble(this.comp.getPreferredWidth(stringBounder), this.comp.getPreferredHeight(stringBounder));
        if (this.url != null) {
            uGraphic.setUrl(this.url.getUrl(), this.url.getTooltip());
        }
        this.comp.drawU(uGraphic, dimension2DDouble, context2D);
        if (this.url != null) {
            uGraphic.setUrl(null, null);
        }
    }

    public double getStartingX(StringBounder stringBounder) {
        int n;
        SegmentColored segmentColored = this.getSegment(stringBounder);
        if (this.position == NotePosition.LEFT) {
            n = (int)(segmentColored.getSegment().getPos1() - this.getPreferredWidth(stringBounder));
        } else if (this.position == NotePosition.RIGHT) {
            n = (int)segmentColored.getSegment().getPos2();
        } else if (this.position == NotePosition.OVER) {
            n = (int)(this.p1.getParticipantBox().getCenterX(stringBounder) - this.getPreferredWidth(stringBounder) / 2.0);
        } else if (this.position == NotePosition.OVER_SEVERAL) {
            double d = (this.p1.getParticipantBox().getCenterX(stringBounder) + this.p2.getParticipantBox().getCenterX(stringBounder)) / 2.0;
            n = (int)(d - this.getPreferredWidth(stringBounder) / 2.0);
        } else {
            throw new IllegalStateException();
        }
        return (double)n + this.delta;
    }

    private SegmentColored getSegment(StringBounder stringBounder) {
        SegmentColored segmentColored = this.p1.getLiveThicknessAt(stringBounder, this.getStartingY());
        SegmentColored segmentColored2 = this.p1.getLiveThicknessAt(stringBounder, this.getStartingY() + this.comp.getPreferredHeight(stringBounder));
        return segmentColored.merge(segmentColored2);
    }

    public void pushToRight(double d) {
        this.delta += d;
    }

    public double getMaxX(StringBounder stringBounder) {
        return this.getStartingX(stringBounder) + this.getPreferredWidth(stringBounder);
    }

    public double getMinX(StringBounder stringBounder) {
        return this.getStartingX(stringBounder);
    }

    public String toString(StringBounder stringBounder) {
        return this.toString();
    }

    public final Url getUrl() {
        return this.url;
    }
}

