/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.SpecificBackcolorable;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.sequencediagram.ParticipantType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Participant
implements SpecificBackcolorable {
    private final String code;
    private final List<CharSequence> display;
    private final ParticipantType type;
    private int initialLife = 0;
    private Stereotype stereotype;
    private HtmlColor liveBackcolor;
    private HtmlColor specificBackcolor;
    private Url url;

    public Participant(ParticipantType participantType, String string, List<String> list) {
        if (participantType == null) {
            throw new IllegalArgumentException();
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (list == null || list.size() == 0) {
            throw new IllegalArgumentException();
        }
        this.code = string;
        this.type = participantType;
        this.display = new ArrayList<String>(list);
    }

    public String getCode() {
        return this.code;
    }

    public String toString() {
        return this.getCode();
    }

    public List<CharSequence> getDisplay() {
        return Collections.unmodifiableList(this.display);
    }

    public ParticipantType getType() {
        return this.type;
    }

    public final void setStereotype(Stereotype stereotype) {
        if (this.type == ParticipantType.ACTOR) {
            return;
        }
        if (this.stereotype != null) {
            throw new IllegalStateException();
        }
        if (stereotype == null) {
            throw new IllegalArgumentException();
        }
        this.stereotype = stereotype;
        this.display.add(0, stereotype);
    }

    public final int getInitialLife() {
        return this.initialLife;
    }

    public final void incInitialLife(HtmlColor htmlColor) {
        ++this.initialLife;
        this.liveBackcolor = htmlColor;
    }

    public HtmlColor getLiveSpecificBackColor() {
        return this.liveBackcolor;
    }

    @Override
    public HtmlColor getSpecificBackColor() {
        return this.specificBackcolor;
    }

    @Override
    public void setSpecificBackcolor(HtmlColor htmlColor) {
        this.specificBackcolor = htmlColor;
    }

    public final Url getUrl() {
        return this.url;
    }

    public final void setUrl(Url url) {
        this.url = url;
    }
}

