/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.project.Duration;
import net.sourceforge.plantuml.project.Instant;
import net.sourceforge.plantuml.project.InstantArithmetic;
import net.sourceforge.plantuml.project.Item;
import net.sourceforge.plantuml.project.ItemCaract;
import net.sourceforge.plantuml.project.Load;
import net.sourceforge.plantuml.project.Numeric;
import net.sourceforge.plantuml.project.NumericNumber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IncompleteItem
implements Item {
    private Map<ItemCaract, Numeric> data = new EnumMap<ItemCaract, Numeric>(ItemCaract.class);
    private final InstantArithmetic math;
    private final Item parent;
    private final String code;

    public IncompleteItem(String string, Item item, InstantArithmetic instantArithmetic) {
        this.math = instantArithmetic;
        this.code = string;
        this.parent = item;
    }

    public void setData(ItemCaract itemCaract, Numeric numeric) {
        if (itemCaract.getNumericType() != numeric.getNumericType()) {
            throw new IllegalArgumentException();
        }
        if (this.data.containsKey((Object)itemCaract.getNumericType())) {
            throw new IllegalStateException();
        }
        this.data.put(itemCaract, numeric);
        boolean bl = false;
        do {
            bl = false;
            bl = this.eventuallyUseBeginComplete() || bl;
            bl = this.eventuallyUseBeginDuration() || bl;
            bl = this.eventuallyUseCompleteDuration() || bl;
            bl = this.eventuallyUseDurationWork() || bl;
            bl = this.eventuallyUseDurationLoad() || bl;
        } while (bl = this.eventuallyUseLoadWork() || bl);
    }

    private boolean eventuallyUseDurationWork() {
        if (this.data.containsKey((Object)ItemCaract.DURATION) && this.data.containsKey((Object)ItemCaract.WORK) && !this.data.containsKey((Object)ItemCaract.LOAD)) {
            Duration duration = (Duration)this.data.get((Object)ItemCaract.DURATION);
            NumericNumber numericNumber = (NumericNumber)this.data.get((Object)ItemCaract.WORK);
            this.data.put(ItemCaract.LOAD, new Load(duration.getMinutes() * (long)numericNumber.getIntValue()));
            return true;
        }
        return false;
    }

    private boolean eventuallyUseLoadWork() {
        if (this.data.containsKey((Object)ItemCaract.LOAD) && this.data.containsKey((Object)ItemCaract.WORK) && !this.data.containsKey((Object)ItemCaract.DURATION)) {
            Load load = (Load)this.data.get((Object)ItemCaract.LOAD);
            NumericNumber numericNumber = (NumericNumber)this.data.get((Object)ItemCaract.WORK);
            this.data.put(ItemCaract.DURATION, new Duration(load.getMinuteMen() / (long)numericNumber.getIntValue()));
            return true;
        }
        return false;
    }

    private boolean eventuallyUseDurationLoad() {
        if (this.data.containsKey((Object)ItemCaract.DURATION) && this.data.containsKey((Object)ItemCaract.LOAD) && !this.data.containsKey((Object)ItemCaract.WORK)) {
            Duration duration = (Duration)this.data.get((Object)ItemCaract.DURATION);
            Load load = (Load)this.data.get((Object)ItemCaract.LOAD);
            this.data.put(ItemCaract.WORK, new NumericNumber((int)(load.getMinuteMen() / duration.getMinutes())));
            return true;
        }
        return false;
    }

    private boolean eventuallyUseBeginDuration() {
        if (this.data.containsKey((Object)ItemCaract.BEGIN) && this.data.containsKey((Object)ItemCaract.DURATION) && !this.data.containsKey((Object)ItemCaract.COMPLETED)) {
            Instant instant = (Instant)this.data.get((Object)ItemCaract.BEGIN);
            Duration duration = (Duration)this.data.get((Object)ItemCaract.DURATION);
            this.data.put(ItemCaract.COMPLETED, this.math.add(instant, duration));
            return true;
        }
        return false;
    }

    private boolean eventuallyUseCompleteDuration() {
        if (this.data.containsKey((Object)ItemCaract.COMPLETED) && this.data.containsKey((Object)ItemCaract.DURATION) && !this.data.containsKey((Object)ItemCaract.BEGIN)) {
            Instant instant = (Instant)this.data.get((Object)ItemCaract.COMPLETED);
            Duration duration = (Duration)this.data.get((Object)ItemCaract.DURATION);
            this.data.put(ItemCaract.BEGIN, this.math.sub(instant, duration));
            return true;
        }
        return false;
    }

    private boolean eventuallyUseBeginComplete() {
        if (this.data.containsKey((Object)ItemCaract.BEGIN) && this.data.containsKey((Object)ItemCaract.COMPLETED) && !this.data.containsKey((Object)ItemCaract.DURATION)) {
            Instant instant = (Instant)this.data.get((Object)ItemCaract.BEGIN);
            Instant instant2 = (Instant)this.data.get((Object)ItemCaract.COMPLETED);
            if (instant2.compareTo(instant) <= 0) {
                throw new IllegalArgumentException();
            }
            this.data.put(ItemCaract.DURATION, this.math.diff(instant, instant2));
            return true;
        }
        return false;
    }

    @Override
    public boolean isValid() {
        return this.data.size() == EnumSet.allOf(ItemCaract.class).size();
    }

    @Override
    public Instant getBegin() {
        return (Instant)this.data.get((Object)ItemCaract.BEGIN);
    }

    @Override
    public Instant getCompleted() {
        return (Instant)this.data.get((Object)ItemCaract.COMPLETED);
    }

    @Override
    public Duration getDuration() {
        return (Duration)this.data.get((Object)ItemCaract.DURATION);
    }

    @Override
    public Load getLoad() {
        return (Load)this.data.get((Object)ItemCaract.LOAD);
    }

    @Override
    public NumericNumber getWork() {
        return (NumericNumber)this.data.get((Object)ItemCaract.WORK);
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public Item getParent() {
        return this.parent;
    }

    @Override
    public List<Item> getChildren() {
        return null;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    public String toString() {
        return this.code + " " + this.data.toString();
    }
}

