/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.posimo;

import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.dot.PlayField;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.posimo.Frame;
import net.sourceforge.plantuml.posimo.IEntityImageBlock;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGraphicUtils;
import net.sourceforge.plantuml.ugraphic.URectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityImageBlock
implements IEntityImageBlock {
    private final IEntity entity;
    private final ISkinParam param;
    private final Rose rose;
    private final TextBlock name;
    private final Collection<Link> links;
    private PlayField playField;
    private Frame frame;
    private Dimension2D dimension;

    public EntityImageBlock(IEntity iEntity, Rose rose, ISkinParam iSkinParam, Collection<Link> collection, FontParam fontParam) {
        this.entity = iEntity;
        this.param = iSkinParam;
        this.rose = rose;
        this.links = collection;
        this.name = StringUtils.isNotEmpty(iEntity.getDisplay()) ? TextBlockUtils.create(StringUtils.getWithNewlines(iEntity.getDisplay()), new FontConfiguration(iSkinParam.getFont(fontParam, null), HtmlColor.BLACK), HorizontalAlignement.CENTER) : null;
    }

    @Override
    public Dimension2D getDimension(StringBounder stringBounder) {
        if (this.dimension == null) {
            Dimension2D dimension2D;
            double d;
            this.dimension = this.getDimensionSlow(stringBounder);
            if (this.name != null && (d = (dimension2D = this.name.calculateDimension(stringBounder)).getWidth()) > this.dimension.getWidth()) {
                this.dimension = new Dimension2DDouble(d, this.dimension.getHeight());
            }
        }
        return this.dimension;
    }

    private Dimension2D getDimensionSlow(StringBounder stringBounder) {
        Dimension2D dimension2D;
        this.initPlayField(stringBounder);
        if (this.playField == null) {
            dimension2D = this.name.calculateDimension(stringBounder);
        } else {
            try {
                dimension2D = this.playField.solve();
                double d = this.frame.getPreferredHeight(stringBounder);
                dimension2D = Dimension2DDouble.delta(dimension2D, 0.0, d);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new RuntimeException();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                throw new RuntimeException();
            }
        }
        return dimension2D;
    }

    private void initPlayField(StringBounder stringBounder) {
        if (this.playField != null || this.entity.getParent() == null || this.entity.getType() != EntityType.GROUP) {
            return;
        }
        this.playField = new PlayField(this.param);
        ArrayList<IEntity> arrayList = new ArrayList<IEntity>();
        for (IEntity iEntity : this.entity.getParent().entities().values()) {
            arrayList.add(iEntity);
        }
        this.playField.initInternal(arrayList, this.links, stringBounder);
        this.frame = new Frame(StringUtils.getWithNewlines(this.entity.getDisplay()), this.param);
    }

    @Override
    public void drawU(UGraphic uGraphic, double d, double d2, double d3, double d4) {
        Dimension2D dimension2D = this.getDimension(uGraphic.getStringBounder());
        double d5 = dimension2D.getWidth() + 2.0 * d3;
        double d6 = dimension2D.getHeight() + 2.0 * d4;
        URectangle uRectangle = new URectangle(d5, d6);
        if (this.entity.getType() != EntityType.GROUP) {
            uGraphic.getParam().setBackcolor(this.rose.getHtmlColor(this.param, ColorParam.classBackground));
            uGraphic.getParam().setColor(this.rose.getHtmlColor(this.param, ColorParam.classBorder));
            uGraphic.draw(d - d3, d2 - d4, uRectangle);
            this.name.drawU(uGraphic, d + 0.0, d2 + 0.0);
        } else {
            Frame frame = new Frame(StringUtils.getWithNewlines(this.entity.getDisplay()), this.param);
            uGraphic.getParam().setBackcolor(this.rose.getHtmlColor(this.param, ColorParam.background));
            uGraphic.getParam().setColor(null);
            uGraphic.draw(d - d3, d2 - d3, uRectangle);
            double d7 = uGraphic.getTranslateX();
            double d8 = uGraphic.getTranslateY();
            uGraphic.translate(d - d3, d2 - d4);
            frame.drawU(uGraphic, new Dimension2DDouble(d5, d6), null);
            uGraphic.setTranslate(d7, d8);
            this.playField.drawInternal(UGraphicUtils.translate(uGraphic, d + 0.0, d2 + 0.0 + frame.getPreferredHeight(uGraphic.getStringBounder())));
        }
    }
}

