/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.oregon;

import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.oregon.Keyboard;
import net.sourceforge.plantuml.oregon.NoInputException;
import net.sourceforge.plantuml.oregon.OregonBasicGame;
import net.sourceforge.plantuml.oregon.Screen;
import net.sourceforge.plantuml.ugraphic.UFont;

public class PSystemOregon
extends AbstractPSystem {
    private Screen screen;

    public PSystemOregon(Keyboard keyboard) {
        OregonBasicGame oregonBasicGame = new OregonBasicGame();
        try {
            oregonBasicGame.run(keyboard);
            this.screen = oregonBasicGame.getScreen();
        }
        catch (NoInputException noInputException) {
            this.screen = oregonBasicGame.getScreen();
        }
    }

    public void exportDiagram(OutputStream outputStream, StringBuilder stringBuilder, int n, FileFormatOption fileFormatOption) throws IOException {
        this.getGraphicStrings().writeImage(outputStream, fileFormatOption);
    }

    private GraphicStrings getGraphicStrings() throws IOException {
        UFont uFont = new UFont("Monospaced", 0, 14);
        return new GraphicStrings(this.screen.getLines(), uFont, HtmlColor.GREEN, HtmlColor.BLACK, true);
    }

    public String getDescription() {
        return "(The Oregon Trail)";
    }
}

