/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.util.List;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.CircledCharacter;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockSimple;
import net.sourceforge.plantuml.graphic.TextBlockSpotted;
import net.sourceforge.plantuml.graphic.TextBlockWithNumber;
import net.sourceforge.plantuml.sequencediagram.MessageNumber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextBlockUtils {
    public static TextBlock create(List<? extends CharSequence> list, FontConfiguration fontConfiguration, HorizontalAlignement horizontalAlignement) {
        if (list.size() > 0 && list.get(0) instanceof Stereotype) {
            return TextBlockUtils.createStereotype(list, fontConfiguration, horizontalAlignement);
        }
        if (list.size() > 0 && list.get(0) instanceof MessageNumber) {
            return TextBlockUtils.createMessageNumber(list, fontConfiguration, horizontalAlignement);
        }
        return new TextBlockSimple(list, fontConfiguration, horizontalAlignement);
    }

    private static TextBlock createMessageNumber(List<? extends CharSequence> list, FontConfiguration fontConfiguration, HorizontalAlignement horizontalAlignement) {
        MessageNumber messageNumber = (MessageNumber)list.get(0);
        return new TextBlockWithNumber(messageNumber.getNumber(), list.subList(1, list.size()), fontConfiguration, horizontalAlignement);
    }

    private static TextBlock createStereotype(List<? extends CharSequence> list, FontConfiguration fontConfiguration, HorizontalAlignement horizontalAlignement) {
        Stereotype stereotype = (Stereotype)list.get(0);
        if (stereotype.isSpotted()) {
            CircledCharacter circledCharacter = new CircledCharacter(stereotype.getCharacter(), stereotype.getRadius(), stereotype.getCircledFont(), stereotype.getHtmlColor(), null, fontConfiguration.getColor());
            if (stereotype.getLabel() == null) {
                return new TextBlockSpotted(circledCharacter, list.subList(1, list.size()), fontConfiguration, horizontalAlignement);
            }
            return new TextBlockSpotted(circledCharacter, list, fontConfiguration, horizontalAlignement);
        }
        return new TextBlockSimple(list, fontConfiguration, horizontalAlignement);
    }
}

