/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph;

import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.skin.VisibilityModifier;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.PlacementStrategyVisibility;
import net.sourceforge.plantuml.ugraphic.PlacementStrategyY1Y2Left;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodsOrFieldsArea2 {
    private final UFont font;
    private final List<Member> members = new ArrayList<Member>();
    private final ISkinParam skinParam;
    private final HtmlColor color;
    private final Rose rose = new Rose();

    public MethodsOrFieldsArea2(List<Member> list, FontParam fontParam, ISkinParam iSkinParam) {
        this.members.addAll(list);
        this.skinParam = iSkinParam;
        this.font = iSkinParam.getFont(fontParam, null);
        this.color = this.rose.getFontColor(iSkinParam, FontParam.CLASS_ATTRIBUTE);
    }

    private boolean hasSmallIcon() {
        for (Member member : this.members) {
            if (member.getVisibilityModifier() == null) continue;
            return true;
        }
        return false;
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        double d = 0.0;
        double d2 = 0.0;
        for (Member member : this.members) {
            String string = member.getDisplayWithoutVisibilityChar();
            TextBlock textBlock = this.createTextBlock(string);
            Dimension2D dimension2D = textBlock.calculateDimension(stringBounder);
            d2 += dimension2D.getHeight();
            d = Math.max(dimension2D.getWidth(), d);
        }
        if (this.hasSmallIcon()) {
            d += (double)this.skinParam.getCircledCharacterRadius();
        }
        return new Dimension2DDouble(d, d2);
    }

    private TextBlock createTextBlock(String string) {
        return TextBlockUtils.create(Arrays.asList(string), new FontConfiguration(this.font, this.color), HorizontalAlignement.LEFT);
    }

    public void drawTOBEREMOVED(Graphics2D graphics2D, double d, double d2) {
        throw new UnsupportedOperationException();
    }

    public void draw(UGraphic uGraphic, double d, double d2) {
        UGroup uGroup;
        Dimension2D dimension2D = this.calculateDimension(uGraphic.getStringBounder());
        if (this.hasSmallIcon()) {
            uGroup = new UGroup(new PlacementStrategyVisibility(uGraphic.getStringBounder(), this.skinParam.getCircledCharacterRadius()));
            for (Member member : this.members) {
                String string = member.getDisplayWithoutVisibilityChar();
                TextBlock textBlock = this.createTextBlock(string);
                VisibilityModifier visibilityModifier = member.getVisibilityModifier();
                uGroup.add(this.getUBlock(visibilityModifier));
                uGroup.add(textBlock);
            }
        } else {
            uGroup = new UGroup(new PlacementStrategyY1Y2Left(uGraphic.getStringBounder()));
            for (Member member : this.members) {
                String string = member.getDisplayWithoutVisibilityChar();
                TextBlock textBlock = this.createTextBlock(string);
                uGroup.add(textBlock);
            }
        }
        uGroup.drawU(uGraphic, d, d2, dimension2D.getWidth(), dimension2D.getHeight());
    }

    private TextBlock getUBlock(VisibilityModifier visibilityModifier) {
        if (visibilityModifier == null) {
            return new TextBlock(){

                public void drawU(UGraphic uGraphic, double d, double d2) {
                }

                public void drawTOBEREMOVED(ColorMapper colorMapper, Graphics2D graphics2D, double d, double d2) {
                    throw new UnsupportedOperationException();
                }

                public Dimension2D calculateDimension(StringBounder stringBounder) {
                    return new Dimension2DDouble(1.0, 1.0);
                }
            };
        }
        HtmlColor htmlColor = visibilityModifier.getBackground() == null ? null : this.rose.getHtmlColor(this.skinParam, visibilityModifier.getBackground());
        HtmlColor htmlColor2 = this.rose.getHtmlColor(this.skinParam, visibilityModifier.getForeground());
        TextBlock textBlock = visibilityModifier.getUBlock(this.skinParam.getCircledCharacterRadius(), htmlColor2, htmlColor);
        return textBlock;
    }
}

