/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.cucadiagram.Entity;
import net.sourceforge.plantuml.geom.InflationTransform;
import net.sourceforge.plantuml.geom.Point2DInt;
import net.sourceforge.plantuml.geom.Pointable;
import net.sourceforge.plantuml.geom.XMoveable;
import net.sourceforge.plantuml.geom.kinetic.Frame;
import net.sourceforge.plantuml.graph.ALink;
import net.sourceforge.plantuml.graph.ANode;
import net.sourceforge.plantuml.graph.AbstractEntityImage;
import net.sourceforge.plantuml.graph.Board;
import net.sourceforge.plantuml.graph.EntityImageFactory;
import net.sourceforge.plantuml.graph2.CubicCurveFactory;
import net.sourceforge.plantuml.graph2.MyCurve;
import net.sourceforge.plantuml.graph2.RectanglesCollection;
import net.sourceforge.plantuml.graphic.StringBounderUtils;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Graph4 {
    private static final Graphics2D dummyGraphics2D;
    private final int spaceWidth = 40;
    private final int spaceHeight = 40;
    private final double margin = 30.0;
    private final Board board;
    private final Map<ANode, ANodePoint> nodePoints = new LinkedHashMap<ANode, ANodePoint>();
    private final Map<ANodePoint, Frame> frames = new LinkedHashMap<ANodePoint, Frame>();
    private int maxRow;
    private int maxCol;
    private int addedWidth = 0;
    private int addedHeight = 0;
    private final List<MyCurve> alreadyCurve = new ArrayList<MyCurve>();

    public Graph4(Board board) {
        Object object;
        Point2DInt point2DInt;
        board.normalize();
        this.board = board;
        for (ANode iterator : board.getNodes()) {
            this.maxRow = Math.max(this.maxRow, iterator.getRow());
            this.maxCol = Math.max(this.maxCol, board.getCol(iterator));
        }
        for (ANode aNode : board.getNodes()) {
            this.nodePoints.put(aNode, new ANodePoint(aNode));
        }
        InflationTransform inflationTransform = new InflationTransform();
        for (ANodePoint aNodePoint : this.nodePoints.values()) {
            point2DInt = aNodePoint.getPosition();
            object = this.getImage(aNodePoint.getNode());
            int n = (int)((AbstractEntityImage)object).getDimension(StringBounderUtils.asStringBounder(dummyGraphics2D)).getWidth();
            int n2 = (int)((AbstractEntityImage)object).getDimension(StringBounderUtils.asStringBounder(dummyGraphics2D)).getHeight();
            if (n % 2 == 1) {
                ++n;
            }
            if (n2 % 2 == 1) {
                ++n2;
            }
            inflationTransform.addInflationX(point2DInt.getXint(), n);
            this.addedWidth += n;
            inflationTransform.addInflationY(point2DInt.getYint(), n2);
            this.addedHeight += n2;
        }
        for (ANodePoint aNodePoint : this.nodePoints.values()) {
            point2DInt = aNodePoint.getPosition();
            object = inflationTransform.inflatePoint2DInt(point2DInt);
            aNodePoint.moveX(((Point2DInt)object).getXint() - point2DInt.getXint());
            aNodePoint.moveY(((Point2DInt)object).getYint() - point2DInt.getYint());
        }
        for (ANodePoint aNodePoint : this.nodePoints.values()) {
            double d = aNodePoint.getPosition().getX();
            double d2 = aNodePoint.getPosition().getY();
            Dimension2D dimension2D = this.getImage(aNodePoint.getNode()).getDimension(StringBounderUtils.asStringBounder(dummyGraphics2D));
            int n = (int)dimension2D.getWidth();
            int n3 = (int)dimension2D.getHeight();
            Frame frame = new Frame(d - (double)(n / 2), d2 - (double)(n3 / 2), n, n3);
            this.frames.put(aNodePoint, frame);
        }
    }

    public Dimension2D getDimension() {
        double d = 40 * this.maxCol;
        int n = 40 * this.maxRow;
        return new Dimension2DDouble(d + 60.0 + (double)this.addedWidth, (double)n + 60.0 + (double)this.addedHeight);
    }

    public void draw(Graphics2D graphics2D) {
        Object object;
        Object object2;
        graphics2D.translate(30.0, 30.0);
        graphics2D.setColor(Color.BLUE);
        long l = System.currentTimeMillis();
        this.alreadyCurve.clear();
        for (ALink aLink : this.getSortedLinks()) {
            ANodePoint aNodePoint = this.nodePoints.get(aLink.getNode1());
            ANodePoint aNodePoint2 = this.nodePoints.get(aLink.getNode2());
            object2 = this.getForbidden(aLink);
            if (((RectanglesCollection)object2).size() != this.nodePoints.size() - 2) {
                throw new IllegalStateException();
            }
            object = this.getCurveLink(aNodePoint, aNodePoint2, (RectanglesCollection)object2);
            this.alreadyCurve.add((MyCurve)object);
            ((MyCurve)object).draw(graphics2D);
        }
        long l2 = System.currentTimeMillis() - l;
        System.err.println("TPS5 = " + l2);
        graphics2D.setColor(Color.GREEN);
        for (ANodePoint aNodePoint2 : this.nodePoints.values()) {
            object2 = this.frames.get(aNodePoint2);
            object = this.getImage(aNodePoint2.getNode());
            graphics2D.translate(((Frame)object2).getX(), ((Frame)object2).getY());
            ((AbstractEntityImage)object).draw(new ColorMapperIdentity(), graphics2D);
            graphics2D.translate(-((Frame)object2).getX(), -((Frame)object2).getY());
        }
    }

    private List<ALink> getSortedLinks() {
        final HashMap<ALink, Double> hashMap = new HashMap<ALink, Double>();
        for (ALink aLink : this.board.getLinks()) {
            ANodePoint aNodePoint = this.nodePoints.get(aLink.getNode1());
            ANodePoint aNodePoint2 = this.nodePoints.get(aLink.getNode2());
            hashMap.put(aLink, aNodePoint.getPosition().distance(aNodePoint2.getPosition()));
        }
        ArrayList arrayList = new ArrayList(hashMap.keySet());
        Collections.sort(arrayList, new Comparator<ALink>(){

            @Override
            public int compare(ALink aLink, ALink aLink2) {
                double d = (Double)hashMap.get(aLink) - (Double)hashMap.get(aLink2);
                return (int)Math.signum(d);
            }
        });
        return arrayList;
    }

    private MyCurve getCurveLink(ANodePoint aNodePoint, ANodePoint aNodePoint2, RectanglesCollection rectanglesCollection) {
        int n;
        int n2;
        int n3;
        int n4 = aNodePoint.getPosition().getXint();
        CubicCurve2D.Double double_ = new CubicCurve2D.Double(n4, n3 = aNodePoint.getPosition().getYint(), n4, n3, n2 = aNodePoint2.getPosition().getXint(), n = aNodePoint2.getPosition().getYint(), n2, n);
        MyCurve myCurve = new MyCurve(double_);
        if (myCurve.intersects(rectanglesCollection) || myCurve.intersects(this.alreadyCurve)) {
            CubicCurveFactory cubicCurveFactory = new CubicCurveFactory(aNodePoint.getPosition(), aNodePoint2.getPosition());
            for (Rectangle2D.Double object : rectanglesCollection) {
                cubicCurveFactory.addForbidden(object);
            }
            for (MyCurve myCurve2 : this.alreadyCurve) {
                cubicCurveFactory.addForbidden(myCurve2);
            }
            return cubicCurveFactory.getCubicCurve2D();
        }
        return myCurve;
    }

    private RectanglesCollection getForbidden(ALink aLink) {
        RectanglesCollection rectanglesCollection = new RectanglesCollection();
        for (Map.Entry<ANode, ANodePoint> entry : this.nodePoints.entrySet()) {
            ANode aNode = entry.getKey();
            if (aLink.getNode1().equals(aNode) || aLink.getNode2().equals(aNode)) continue;
            ANodePoint aNodePoint = entry.getValue();
            Frame frame = this.frames.get(aNodePoint);
            rectanglesCollection.add(new Rectangle2D.Double(frame.getX(), frame.getY(), frame.getWidth(), frame.getHeight()));
        }
        return rectanglesCollection;
    }

    private AbstractEntityImage getImage(ANode aNode) {
        return new EntityImageFactory().createEntityImage((Entity)aNode.getUserData());
    }

    static {
        EmptyImageBuilder emptyImageBuilder = new EmptyImageBuilder(10, 10, Color.WHITE);
        dummyGraphics2D = emptyImageBuilder.getGraphics2D();
    }

    class ANodePoint
    implements Pointable,
    XMoveable {
        private final ANode node;
        private int deltaX = 0;
        private int deltaY = 0;

        public ANodePoint(ANode aNode) {
            this.node = aNode;
        }

        public Point2DInt getPosition() {
            return new Point2DInt(Graph4.this.board.getCol(this.node) * 40 + this.deltaX, this.node.getRow() * 40 + this.deltaY);
        }

        public void moveX(int n) {
            this.deltaX += n;
        }

        public void moveY(int n) {
            this.deltaY += n;
        }

        public ANode getNode() {
            return this.node;
        }
    }
}

