/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph;

import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cucadiagram.Entity;
import net.sourceforge.plantuml.graph.AbstractEntityImage;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.skin.CircleInterface;
import net.sourceforge.plantuml.ugraphic.ColorMapper;

class EntityImageCircleInterface
extends AbstractEntityImage {
    private final TextBlock name;
    private final CircleInterface circleInterface;

    public EntityImageCircleInterface(Entity entity) {
        super(entity);
        this.name = TextBlockUtils.create(StringUtils.getWithNewlines(entity.getDisplay()), new FontConfiguration(this.getFont14(), HtmlColor.BLACK), HorizontalAlignement.CENTER);
        this.circleInterface = new CircleInterface(this.getYellow(), this.getRed());
    }

    public Dimension2D getDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.name.calculateDimension(stringBounder);
        double d = this.circleInterface.getPreferredWidth(stringBounder);
        double d2 = this.circleInterface.getPreferredHeight(stringBounder);
        return new Dimension2DDouble(Math.max(d, dimension2D.getWidth()), d2 + dimension2D.getHeight());
    }

    public void draw(ColorMapper colorMapper, Graphics2D graphics2D) {
        throw new UnsupportedOperationException();
    }
}

