/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cucadiagram.Entity;
import net.sourceforge.plantuml.graph.AbstractEntityImage;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.StringBounderUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.ugraphic.ColorMapper;

class EntityImageActivity
extends AbstractEntityImage {
    private final TextBlock text;
    private final int xMargin = 10;
    private final int yMargin = 6;

    public EntityImageActivity(Entity entity) {
        super(entity);
        this.text = TextBlockUtils.create(StringUtils.getWithNewlines(entity.getDisplay()), new FontConfiguration(this.getFont14(), HtmlColor.BLACK), HorizontalAlignement.CENTER);
    }

    public Dimension2D getDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.text.calculateDimension(stringBounder);
        return Dimension2DDouble.delta(dimension2D, 20.0, 12.0);
    }

    public void draw(ColorMapper colorMapper, Graphics2D graphics2D) {
        Dimension2D dimension2D = this.getDimension(StringBounderUtils.asStringBounder(graphics2D));
        int n = (int)dimension2D.getWidth();
        int n2 = (int)dimension2D.getHeight();
        Polygon polygon = new Polygon();
        polygon.addPoint(0, 12);
        polygon.addPoint(20, 0);
        polygon.addPoint(n - 20, 0);
        polygon.addPoint(n, 12);
        polygon.addPoint(n, n2 - 12);
        polygon.addPoint(n - 20, n2);
        polygon.addPoint(20, n2);
        polygon.addPoint(0, n2 - 12);
        graphics2D.setColor(colorMapper.getMappedColor(this.getYellow()));
        graphics2D.fill(polygon);
        graphics2D.setColor(colorMapper.getMappedColor(this.getRed()));
        graphics2D.draw(polygon);
        graphics2D.setColor(Color.BLACK);
        this.text.drawTOBEREMOVED(colorMapper, graphics2D, 10.0, 6.0);
    }
}

