/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import javax.imageio.ImageIO;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.dot.DotData;
import net.sourceforge.plantuml.cucadiagram.dot.LabelBuilder;
import net.sourceforge.plantuml.cucadiagram.dot.LabelBuilderObjectOrClass;
import net.sourceforge.plantuml.cucadiagram.dot.Orientation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LabelBuilderTableLollipopDecorator
extends LabelBuilderObjectOrClass
implements LabelBuilder {
    private final LabelBuilder builder;
    private final String northPath;
    private final String southPath;
    private final String eastPath;
    private final String westPath;

    LabelBuilderTableLollipopDecorator(FileFormat fileFormat, DotData dotData, IEntity iEntity, LabelBuilder labelBuilder, String string, String string2, String string3, String string4, Collection<IEntity> collection) {
        super(fileFormat, dotData, iEntity);
        this.builder = labelBuilder;
        this.northPath = string;
        this.southPath = string2;
        this.eastPath = string3;
        this.westPath = string4;
    }

    @Override
    public void appendLabel(StringBuilder stringBuilder) throws IOException {
        String string = this.getBackColorAroundEntity(this.getEntity());
        stringBuilder.append("<TABLE BGCOLOR=" + string + " COLOR=" + string + " BORDER=\"0\" CELLBORDER=\"0\" CELLSPACING=\"1\" CELLPADDING=\"0\">");
        stringBuilder.append("<TR>");
        stringBuilder.append("<TD>");
        stringBuilder.append(" ");
        stringBuilder.append("</TD>");
        this.appendBlankOrImage(stringBuilder, this.northPath, Orientation.NORTH);
        stringBuilder.append("<TD>");
        stringBuilder.append(" ");
        stringBuilder.append("</TD>");
        stringBuilder.append("</TR>");
        stringBuilder.append("<TR>");
        this.appendBlankOrImage(stringBuilder, this.westPath, Orientation.WEST);
        stringBuilder.append("<TD PORT=\"h\">");
        this.builder.appendLabel(stringBuilder);
        if (this.builder.isUnderline()) {
            this.setUnderline(true);
        }
        stringBuilder.append("</TD>");
        this.appendBlankOrImage(stringBuilder, this.eastPath, Orientation.EAST);
        stringBuilder.append("</TR>");
        stringBuilder.append("<TR>");
        stringBuilder.append("<TD>");
        stringBuilder.append(" ");
        stringBuilder.append("</TD>");
        this.appendBlankOrImage(stringBuilder, this.southPath, Orientation.SOUTH);
        stringBuilder.append("<TD>");
        stringBuilder.append(" ");
        stringBuilder.append("</TD>");
        stringBuilder.append("</TR>");
        stringBuilder.append("</TABLE>");
    }

    private void appendBlankOrImage(StringBuilder stringBuilder, String string, Orientation orientation) throws IOException {
        if (string == null) {
            stringBuilder.append("<TD>");
            stringBuilder.append(" ");
            stringBuilder.append("</TD>");
        } else if (string.endsWith(".png")) {
            if (this.getData().getDpi() == 96) {
                BufferedImage bufferedImage = ImageIO.read(new File(string));
                int n = bufferedImage.getHeight();
                int n2 = bufferedImage.getWidth();
                stringBuilder.append("<TD><IMG SRC=\"" + string + "\"/></TD>");
            } else {
                this.addTdImageBugB1983(stringBuilder, string);
            }
        } else if (string.endsWith(".eps")) {
            stringBuilder.append("<TD><IMG SRC=\"" + string + "\"/></TD>");
        }
    }
}

