/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizUtils;
import net.sourceforge.plantuml.cucadiagram.dot.ProcessRunner;
import net.sourceforge.plantuml.graphic.GraphicStrings;

abstract class Executable {
    private final File dotExe;

    static boolean isWindows() {
        return File.separatorChar == '\\';
    }

    Executable(String string, String ... stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException();
        }
        this.dotExe = this.searchDotExe();
    }

    private File searchDotExe() {
        if (OptionFlags.getInstance().getDotExecutable() == null) {
            String string = GraphvizUtils.getenvGraphvizDot();
            if (string == null) {
                return this.specificDotExe();
            }
            return new File(string);
        }
        return new File(OptionFlags.getInstance().getDotExecutable());
    }

    protected abstract File specificDotExe();

    public final String dotVersion() throws IOException, InterruptedException {
        String string = this.getCommandLineVersion();
        return this.executeCmd(string);
    }

    private String executeCmd(String string) throws IOException, InterruptedException {
        ProcessRunner processRunner = new ProcessRunner(string);
        processRunner.run(null, null);
        StringBuilder stringBuilder = new StringBuilder();
        if (StringUtils.isNotEmpty(processRunner.getOut())) {
            stringBuilder.append(processRunner.getOut());
        }
        if (StringUtils.isNotEmpty(processRunner.getError())) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(processRunner.getError());
        }
        return stringBuilder.toString().replace('\n', ' ').trim();
    }

    private final void createPngNoGraphviz(OutputStream outputStream, FileFormatOption fileFormatOption) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Dot Executable: " + this.dotExe);
        if (this.dotExe != null) {
            if (!this.dotExe.exists()) {
                arrayList.add("File does not exist");
            } else if (this.dotExe.isDirectory()) {
                arrayList.add("It should be an executable, not a directory");
            } else if (!this.dotExe.isFile()) {
                arrayList.add("Not a valid file");
            } else if (!this.dotExe.canRead()) {
                arrayList.add("File cannot be read");
            }
        }
        arrayList.add("Cannot find Graphviz. You should try");
        arrayList.add(" ");
        arrayList.add("@startuml");
        arrayList.add("testdot");
        arrayList.add("@enduml");
        arrayList.add(" ");
        arrayList.add(" or ");
        arrayList.add(" ");
        arrayList.add("java -jar plantuml.jar -testdot");
        GraphicStrings graphicStrings = new GraphicStrings(arrayList);
        graphicStrings.writeImage(outputStream, fileFormatOption);
    }

    abstract String getCommandLine();

    abstract String getCommandLineVersion();

    public final File getDotExe() {
        return this.dotExe;
    }
}

