/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.cucadiagram.EntityPortion;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.cucadiagram.Group;
import net.sourceforge.plantuml.cucadiagram.GroupHierarchy;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.cucadiagram.Rankdir;
import net.sourceforge.plantuml.cucadiagram.dot.DrawFile;
import net.sourceforge.plantuml.cucadiagram.dot.StaticFilesMap;
import net.sourceforge.plantuml.skin.VisibilityModifier;
import net.sourceforge.plantuml.ugraphic.ColorMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DotData
implements PortionShower {
    private final List<Link> links;
    private final Map<String, ? extends IEntity> entities;
    private final UmlDiagramType umlDiagramType;
    private final ISkinParam skinParam;
    private final Rankdir rankdir;
    private final GroupHierarchy groupHierarchy;
    private final Group topParent;
    private final PortionShower portionShower;
    private int dpi = 96;
    private StaticFilesMap staticFilesMap;
    private boolean visibilityModifierPresent;
    private final ColorMapper colorMapper;
    private boolean hideEmptyDescription = false;

    public DotData(Group group, List<Link> list, Map<String, ? extends IEntity> map, UmlDiagramType umlDiagramType, ISkinParam iSkinParam, Rankdir rankdir, GroupHierarchy groupHierarchy, PortionShower portionShower, ColorMapper colorMapper) {
        this.topParent = group;
        this.colorMapper = colorMapper;
        this.links = list;
        this.entities = map;
        this.umlDiagramType = umlDiagramType;
        this.skinParam = iSkinParam;
        this.rankdir = rankdir;
        this.groupHierarchy = groupHierarchy;
        this.portionShower = portionShower;
    }

    public DotData(Group group, List<Link> list, Map<String, ? extends IEntity> map, UmlDiagramType umlDiagramType, ISkinParam iSkinParam, Rankdir rankdir, GroupHierarchy groupHierarchy, ColorMapper colorMapper) {
        this(group, list, map, umlDiagramType, iSkinParam, rankdir, groupHierarchy, new PortionShower(){

            public boolean showPortion(EntityPortion entityPortion, IEntity iEntity) {
                return true;
            }
        }, colorMapper);
    }

    public boolean hasUrl() {
        return true;
    }

    public DrawFile getStaticImages(EntityType entityType, String string) throws IOException {
        this.checkObjectOrClassDiagram();
        assert (entityType == EntityType.ABSTRACT_CLASS || entityType == EntityType.CLASS || entityType == EntityType.ENUM || entityType == EntityType.INTERFACE || entityType == EntityType.LOLLIPOP);
        return this.staticFilesMap.getStaticFiles(string).getStaticImages(entityType);
    }

    public DrawFile getVisibilityImages(VisibilityModifier visibilityModifier, String string) throws IOException {
        this.checkObjectOrClassDiagram();
        return this.staticFilesMap.getStaticFiles(string).getVisibilityImages(visibilityModifier);
    }

    public boolean isThereVisibilityImages() {
        return this.visibilityModifierPresent;
    }

    public void setVisibilityModifierPresent(boolean bl) {
        this.checkObjectOrClassDiagram();
        this.visibilityModifierPresent = bl;
    }

    public void setStaticImagesMap(StaticFilesMap staticFilesMap) {
        this.checkObjectOrClassDiagram();
        this.staticFilesMap = staticFilesMap;
    }

    private void checkObjectOrClassDiagram() {
        if (this.umlDiagramType != UmlDiagramType.CLASS && this.umlDiagramType != UmlDiagramType.OBJECT) {
            throw new IllegalStateException();
        }
    }

    public UmlDiagramType getUmlDiagramType() {
        return this.umlDiagramType;
    }

    public ISkinParam getSkinParam() {
        return this.skinParam;
    }

    public Rankdir getRankdir() {
        return this.rankdir;
    }

    public GroupHierarchy getGroupHierarchy() {
        return this.groupHierarchy;
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public Map<String, ? extends IEntity> getEntities() {
        return this.entities;
    }

    public final Set<IEntity> getAllLinkedTo(IEntity iEntity) {
        HashSet<IEntity> hashSet = new HashSet<IEntity>();
        hashSet.add(iEntity);
        int n = 0;
        do {
            n = hashSet.size();
            for (IEntity iEntity2 : this.entities.values()) {
                if (!this.isDirectyLinked(iEntity2, hashSet)) continue;
                hashSet.add(iEntity2);
            }
        } while (n != hashSet.size());
        hashSet.remove(iEntity);
        return Collections.unmodifiableSet(hashSet);
    }

    public final Set<IEntity> getAllLinkedDirectedTo(IEntity iEntity) {
        HashSet<IEntity> hashSet = new HashSet<IEntity>();
        for (IEntity iEntity2 : this.entities.values()) {
            if (!this.isDirectlyLinkedSlow(iEntity2, iEntity)) continue;
            hashSet.add(iEntity2);
        }
        return Collections.unmodifiableSet(hashSet);
    }

    private boolean isDirectyLinked(IEntity iEntity, Collection<IEntity> collection) {
        for (IEntity iEntity2 : collection) {
            if (!this.isDirectlyLinkedSlow(iEntity, iEntity2)) continue;
            return true;
        }
        return false;
    }

    private boolean isDirectlyLinkedSlow(IEntity iEntity, IEntity iEntity2) {
        for (Link link : this.links) {
            if (!link.isBetween(iEntity, iEntity2)) continue;
            return true;
        }
        return false;
    }

    public boolean isThereLink(Group group) {
        for (Link link : this.links) {
            if (link.getEntity1() != group.getEntityCluster() && link.getEntity2() != group.getEntityCluster()) continue;
            return true;
        }
        return false;
    }

    public List<Link> getAutoLinks(Group group) {
        ArrayList<Link> arrayList = new ArrayList<Link>();
        for (Link link : this.links) {
            if (!link.isAutolink(group)) continue;
            arrayList.add(link);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public List<Link> getToEdgeLinks(Group group) {
        ArrayList<Link> arrayList = new ArrayList<Link>();
        for (Link link : this.links) {
            if (!link.isToEdgeLink(group)) continue;
            arrayList.add(link);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public List<Link> getFromEdgeLinks(Group group) {
        ArrayList<Link> arrayList = new ArrayList<Link>();
        for (Link link : this.links) {
            if (!link.isFromEdgeLink(group)) continue;
            arrayList.add(link);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public final Group getTopParent() {
        return this.topParent;
    }

    public boolean isEmpty(Group group) {
        return this.groupHierarchy.isEmpty(group);
    }

    @Override
    public boolean showPortion(EntityPortion entityPortion, IEntity iEntity) {
        return this.portionShower.showPortion(entityPortion, iEntity);
    }

    public final int getDpi() {
        return this.dpi;
    }

    public double getDpiFactor() {
        if (this.dpi == 96) {
            return 1.0;
        }
        return (double)this.dpi / 96.0;
    }

    public final void setDpi(int n) {
        this.dpi = n;
    }

    public final void setHideEmptyDescription(boolean bl) {
        this.hideEmptyDescription = bl;
    }

    public final boolean isHideEmptyDescription() {
        return this.hideEmptyDescription;
    }

    public final ColorMapper getColorMapper() {
        return this.colorMapper;
    }
}

