/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.Entity;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.posimo.Block;
import net.sourceforge.plantuml.posimo.Cluster;
import net.sourceforge.plantuml.posimo.GraphvizSolverB;
import net.sourceforge.plantuml.posimo.Path;
import net.sourceforge.plantuml.ugraphic.txt.UGraphicTxt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CucaDiagramTxtMaker {
    private final CucaDiagram diagram;
    private final FileFormat fileFormat;
    private final UGraphicTxt ug = new UGraphicTxt();

    private static double getXPixelPerChar() {
        return 5.0;
    }

    private static double getYPixelPerChar() {
        return 10.0;
    }

    public CucaDiagramTxtMaker(CucaDiagram cucaDiagram, FileFormat fileFormat) throws IOException {
        Object object;
        this.diagram = cucaDiagram;
        this.fileFormat = fileFormat;
        Cluster cluster = new Cluster(null, 0.0, 0.0);
        int n = 0;
        HashMap<Entity, Block> hashMap = new HashMap<Entity, Block>();
        for (Entity object2 : cucaDiagram.entities().values()) {
            double dimension2D = (double)this.getWidth(object2) * CucaDiagramTxtMaker.getXPixelPerChar();
            double block2 = (double)this.getHeight(object2) * CucaDiagramTxtMaker.getYPixelPerChar();
            object = new Block(n++, dimension2D, block2, null);
            cluster.addBloc((Block)object);
            hashMap.put(object2, (Block)object);
        }
        GraphvizSolverB graphvizSolverB = new GraphvizSolverB();
        try {
            Block block;
            ArrayList<Path> interruptedException = new ArrayList<Path>();
            for (Link link : cucaDiagram.getLinks()) {
                Block path = (Block)hashMap.get(link.getEntity1());
                block = (Block)hashMap.get(link.getEntity2());
                interruptedException.add(new Path(path, block, null, link.getLength()));
            }
            Dimension2D dimension2D = graphvizSolverB.solve(cluster, interruptedException);
            for (Path entity : interruptedException) {
                this.ug.setTranslate(0.0, 0.0);
                entity.getDotPath().draw(this.ug.getCharArea(), CucaDiagramTxtMaker.getXPixelPerChar(), CucaDiagramTxtMaker.getYPixelPerChar());
            }
            for (Entity entity : cucaDiagram.entities().values()) {
                block = (Block)hashMap.get(entity);
                object = block.getPosition();
                this.ug.setTranslate(((Point2D)object).getX() / CucaDiagramTxtMaker.getXPixelPerChar(), ((Point2D)object).getY() / CucaDiagramTxtMaker.getYPixelPerChar());
                this.printClass(entity);
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void printClass(Entity entity) {
        List<String> list;
        int n = this.getWidth(entity);
        int n2 = this.getHeight(entity);
        this.ug.getCharArea().drawBoxSimple(0, 0, n, n2);
        this.ug.getCharArea().drawStringsLR(StringUtils.getWithNewlines(entity.getDisplay()), 1, 1);
        int n3 = 2;
        this.ug.getCharArea().drawHLine('-', n3, 1, n - 1);
        ++n3;
        for (Member member : entity.getFieldsToDisplay()) {
            list = StringUtils.getWithNewlines(member.getDisplayWithVisibilityChar());
            this.ug.getCharArea().drawStringsLR(list, 1, n3);
            n3 += StringUtils.getHeight(list);
        }
        this.ug.getCharArea().drawHLine('-', n3, 1, n - 1);
        ++n3;
        for (Member member : entity.getMethodsToDisplay()) {
            list = StringUtils.getWithNewlines(member.getDisplayWithVisibilityChar());
            this.ug.getCharArea().drawStringsLR(list, 1, n3);
            n3 += StringUtils.getHeight(list);
        }
    }

    public List<File> createFiles(File file) throws IOException {
        if (this.fileFormat == FileFormat.UTXT) {
            this.ug.getCharArea().print(new PrintStream(file, "UTF-8"));
        } else {
            this.ug.getCharArea().print(new PrintStream(file));
        }
        return Collections.singletonList(file);
    }

    private int getHeight(Entity entity) {
        int n = StringUtils.getHeight(StringUtils.getWithNewlines(entity.getDisplay()));
        for (Member member : entity.getMethodsToDisplay()) {
            n += StringUtils.getHeight(StringUtils.getWithNewlines(member.getDisplayWithVisibilityChar()));
        }
        for (Member member : entity.getFieldsToDisplay()) {
            n += StringUtils.getHeight(StringUtils.getWithNewlines(member.getDisplayWithVisibilityChar()));
        }
        return n + 4;
    }

    private int getWidth(Entity entity) {
        int n;
        int n2 = StringUtils.getWidth(StringUtils.getWithNewlines(entity.getDisplay()));
        for (Member member : entity.getMethodsToDisplay()) {
            n = StringUtils.getWidth(StringUtils.getWithNewlines(member.getDisplayWithVisibilityChar()));
            if (n <= n2) continue;
            n2 = n;
        }
        for (Member member : entity.getFieldsToDisplay()) {
            n = StringUtils.getWidth(StringUtils.getWithNewlines(member.getDisplayWithVisibilityChar()));
            if (n <= n2) continue;
            n2 = n;
        }
        return n2 + 2;
    }

    public void createFiles(OutputStream outputStream, int n) {
        this.ug.getCharArea().print(new PrintStream(outputStream));
    }
}

