/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.Entity;
import net.sourceforge.plantuml.cucadiagram.Group;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.dot.PlayField;
import net.sourceforge.plantuml.png.PngIO;
import net.sourceforge.plantuml.png.PngSplitter;
import net.sourceforge.plantuml.ugraphic.g2d.UGraphicG2d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CucaDiagramFileMakerBeta {
    private final CucaDiagram diagram;

    public CucaDiagramFileMakerBeta(CucaDiagram cucaDiagram) throws IOException {
        this.diagram = cucaDiagram;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<File> createFile(File file, List<String> list, FileFormat fileFormat) throws IOException, InterruptedException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            this.createFile(fileOutputStream, list, fileFormat);
        }
        finally {
            if (fileOutputStream != null) {
                ((OutputStream)fileOutputStream).close();
            }
        }
        if (fileFormat == FileFormat.PNG) {
            List<File> list2 = new PngSplitter(file, this.diagram.getHorizontalPages(), this.diagram.getVerticalPages(), this.diagram.getMetadata(), 96).getFiles();
            for (File file2 : list2) {
                Log.info("Creating file: " + file2);
            }
            return list2;
        }
        Log.info("Creating file: " + file);
        return Arrays.asList(file);
    }

    public void createFile(OutputStream outputStream, List<String> list, FileFormat fileFormat) throws IOException, InterruptedException {
        if (fileFormat != FileFormat.PNG) {
            throw new UnsupportedOperationException();
        }
        this.createPng(outputStream, list);
    }

    private void createPng(OutputStream outputStream, List<String> list) throws IOException, InterruptedException {
        Color color = this.diagram.getColorMapper().getMappedColor(this.diagram.getSkinParam().getBackgroundColor());
        EmptyImageBuilder emptyImageBuilder = new EmptyImageBuilder(10, 10, color);
        BufferedImage bufferedImage = emptyImageBuilder.getBufferedImage();
        Graphics2D graphics2D = emptyImageBuilder.getGraphics2D();
        UGraphicG2d uGraphicG2d = new UGraphicG2d(this.diagram.getColorMapper(), graphics2D, bufferedImage, 1.0);
        PlayField playField = new PlayField(this.diagram.getSkinParam());
        Collection<IEntity> collection = this.getFirstLevelEntities();
        List<Link> list2 = this.diagram.getLinks();
        playField.initInternal(collection, list2, uGraphicG2d.getStringBounder());
        graphics2D.dispose();
        Dimension2D dimension2D = playField.solve();
        emptyImageBuilder = new EmptyImageBuilder(dimension2D.getWidth() + 1.0, dimension2D.getHeight() + 1.0, color);
        bufferedImage = emptyImageBuilder.getBufferedImage();
        graphics2D = emptyImageBuilder.getGraphics2D();
        graphics2D.translate(10, 0);
        uGraphicG2d = new UGraphicG2d(this.diagram.getColorMapper(), graphics2D, bufferedImage, 1.0);
        playField.drawInternal(uGraphicG2d);
        PngIO.write((RenderedImage)bufferedImage, outputStream, 96);
    }

    private Collection<IEntity> getFirstLevelEntities() {
        HashSet<IEntity> hashSet = new HashSet<IEntity>();
        this.diagram.computeAutonomyOfGroups();
        this.addEntitiesOfGroup(hashSet, null);
        return hashSet;
    }

    private void addEntitiesOfGroup(Collection<IEntity> collection, Group group) {
        for (Entity object2 : this.diagram.entities().values()) {
            if (object2.getParent() != group) continue;
            collection.add(object2);
        }
        Collection<Group> collection2 = group == null ? this.diagram.getGroups() : group.getChildren();
        Iterator iterator = collection2.iterator();
        while (iterator.hasNext()) {
            Group group2 = (Group)iterator.next();
            if (!group2.isAutonom()) {
                this.addEntitiesOfGroup(collection, group2);
                collection.add(group2.getEntityCluster());
                continue;
            }
            if (group2.getParent() != group) continue;
            assert (group2.isAutonom());
            assert (!collection.contains(group2.getEntityCluster()));
            collection.add(group2.getEntityCluster());
        }
    }
}

