/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FileUtils;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.Scale;
import net.sourceforge.plantuml.SkinParamBackcolored;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.UniqueSequence;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.Entity;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.cucadiagram.Group;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.cucadiagram.dot.CucaDiagramSimplifier;
import net.sourceforge.plantuml.cucadiagram.dot.DotData;
import net.sourceforge.plantuml.cucadiagram.dot.DrawFile;
import net.sourceforge.plantuml.cucadiagram.dot.Graphviz;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizMaker;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizUtils;
import net.sourceforge.plantuml.cucadiagram.dot.Lazy;
import net.sourceforge.plantuml.cucadiagram.dot.StaticFilesMap;
import net.sourceforge.plantuml.cucadiagram.dot.UnderlineTrick;
import net.sourceforge.plantuml.cucadiagram.dot.UnderlineTrickEps;
import net.sourceforge.plantuml.eps.EpsGraphics;
import net.sourceforge.plantuml.eps.EpsStrategy;
import net.sourceforge.plantuml.eps.EpsTitler;
import net.sourceforge.plantuml.graphic.CircledCharacter;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.StringBounderUtils;
import net.sourceforge.plantuml.graphic.VerticalPosition;
import net.sourceforge.plantuml.png.PngFlashcoder;
import net.sourceforge.plantuml.png.PngIO;
import net.sourceforge.plantuml.png.PngRotation;
import net.sourceforge.plantuml.png.PngScaler;
import net.sourceforge.plantuml.png.PngSizer;
import net.sourceforge.plantuml.png.PngTitler;
import net.sourceforge.plantuml.skin.CircleInterface;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.SimpleContext2D;
import net.sourceforge.plantuml.skin.StickMan;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.statediagram.StateDiagram;
import net.sourceforge.plantuml.svg.SvgData;
import net.sourceforge.plantuml.svg.SvgTitler;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.eps.UGraphicEps;
import net.sourceforge.plantuml.ugraphic.g2d.UGraphicG2d;
import net.sourceforge.plantuml.ugraphic.svg.UGraphicSvg;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CucaDiagramFileMaker {
    private final CucaDiagram diagram;
    private final List<BufferedImage> flashcodes;
    private final StaticFilesMap staticFilesMap;
    private final Rose rose = new Rose();
    private static final StringBounder stringBounder;
    private double deltaY;

    public CucaDiagramFileMaker(CucaDiagram cucaDiagram, List<BufferedImage> list) throws IOException {
        this.diagram = cucaDiagram;
        this.flashcodes = list;
        this.staticFilesMap = cucaDiagram.getUmlDiagramType() == UmlDiagramType.CLASS || cucaDiagram.getUmlDiagramType() == UmlDiagramType.OBJECT ? new StaticFilesMap(cucaDiagram.getSkinParam(), cucaDiagram.getDpiFactor(null)) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void traceDotString(String string) throws IOException {
        File file = new File("dottmpfile" + UniqueSequence.getValue() + ".tmp");
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileWriter(file));
            printWriter.print(string);
            Log.info("Creating file " + file);
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    public String createFile(OutputStream outputStream, List<String> list, FileFormatOption fileFormatOption) throws IOException, InterruptedException {
        FileFormat fileFormat = fileFormatOption.getFileFormat();
        if (fileFormat == FileFormat.PNG) {
            return this.createPng(outputStream, list, fileFormatOption);
        }
        if (fileFormat == FileFormat.SVG) {
            return this.createSvg(outputStream, list, fileFormatOption);
        }
        if (fileFormat == FileFormat.EPS_TEXT) {
            return this.createEps(outputStream, list, fileFormatOption);
        }
        if (fileFormat == FileFormat.EPS) {
            return this.createEps(outputStream, list, fileFormatOption);
        }
        if (fileFormat == FileFormat.DOT) {
            return this.createDot(outputStream, list, fileFormatOption);
        }
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createSvg(OutputStream outputStream, List<String> list, FileFormatOption fileFormatOption) throws IOException, InterruptedException {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            this.deltaY = 0.0;
            String string = this.getSvgData(list, fileFormatOption, stringBuilder);
            SvgData svgData = SvgData.fromGraphViz(string);
            if (svgData != null) {
                boolean bl;
                SvgTitler svgTitler = this.getTitleSvgTitler();
                SvgTitler svgTitler2 = this.getHeaderSvgTitler();
                SvgTitler svgTitler3 = this.getFooterSvgTitler();
                svgData = svgTitler.addTitle(svgData);
                svgData = svgTitler2.addTitle(svgData);
                svgData = svgTitler3.addTitle(svgData);
                Pattern pattern = Pattern.compile("(?i)<image\\W[^>]*>");
                string = svgData.getSvg();
                do {
                    bl = false;
                    Matcher matcher = pattern.matcher(string);
                    StringBuffer stringBuffer = new StringBuffer();
                    while (matcher.find()) {
                        String string2 = matcher.group(0);
                        String string3 = CucaDiagramFileMaker.getValue(string2, "href");
                        double d = Double.parseDouble(CucaDiagramFileMaker.getValuePx(string2, "width"));
                        double d2 = Double.parseDouble(CucaDiagramFileMaker.getValuePx(string2, "height"));
                        double d3 = Double.parseDouble(CucaDiagramFileMaker.getValue(string2, "x"));
                        double d4 = Double.parseDouble(CucaDiagramFileMaker.getValue(string2, "y"));
                        DrawFile drawFile = this.getDrawFileFromHref(string3);
                        if (drawFile == null) {
                            matcher.appendReplacement(stringBuffer, string2);
                            continue;
                        }
                        int n = drawFile.getWidthPng();
                        int n2 = drawFile.getHeightPng();
                        String string4 = drawFile.getSvg();
                        String string5 = CucaDiagramFileMaker.getScale(d, d2, n, n2);
                        string4 = string4.replaceFirst("<[gG]>", "<g transform=\"translate(0 0) " + string5 + "\">");
                        string4 = "<svg x=\"" + d3 + "\" y=\"" + d4 + "\">" + string4 + "</svg>";
                        matcher.appendReplacement(stringBuffer, string4);
                        bl = true;
                    }
                    matcher.appendTail(stringBuffer);
                    string = stringBuffer.toString();
                } while (bl);
            }
            outputStream.write(string.getBytes("UTF-8"));
        }
        finally {
            this.clean();
        }
        if (stringBuilder.length() > 0) {
            return CucaDiagramFileMaker.translateXY(stringBuilder.toString(), 0, (int)Math.round(this.deltaY));
        }
        return null;
    }

    static String translateXY(String string, int n, int n2) {
        if (n2 == 0) {
            return string;
        }
        Pattern pattern = Pattern.compile("coords=\"(\\d+),(\\d+),(\\d+),(\\d+)\"");
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            int n3 = Integer.parseInt(matcher.group(1)) + n;
            int n4 = Integer.parseInt(matcher.group(2)) + n2;
            int n5 = Integer.parseInt(matcher.group(3)) + n;
            int n6 = Integer.parseInt(matcher.group(4)) + n2;
            matcher.appendReplacement(stringBuffer, "coords=\"" + n3 + "," + n4 + "," + n5 + "," + n6 + "\"");
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    private String getSvgData(List<String> list, FileFormatOption fileFormatOption, StringBuilder stringBuilder) throws IOException, InterruptedException, UnsupportedEncodingException {
        GraphvizMaker graphvizMaker = this.populateImagesAndCreateGraphvizMaker(list, fileFormatOption);
        String string = graphvizMaker.createDotString();
        if (OptionFlags.getInstance().isKeepTmpFiles()) {
            CucaDiagramFileMaker.traceDotString(string);
        }
        Graphviz graphviz = GraphvizUtils.create(string, "svg");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        graphviz.createPng(byteArrayOutputStream);
        byteArrayOutputStream.close();
        graphvizMaker.clean();
        return new String(byteArrayOutputStream.toByteArray(), "UTF-8").replace('\\', '/');
    }

    private DrawFile searchImageFile(File file, Collection<? extends IEntity> collection) throws IOException {
        for (IEntity iEntity : collection) {
            DrawFile drawFile = iEntity.getImageFile(file);
            if (drawFile == null) continue;
            assert (drawFile.getPng().getCanonicalFile().equals(file.getCanonicalFile()));
            return drawFile;
        }
        return null;
    }

    private DrawFile getDrawFileFromHref(String string) throws IOException {
        Object object;
        if ((this.diagram.getUmlDiagramType() == UmlDiagramType.CLASS || this.diagram.getUmlDiagramType() == UmlDiagramType.OBJECT) && (object = this.staticFilesMap.getDrawFile(string)) != null) {
            return object;
        }
        object = new File(string).getCanonicalFile();
        DrawFile drawFile = this.searchImageFile((File)object, this.diagram.entities().values());
        if (drawFile != null) {
            return drawFile;
        }
        for (Link link : this.diagram.getLinks()) {
            DrawFile drawFile2 = link.getImageFile();
            if (drawFile2 == null || !drawFile2.getPng().getCanonicalFile().equals(object)) continue;
            return drawFile2;
        }
        Log.error("Cannot find " + string);
        return null;
    }

    private static String getScale(double d, double d2, double d3, double d4) {
        double d5 = d2 / d4;
        double d6 = d / d3;
        double d7 = Math.min(d5, d6);
        return "scale(" + CucaDiagramFileMaker.format(d7) + " " + CucaDiagramFileMaker.format(d7) + ")";
    }

    private static String format(double d) {
        return EpsGraphics.format(d);
    }

    private static String getValue(String string, String string2) {
        Pattern pattern = Pattern.compile("(?i)" + string2 + "=\"([^\"]+)\"");
        Matcher matcher = pattern.matcher(string);
        matcher.find();
        return matcher.group(1);
    }

    private static String getValuePx(String string, String string2) {
        Pattern pattern = Pattern.compile("(?i)" + string2 + "=\"([^\"]+?)(?:px)?\"");
        Matcher matcher = pattern.matcher(string);
        matcher.find();
        return matcher.group(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createPng(OutputStream outputStream, List<String> list, FileFormatOption fileFormatOption) throws IOException, InterruptedException {
        StringBuilder stringBuilder = new StringBuilder();
        double d = 0.0;
        double d2 = 0.0;
        try {
            byte[] byArray;
            GraphvizMaker graphvizMaker = this.populateImagesAndCreateGraphvizMaker(list, fileFormatOption);
            String string = graphvizMaker.createDotString();
            if (OptionFlags.getInstance().isKeepTmpFiles()) {
                CucaDiagramFileMaker.traceDotString(string);
            }
            if ((byArray = this.getImageData(string, stringBuilder)).length == 0) {
                this.createError(outputStream, byArray.length, new FileFormatOption(FileFormat.PNG), "imageData.length == 0");
                String string2 = null;
                return string2;
            }
            if (!this.isPngHeader(byArray, 0)) {
                this.createError(outputStream, byArray.length, new FileFormatOption(FileFormat.PNG), "No PNG header found", "Try -forcegd or -forcecairo flag");
                String string3 = null;
                return string3;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            BufferedImage bufferedImage = ImageIO.read(byteArrayInputStream);
            if (bufferedImage == null) {
                this.createError(outputStream, byArray.length, new FileFormatOption(FileFormat.PNG), "im == null");
                String string4 = null;
                return string4;
            }
            byteArrayInputStream.close();
            graphvizMaker.clean();
            boolean bl = graphvizMaker.isUnderline();
            if (bl) {
                new UnderlineTrick(bufferedImage, new Color(Integer.parseInt("FEFECF", 16)), Color.BLACK).process();
            }
            HtmlColor htmlColor = this.diagram.getSkinParam().getBackgroundColor();
            d2 = this.getTitlePngHeight(stringBounder);
            d2 += this.getHeaderPngHeight(stringBounder);
            d = this.getOffsetX(stringBounder, bufferedImage.getWidth());
            bufferedImage = this.addTitle(bufferedImage, htmlColor);
            bufferedImage = this.addFooter(bufferedImage, htmlColor);
            bufferedImage = this.addHeader(bufferedImage, htmlColor);
            bufferedImage = this.scaleImage(bufferedImage, this.diagram.getScale());
            if (this.diagram.isRotation()) {
                bufferedImage = PngRotation.process(bufferedImage);
            }
            bufferedImage = PngSizer.process(bufferedImage, this.diagram.getMinwidth());
            bufferedImage = this.addFlashcode(bufferedImage, this.diagram.getColorMapper().getMappedColor(htmlColor));
            PngIO.write((RenderedImage)bufferedImage, outputStream, this.diagram.getMetadata(), this.diagram.getDpi(fileFormatOption));
        }
        finally {
            this.clean();
        }
        if (stringBuilder.length() > 0) {
            return CucaDiagramFileMaker.translateXY(stringBuilder.toString(), (int)Math.round(d), (int)Math.round(d2));
        }
        return null;
    }

    private BufferedImage addFlashcode(BufferedImage bufferedImage, Color color) {
        if (this.flashcodes == null) {
            return bufferedImage;
        }
        return new PngFlashcoder(this.flashcodes).processImage(bufferedImage, color);
    }

    private String createDot(OutputStream outputStream, List<String> list, FileFormatOption fileFormatOption) throws IOException, InterruptedException {
        GraphvizMaker graphvizMaker = this.populateImagesAndCreateGraphvizMaker(list, fileFormatOption);
        String string = graphvizMaker.createDotString();
        outputStream.write(string.getBytes());
        return null;
    }

    private BufferedImage scaleImage(BufferedImage bufferedImage, Scale scale) {
        if (scale == null) {
            return bufferedImage;
        }
        return PngScaler.scale(bufferedImage, scale.getScale(bufferedImage.getWidth(), bufferedImage.getHeight()));
    }

    private byte[] getImageDataCmap(String string, StringBuilder stringBuilder) throws IOException, InterruptedException {
        Graphviz graphviz = GraphvizUtils.create(string, "cmapx", this.getPngType());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        graphviz.createPng(byteArrayOutputStream);
        byteArrayOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        Log.info("Reading " + byArray.length + " bytes from dot");
        int n = this.getPngStart(byArray);
        String string2 = new String(byArray, 0, n, "UTF8");
        Log.info("CMAP is " + string2.length() + " long");
        stringBuilder.append(string2);
        byte[] byArray2 = new byte[byArray.length - n];
        System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
        Log.info("PNG is " + byArray2.length + " bytes from dot");
        return byArray2;
    }

    private int getPngStart(byte[] byArray) throws IOException {
        for (int i = 0; i < byArray.length - 8; ++i) {
            if (!this.isPngHeader(byArray, i)) continue;
            return i;
        }
        throw new IOException("Cannot find PNG header");
    }

    private boolean isPngHeader(byte[] byArray, int n) {
        if (n + 7 >= byArray.length) {
            return false;
        }
        return byArray[n] == -119 && byArray[n + 1] == 80 && byArray[n + 2] == 78 && byArray[n + 3] == 71 && byArray[n + 4] == 13 && byArray[n + 5] == 10 && byArray[n + 6] == 26 && byArray[n + 7] == 10;
    }

    private byte[] getImageData(String string, StringBuilder stringBuilder) throws IOException, InterruptedException {
        if (this.diagram.hasUrl()) {
            return this.getImageDataCmap(string, stringBuilder);
        }
        Graphviz graphviz = GraphvizUtils.create(string, this.getPngType());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        graphviz.createPng(byteArrayOutputStream);
        byteArrayOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        Log.info("Reading " + byArray.length + " bytes from dot");
        return byArray;
    }

    private String getPngType() {
        if (OptionFlags.getInstance().isForceCairo()) {
            return "png:cairo";
        }
        if (OptionFlags.getInstance().isForceGd()) {
            return "png:gd";
        }
        return "png";
    }

    void createError(OutputStream outputStream, int n, FileFormatOption fileFormatOption, String ... stringArray) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Error: Reading " + n + " byte(s) from dot");
        arrayList.add("Error reading the generated image");
        for (String string : stringArray) {
            arrayList.add(string);
        }
        GraphicStrings graphicStrings = new GraphicStrings(arrayList);
        graphicStrings.writeImage(outputStream, fileFormatOption);
    }

    private BufferedImage addTitle(BufferedImage bufferedImage, HtmlColor htmlColor) {
        HtmlColor htmlColor2 = this.diagram.getSkinParam().getFontHtmlColor(FontParam.TITLE, null);
        UFont uFont = this.getSkinParam().getFont(FontParam.TITLE, null);
        String string = uFont.getFamily(null);
        int n = uFont.getSize();
        PngTitler pngTitler = new PngTitler(this.diagram.getColorMapper(), htmlColor2, this.diagram.getTitle(), n, string, HorizontalAlignement.CENTER, VerticalPosition.TOP);
        return pngTitler.processImage(bufferedImage, htmlColor, 3);
    }

    private double getTitlePngHeight(StringBounder stringBounder) throws IOException {
        HtmlColor htmlColor = this.diagram.getSkinParam().getFontHtmlColor(FontParam.TITLE, null);
        UFont uFont = this.getSkinParam().getFont(FontParam.TITLE, null);
        String string = uFont.getFamily(null);
        int n = uFont.getSize();
        PngTitler pngTitler = new PngTitler(this.diagram.getColorMapper(), htmlColor, this.diagram.getTitle(), n, string, HorizontalAlignement.CENTER, VerticalPosition.TOP);
        return pngTitler.getOffsetY(stringBounder);
    }

    private double getOffsetX(StringBounder stringBounder, double d) throws IOException {
        HtmlColor htmlColor = this.diagram.getSkinParam().getFontHtmlColor(FontParam.TITLE, null);
        UFont uFont = this.getSkinParam().getFont(FontParam.TITLE, null);
        String string = uFont.getFamily(null);
        int n = uFont.getSize();
        PngTitler pngTitler = new PngTitler(this.diagram.getColorMapper(), htmlColor, this.diagram.getTitle(), n, string, HorizontalAlignement.CENTER, VerticalPosition.TOP);
        return pngTitler.getOffsetX(d, stringBounder);
    }

    private SvgTitler getTitleSvgTitler() throws IOException {
        HtmlColor htmlColor = this.diagram.getSkinParam().getFontHtmlColor(FontParam.TITLE, null);
        UFont uFont = this.getSkinParam().getFont(FontParam.TITLE, null);
        String string = uFont.getFamily(null);
        int n = uFont.getSize();
        return new SvgTitler(this.diagram.getColorMapper(), htmlColor, this.diagram.getTitle(), n, string, HorizontalAlignement.CENTER, VerticalPosition.TOP, 3);
    }

    private SvgTitler getHeaderSvgTitler() throws IOException {
        HtmlColor htmlColor = this.diagram.getSkinParam().getFontHtmlColor(FontParam.HEADER, null);
        UFont uFont = this.getSkinParam().getFont(FontParam.HEADER, null);
        String string = uFont.getFamily(null);
        int n = uFont.getSize();
        return new SvgTitler(this.diagram.getColorMapper(), htmlColor, this.diagram.getHeader(), n, string, this.diagram.getHeaderAlignement(), VerticalPosition.TOP, 3);
    }

    private SvgTitler getFooterSvgTitler() throws IOException {
        HtmlColor htmlColor = this.diagram.getSkinParam().getFontHtmlColor(FontParam.FOOTER, null);
        UFont uFont = this.getSkinParam().getFont(FontParam.FOOTER, null);
        String string = uFont.getFamily(null);
        int n = uFont.getSize();
        return new SvgTitler(this.diagram.getColorMapper(), htmlColor, this.diagram.getFooter(), n, string, this.diagram.getFooterAlignement(), VerticalPosition.BOTTOM, 3);
    }

    private String addTitleEps(EpsStrategy epsStrategy, String string) throws IOException {
        HtmlColor htmlColor = this.diagram.getSkinParam().getFontHtmlColor(FontParam.TITLE, null);
        UFont uFont = this.getSkinParam().getFont(FontParam.TITLE, null);
        String string2 = uFont.getFamily(null);
        int n = uFont.getSize();
        EpsTitler epsTitler = new EpsTitler(this.diagram.getColorMapper(), epsStrategy, htmlColor, this.diagram.getTitle(), n, string2, HorizontalAlignement.CENTER, VerticalPosition.TOP, 3);
        this.deltaY += epsTitler.getHeight();
        return epsTitler.addTitleEps(string);
    }

    private String addFooterEps(EpsStrategy epsStrategy, String string) throws IOException {
        HtmlColor htmlColor = this.diagram.getSkinParam().getFontHtmlColor(FontParam.FOOTER, null);
        UFont uFont = this.getSkinParam().getFont(FontParam.FOOTER, null);
        String string2 = uFont.getFamily(null);
        int n = uFont.getSize();
        EpsTitler epsTitler = new EpsTitler(this.diagram.getColorMapper(), epsStrategy, htmlColor, this.diagram.getFooter(), n, string2, this.diagram.getFooterAlignement(), VerticalPosition.BOTTOM, 3);
        return epsTitler.addTitleEps(string);
    }

    private String addHeaderEps(EpsStrategy epsStrategy, String string) throws IOException {
        HtmlColor htmlColor = this.diagram.getSkinParam().getFontHtmlColor(FontParam.HEADER, null);
        UFont uFont = this.getSkinParam().getFont(FontParam.HEADER, null);
        String string2 = uFont.getFamily(null);
        int n = uFont.getSize();
        EpsTitler epsTitler = new EpsTitler(this.diagram.getColorMapper(), epsStrategy, htmlColor, this.diagram.getHeader(), n, string2, this.diagram.getHeaderAlignement(), VerticalPosition.TOP, 3);
        this.deltaY += epsTitler.getHeight();
        return epsTitler.addTitleEps(string);
    }

    private BufferedImage addFooter(BufferedImage bufferedImage, HtmlColor htmlColor) {
        HtmlColor htmlColor2 = this.diagram.getSkinParam().getFontHtmlColor(FontParam.FOOTER, null);
        UFont uFont = this.getSkinParam().getFont(FontParam.FOOTER, null);
        String string = uFont.getFamily(null);
        int n = uFont.getSize();
        PngTitler pngTitler = new PngTitler(this.diagram.getColorMapper(), htmlColor2, this.diagram.getFooter(), n, string, this.diagram.getFooterAlignement(), VerticalPosition.BOTTOM);
        return pngTitler.processImage(bufferedImage, htmlColor, 3);
    }

    private BufferedImage addHeader(BufferedImage bufferedImage, HtmlColor htmlColor) throws IOException {
        HtmlColor htmlColor2 = this.diagram.getSkinParam().getFontHtmlColor(FontParam.HEADER, null);
        UFont uFont = this.getSkinParam().getFont(FontParam.HEADER, null);
        String string = uFont.getFamily(null);
        int n = uFont.getSize();
        PngTitler pngTitler = new PngTitler(this.diagram.getColorMapper(), htmlColor2, this.diagram.getHeader(), n, string, this.diagram.getHeaderAlignement(), VerticalPosition.TOP);
        return pngTitler.processImage(bufferedImage, htmlColor, 3);
    }

    private double getHeaderPngHeight(StringBounder stringBounder) throws IOException {
        HtmlColor htmlColor = this.diagram.getSkinParam().getFontHtmlColor(FontParam.HEADER, null);
        UFont uFont = this.getSkinParam().getFont(FontParam.HEADER, null);
        String string = uFont.getFamily(null);
        int n = uFont.getSize();
        PngTitler pngTitler = new PngTitler(this.diagram.getColorMapper(), htmlColor, this.diagram.getHeader(), n, string, this.diagram.getHeaderAlignement(), VerticalPosition.TOP);
        return pngTitler.getOffsetY(stringBounder);
    }

    DrawFile createImage(Entity entity, FileFormatOption fileFormatOption) throws IOException {
        double d = this.diagram.getDpiFactor(fileFormatOption);
        if (entity.getType() == EntityType.NOTE) {
            return this.createImageForNote(entity.getDisplay(), entity.getSpecificBackColor(), fileFormatOption, entity.getParent());
        }
        if (entity.getType() == EntityType.ACTOR) {
            return this.createImageForActor(entity, d);
        }
        if (entity.getType() == EntityType.CIRCLE_INTERFACE) {
            return this.createImageForCircleInterface(entity, d);
        }
        if (entity.getType() == EntityType.ABSTRACT_CLASS || entity.getType() == EntityType.CLASS || entity.getType() == EntityType.ENUM || entity.getType() == EntityType.INTERFACE) {
            return this.createImageForCircleCharacter(entity, d);
        }
        return null;
    }

    private DrawFile createImageForNote(String string, HtmlColor htmlColor, final FileFormatOption fileFormatOption, Group group) throws IOException {
        Rose rose = new Rose();
        SkinParamBackcolored skinParamBackcolored = new SkinParamBackcolored(this.getSkinParam(), htmlColor);
        final Component component = rose.createComponent(ComponentType.NOTE, skinParamBackcolored, StringUtils.getWithNewlines(string));
        final double d = this.diagram.getDpiFactor(fileFormatOption);
        final int n = (int)(component.getPreferredWidth(stringBounder) * d);
        final int n2 = (int)(component.getPreferredHeight(stringBounder) * d);
        final int n3 = this.diagram.getDpi(fileFormatOption);
        HtmlColor htmlColor2 = this.diagram.getSkinParam().getBackgroundColor();
        if (group != null && group.getBackColor() != null) {
            htmlColor2 = group.getBackColor();
        }
        final Color color = this.diagram.getColorMapper().getMappedColor(htmlColor2);
        Lazy<File> lazy = new Lazy<File>(){

            @Override
            public File getNow() throws IOException {
                File file = FileUtils.createTempFile("plantumlB", ".png");
                EmptyImageBuilder emptyImageBuilder = new EmptyImageBuilder(n, n2, color);
                BufferedImage bufferedImage = emptyImageBuilder.getBufferedImage();
                Graphics2D graphics2D = emptyImageBuilder.getGraphics2D();
                component.drawU(new UGraphicG2d(CucaDiagramFileMaker.this.diagram.getColorMapper(), graphics2D, null, d), new Dimension(n, n2), new SimpleContext2D(false));
                PngIO.write((RenderedImage)bufferedImage, file, n3);
                graphics2D.dispose();
                return file;
            }
        };
        Lazy<String> lazy2 = new Lazy<String>(){

            @Override
            public String getNow() throws IOException {
                UGraphicSvg uGraphicSvg = new UGraphicSvg(CucaDiagramFileMaker.this.getSkinParam().getColorMapper(), true);
                component.drawU(uGraphicSvg, new Dimension(n, n2), new SimpleContext2D(false));
                return CucaDiagramFileMaker.getSvg(uGraphicSvg);
            }
        };
        Lazy<File> lazy3 = new Lazy<File>(){

            @Override
            public File getNow() throws IOException {
                File file = FileUtils.createTempFile("plantumlB", ".eps");
                PrintWriter printWriter = new PrintWriter(file);
                UGraphicEps uGraphicEps = new UGraphicEps(CucaDiagramFileMaker.this.getSkinParam().getColorMapper(), CucaDiagramFileMaker.this.getEpsStrategy(fileFormatOption.getFileFormat()));
                component.drawU(uGraphicEps, new Dimension(n, n2), new SimpleContext2D(false));
                printWriter.print(uGraphicEps.getEPSCode());
                printWriter.close();
                return file;
            }
        };
        return DrawFile.create(lazy, lazy2, lazy3, null);
    }

    public static String getSvg(UGraphicSvg uGraphicSvg) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        uGraphicSvg.createXml(byteArrayOutputStream);
        byteArrayOutputStream.close();
        String string = new String(byteArrayOutputStream.toByteArray(), "UTF-8");
        Pattern pattern = Pattern.compile("(?i)<g\\W.*</g>");
        Matcher matcher = pattern.matcher(string);
        matcher.find();
        return matcher.group(0);
    }

    private DrawFile createImageForActivity(Entity entity) throws IOException {
        return null;
    }

    private DrawFile createImageForCircleInterface(Entity entity, final double d) throws IOException {
        String string = entity.getStereotype() == null ? null : entity.getStereotype().getLabel();
        HtmlColor htmlColor = this.rose.getHtmlColor(this.getSkinParam(), ColorParam.componentInterfaceBackground, string);
        HtmlColor htmlColor2 = this.rose.getHtmlColor(this.getSkinParam(), ColorParam.componentInterfaceBorder, string);
        final HtmlColor htmlColor3 = this.rose.getHtmlColor(this.getSkinParam(), ColorParam.background, string);
        final CircleInterface circleInterface = new CircleInterface(htmlColor, htmlColor2);
        Lazy<File> lazy = new Lazy<File>(){

            @Override
            public File getNow() throws IOException {
                EmptyImageBuilder emptyImageBuilder = new EmptyImageBuilder(circleInterface.getPreferredWidth(null) * d, circleInterface.getPreferredHeight(null) * d, CucaDiagramFileMaker.this.diagram.getColorMapper().getMappedColor(htmlColor3));
                BufferedImage bufferedImage = emptyImageBuilder.getBufferedImage();
                Graphics2D graphics2D = emptyImageBuilder.getGraphics2D();
                circleInterface.drawU(new UGraphicG2d(CucaDiagramFileMaker.this.diagram.getColorMapper(), graphics2D, null, 1.0));
                File file = FileUtils.createTempFile("circleinterface", ".png");
                ImageIO.write((RenderedImage)bufferedImage, "png", file);
                return file;
            }
        };
        Lazy<File> lazy2 = new Lazy<File>(){

            @Override
            public File getNow() throws IOException {
                File file = FileUtils.createTempFile("circleinterface", ".eps");
                UGraphicEps.copyEpsToFile(CucaDiagramFileMaker.this.getSkinParam().getColorMapper(), circleInterface, file);
                return file;
            }
        };
        Lazy<String> lazy3 = new Lazy<String>(){

            @Override
            public String getNow() throws IOException {
                return UGraphicG2d.getSvgString(CucaDiagramFileMaker.this.getSkinParam().getColorMapper(), circleInterface);
            }
        };
        List<Object> list = Arrays.asList("circleinterface", htmlColor, htmlColor2, htmlColor3, d);
        return DrawFile.create(lazy, lazy3, lazy2, list);
    }

    private DrawFile createImageForActor(Entity entity, final double d) throws IOException {
        String string = entity.getStereotype() == null ? null : entity.getStereotype().getLabel();
        HtmlColor htmlColor = this.rose.getHtmlColor(this.getSkinParam(), ColorParam.usecaseActorBackground, string);
        HtmlColor htmlColor2 = this.rose.getHtmlColor(this.getSkinParam(), ColorParam.usecaseActorBorder, string);
        final HtmlColor htmlColor3 = this.rose.getHtmlColor(this.getSkinParam(), ColorParam.background, string);
        final StickMan stickMan = new StickMan(htmlColor, htmlColor2);
        Lazy<File> lazy = new Lazy<File>(){

            @Override
            public File getNow() throws IOException {
                EmptyImageBuilder emptyImageBuilder = new EmptyImageBuilder(stickMan.getPreferredWidth(null) * d, stickMan.getPreferredHeight(null) * d, CucaDiagramFileMaker.this.diagram.getColorMapper().getMappedColor(htmlColor3));
                BufferedImage bufferedImage = emptyImageBuilder.getBufferedImage();
                Graphics2D graphics2D = emptyImageBuilder.getGraphics2D();
                stickMan.drawU(new UGraphicG2d(CucaDiagramFileMaker.this.diagram.getColorMapper(), graphics2D, null, d));
                File file = FileUtils.createTempFile("actor", ".png");
                ImageIO.write((RenderedImage)bufferedImage, "png", file);
                return file;
            }
        };
        Lazy<File> lazy2 = new Lazy<File>(){

            @Override
            public File getNow() throws IOException {
                File file = FileUtils.createTempFile("actor", ".eps");
                UGraphicEps.copyEpsToFile(CucaDiagramFileMaker.this.getSkinParam().getColorMapper(), stickMan, file);
                return file;
            }
        };
        Lazy<String> lazy3 = new Lazy<String>(){

            @Override
            public String getNow() throws IOException {
                return UGraphicG2d.getSvgString(CucaDiagramFileMaker.this.getSkinParam().getColorMapper(), stickMan);
            }
        };
        List<Object> list = Arrays.asList("actor", htmlColor, htmlColor2, htmlColor3, d);
        return DrawFile.create(lazy, lazy3, lazy2, list);
    }

    private DrawFile createImageForCircleCharacter(Entity entity, double d) throws IOException {
        Stereotype stereotype = entity.getStereotype();
        if (stereotype == null || stereotype.getHtmlColor() == null) {
            return null;
        }
        String string = stereotype.getLabel();
        HtmlColor htmlColor = this.rose.getHtmlColor(this.getSkinParam(), ColorParam.classBorder, string);
        HtmlColor htmlColor2 = this.rose.getHtmlColor(this.getSkinParam(), ColorParam.classBackground, string);
        UFont uFont = this.diagram.getSkinParam().getFont(FontParam.CIRCLED_CHARACTER, string);
        CircledCharacter circledCharacter = new CircledCharacter(stereotype.getCharacter(), this.getSkinParam().getCircledCharacterRadius(), uFont, stereotype.getHtmlColor(), htmlColor, HtmlColor.BLACK);
        return circledCharacter.generateCircleCharacter(this.diagram.getColorMapper(), htmlColor2, d);
    }

    private ISkinParam getSkinParam() {
        return this.diagram.getSkinParam();
    }

    private EpsStrategy getEpsStrategy(FileFormat fileFormat) {
        if (fileFormat == FileFormat.EPS_TEXT) {
            return EpsStrategy.WITH_MACRO_AND_TEXT;
        }
        return EpsStrategy.getDefault2();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createEps(OutputStream outputStream, List<String> list, FileFormatOption fileFormatOption) throws IOException, InterruptedException {
        try {
            this.deltaY = 0.0;
            GraphvizMaker graphvizMaker = this.populateImagesAndCreateGraphvizMaker(list, fileFormatOption);
            String string = graphvizMaker.createDotString();
            if (OptionFlags.getInstance().isKeepTmpFiles()) {
                CucaDiagramFileMaker.traceDotString(string);
            }
            Graphviz graphviz = GraphvizUtils.create(string, "eps");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            graphviz.createPng(byteArrayOutputStream);
            byteArrayOutputStream.close();
            graphvizMaker.clean();
            boolean bl = graphvizMaker.isUnderline();
            String string2 = new String(byteArrayOutputStream.toByteArray(), "UTF-8");
            string2 = CucaDiagramFileMaker.cleanStrangeCharacter(string2);
            if (bl) {
                string2 = new UnderlineTrickEps(string2).getString();
            }
            if (this.diagram.getTitle() != null) {
                string2 = this.addTitleEps(this.getEpsStrategy(fileFormatOption.getFileFormat()), string2);
            }
            if (this.diagram.getFooter() != null) {
                string2 = this.addFooterEps(this.getEpsStrategy(fileFormatOption.getFileFormat()), string2);
            }
            if (this.diagram.getHeader() != null) {
                string2 = this.addHeaderEps(this.getEpsStrategy(fileFormatOption.getFileFormat()), string2);
            }
            outputStream.write(string2.getBytes("UTF-8"));
        }
        finally {
            this.clean();
        }
        return null;
    }

    private void clean() throws IOException {
        if (!OptionFlags.getInstance().isKeepTmpFiles()) {
            this.diagram.clean();
            if (this.staticFilesMap != null) {
                this.staticFilesMap.clean();
            }
        }
    }

    private GraphvizMaker populateImagesAndCreateGraphvizMaker(List<String> list, FileFormatOption fileFormatOption) throws IOException, InterruptedException {
        this.populateImages(fileFormatOption);
        this.populateImagesLink(fileFormatOption);
        GraphvizMaker graphvizMaker = this.createDotMaker(list, fileFormatOption);
        return graphvizMaker;
    }

    private GraphvizMaker createDotMaker(List<String> list, FileFormatOption fileFormatOption) throws IOException, InterruptedException {
        FileFormat fileFormat = fileFormatOption.getFileFormat();
        if (this.diagram.getUmlDiagramType() == UmlDiagramType.STATE || this.diagram.getUmlDiagramType() == UmlDiagramType.ACTIVITY) {
            new CucaDiagramSimplifier(this.diagram, list, fileFormat);
        }
        DotData dotData = new DotData(null, this.diagram.getLinks(), this.diagram.entities(), this.diagram.getUmlDiagramType(), this.diagram.getSkinParam(), this.diagram.getRankdir(), this.diagram, this.diagram, this.diagram.getColorMapper());
        dotData.setDpi(this.diagram.getDpi(fileFormatOption));
        if (this.diagram.getUmlDiagramType() == UmlDiagramType.CLASS || this.diagram.getUmlDiagramType() == UmlDiagramType.OBJECT) {
            dotData.setStaticImagesMap(this.staticFilesMap);
            if (this.diagram.isVisibilityModifierPresent()) {
                dotData.setVisibilityModifierPresent(true);
            }
        }
        if (this.diagram.getUmlDiagramType() == UmlDiagramType.STATE) {
            dotData.setHideEmptyDescription(((StateDiagram)this.diagram).isHideEmptyDescription());
        }
        return this.diagram.getSkinParam().getStrategy().getGraphvizMaker(dotData, list, fileFormat);
    }

    private void populateImages(FileFormatOption fileFormatOption) throws IOException {
        for (Entity entity : this.diagram.entities().values()) {
            DrawFile drawFile = this.createImage(entity, fileFormatOption);
            if (drawFile == null) continue;
            entity.setImageFile(drawFile);
        }
    }

    private void populateImagesLink(FileFormatOption fileFormatOption) throws IOException {
        for (Link link : this.diagram.getLinks()) {
            DrawFile drawFile;
            String string = link.getNote();
            if (string == null || (drawFile = this.createImageForNote(string, null, fileFormatOption, null)) == null) continue;
            link.setImageFile(drawFile);
        }
    }

    static String cleanStrangeCharacter(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("%plantuml done")) {
                stringBuilder.append(string2);
                stringBuilder.append("\n");
                string2 = stringTokenizer.nextToken();
                if (!string2.equalsIgnoreCase("grestore") && !(string2 = stringTokenizer.nextToken()).equalsIgnoreCase("grestore")) {
                    throw new IllegalStateException();
                }
            }
            stringBuilder.append(string2);
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    static {
        EmptyImageBuilder emptyImageBuilder = new EmptyImageBuilder(10, 10, Color.WHITE);
        stringBounder = StringBounderUtils.asStringBounder(emptyImageBuilder.getGraphics2D());
    }
}

