/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.awt.geom.Dimension2D;
import java.util.Arrays;
import net.sourceforge.plantuml.UniqueSequence;
import net.sourceforge.plantuml.cucadiagram.Entity;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.cucadiagram.Group;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Imaged;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.cucadiagram.dot.DrawFile;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.ugraphic.UFont;

public class Link
implements Imaged {
    private final IEntity cl1;
    private final IEntity cl2;
    private final LinkType type;
    private final String label;
    private int length;
    private final String qualifier1;
    private final String qualifier2;
    private final String uid = "LNK" + UniqueSequence.getValue();
    private DrawFile imageFile;
    private String note;
    private boolean invis = false;
    private double weight = 1.0;
    private final String labeldistance;
    private final String labelangle;
    private HtmlColor specificColor;
    private boolean constraint = true;
    private boolean inverted = false;

    public final boolean isInverted() {
        return this.inverted;
    }

    public Link(IEntity iEntity, IEntity iEntity2, LinkType linkType, String string, int n) {
        this(iEntity, iEntity2, linkType, string, n, null, null, null, null, null);
    }

    public Link(IEntity iEntity, IEntity iEntity2, LinkType linkType, String string, int n, String string2, String string3, String string4, String string5) {
        this(iEntity, iEntity2, linkType, string, n, string2, string3, string4, string5, null);
    }

    public Link(IEntity iEntity, IEntity iEntity2, LinkType linkType, String string, int n, String string2, String string3, String string4, String string5, HtmlColor htmlColor) {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        if (iEntity == null || iEntity2 == null) {
            throw new IllegalArgumentException();
        }
        this.cl1 = iEntity;
        this.cl2 = iEntity2;
        this.type = linkType;
        this.label = string;
        this.length = n;
        this.qualifier1 = string2;
        this.qualifier2 = string3;
        this.labeldistance = string4;
        this.labelangle = string5;
        this.specificColor = htmlColor;
        if (string2 != null) {
            iEntity.setNearDecoration(true);
        }
        if (string3 != null) {
            iEntity2.setNearDecoration(true);
        }
    }

    public Link getInv() {
        Link link = new Link(this.cl2, this.cl1, this.type.getInv(), this.label, this.length, this.qualifier2, this.qualifier1, this.labeldistance, this.labelangle, this.specificColor);
        link.inverted = true;
        return link;
    }

    public Link getDashed() {
        return new Link(this.cl1, this.cl2, this.type.getDashed(), this.label, this.length, this.qualifier1, this.qualifier2, this.labeldistance, this.labelangle, this.specificColor);
    }

    public Link getDotted() {
        return new Link(this.cl1, this.cl2, this.type.getDotted(), this.label, this.length, this.qualifier1, this.qualifier2, this.labeldistance, this.labelangle, this.specificColor);
    }

    public Link getBold() {
        return new Link(this.cl1, this.cl2, this.type.getBold(), this.label, this.length, this.qualifier1, this.qualifier2, this.labeldistance, this.labelangle, this.specificColor);
    }

    public String getLabeldistance() {
        return this.labeldistance;
    }

    public String getLabelangle() {
        return this.labelangle;
    }

    public String getUid() {
        return this.uid;
    }

    public final boolean isInvis() {
        return this.invis;
    }

    public final void setInvis(boolean bl) {
        this.invis = bl;
    }

    private static IEntity muteProxy(IEntity iEntity, Group group, IEntity iEntity2) {
        if (iEntity.getParent() == group) {
            return iEntity2;
        }
        return iEntity;
    }

    public Link mute(Group group, Entity entity) {
        if (this.cl1.getParent() == group && this.cl1.getType() != EntityType.GROUP && this.cl2.getParent() == group && this.cl2.getType() != EntityType.GROUP) {
            return null;
        }
        IEntity iEntity = Link.muteProxy(this.cl1, group, entity);
        IEntity iEntity2 = Link.muteProxy(this.cl2, group, entity);
        if (this.cl1 == iEntity && this.cl2 == iEntity2) {
            return this;
        }
        return new Link(iEntity, iEntity2, this.type, this.label, this.length, this.qualifier1, this.qualifier2, this.labeldistance, this.labelangle);
    }

    public boolean isBetween(IEntity iEntity, IEntity iEntity2) {
        if (iEntity.equals(this.cl1) && iEntity2.equals(this.cl2)) {
            return true;
        }
        return iEntity.equals(this.cl2) && iEntity2.equals(this.cl1);
    }

    public String toString() {
        return super.toString() + " " + this.cl1 + "-->" + this.cl2;
    }

    public IEntity getEntity1() {
        return this.cl1;
    }

    public IEntity getEntity2() {
        return this.cl2;
    }

    public LinkType getType() {
        return this.type;
    }

    public String getLabel() {
        return this.label;
    }

    public int getLength() {
        return this.length;
    }

    public final void setLength(int n) {
        this.length = n;
    }

    public String getQualifier1() {
        return this.qualifier1;
    }

    public String getQualifier2() {
        return this.qualifier2;
    }

    public final double getWeight() {
        return this.weight;
    }

    public final void setWeight(double d) {
        this.weight = d;
    }

    public final String getNote() {
        return this.note;
    }

    public final void setNote(String string) {
        this.note = string;
    }

    public DrawFile getImageFile() {
        return this.imageFile;
    }

    public void setImageFile(DrawFile drawFile) {
        this.imageFile = drawFile;
    }

    public boolean isAutolink(Group group) {
        return this.getEntity1() == group.getEntityCluster() && this.getEntity2() == group.getEntityCluster();
    }

    public boolean isToEdgeLink(Group group) {
        if (this.getEntity1().getParent() != group || this.getEntity2().getParent() != group) {
            return false;
        }
        assert (this.getEntity1().getParent() == group && this.getEntity2().getParent() == group);
        if (this.isAutolink(group)) {
            return false;
        }
        if (this.getEntity2().getType() == EntityType.GROUP) {
            assert (this.getEntity1().getType() != EntityType.GROUP);
            return true;
        }
        return false;
    }

    public boolean isFromEdgeLink(Group group) {
        if (this.getEntity1().getParent() != group || this.getEntity2().getParent() != group) {
            return false;
        }
        assert (this.getEntity1().getParent() == group && this.getEntity2().getParent() == group);
        if (this.isAutolink(group)) {
            return false;
        }
        if (this.getEntity1().getType() == EntityType.GROUP) {
            assert (this.getEntity2().getType() != EntityType.GROUP);
            return true;
        }
        return false;
    }

    public boolean containsType(EntityType entityType) {
        return this.getEntity1().getType() == entityType || this.getEntity2().getType() == entityType;
    }

    public boolean contains(IEntity iEntity) {
        return this.getEntity1() == iEntity || this.getEntity2() == iEntity;
    }

    public double getMarginDecors1(StringBounder stringBounder, UFont uFont) {
        double d = this.getQualifierMargin(stringBounder, uFont, this.qualifier1);
        LinkDecor linkDecor = this.type.getDecor1();
        return (double)linkDecor.getSize() + d;
    }

    public double getMarginDecors2(StringBounder stringBounder, UFont uFont) {
        double d = this.getQualifierMargin(stringBounder, uFont, this.qualifier2);
        LinkDecor linkDecor = this.type.getDecor2();
        return (double)linkDecor.getSize() + d;
    }

    private double getQualifierMargin(StringBounder stringBounder, UFont uFont, String string) {
        if (string != null) {
            TextBlock textBlock = TextBlockUtils.create(Arrays.asList(string), new FontConfiguration(uFont, HtmlColor.BLACK), HorizontalAlignement.LEFT);
            Dimension2D dimension2D = textBlock.calculateDimension(stringBounder);
            return Math.max(dimension2D.getWidth(), dimension2D.getHeight());
        }
        return 0.0;
    }

    public HtmlColor getSpecificColor() {
        return this.specificColor;
    }

    public void setSpecificColor(String string) {
        this.specificColor = HtmlColor.getColorIfValid(string);
    }

    public final boolean isConstraint() {
        return this.constraint;
    }

    public final void setConstraint(boolean bl) {
        this.constraint = bl;
    }
}

