/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.PSystem;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandControl;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexPartialMatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SingleLineCommand2<S extends PSystem>
implements Command {
    private final S system;
    private final RegexConcat pattern;

    public SingleLineCommand2(S s, RegexConcat regexConcat) {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        if (regexConcat == null) {
            throw new IllegalArgumentException();
        }
        if (!regexConcat.getPattern().startsWith("^") || !regexConcat.getPattern().endsWith("$")) {
            throw new IllegalArgumentException("Bad pattern " + regexConcat.getPattern());
        }
        this.system = s;
        this.pattern = regexConcat;
    }

    protected final S getSystem() {
        return this.system;
    }

    @Override
    public String[] getDescription() {
        return new String[]{this.pattern.getPattern()};
    }

    @Override
    public final CommandControl isValid(List<String> list) {
        if (list.size() != 1) {
            return CommandControl.NOT_OK;
        }
        if (this.isCommandForbidden()) {
            return CommandControl.NOT_OK;
        }
        String string = list.get(0).trim();
        boolean bl = this.pattern.match(string);
        if (bl) {
            this.actionIfCommandValid();
        }
        return bl ? CommandControl.OK : CommandControl.NOT_OK;
    }

    protected boolean isCommandForbidden() {
        return false;
    }

    protected void actionIfCommandValid() {
    }

    @Override
    public final CommandExecutionResult execute(List<String> list) {
        if (list.size() != 1) {
            throw new IllegalArgumentException();
        }
        String string = list.get(0).trim();
        if (this.isForbidden(string)) {
            return CommandExecutionResult.error("Forbidden line " + string);
        }
        Map<String, RegexPartialMatch> map = this.pattern.matcher(string);
        if (map == null) {
            return CommandExecutionResult.error("Cannot parse line " + string);
        }
        return this.executeArg(map);
    }

    protected boolean isForbidden(String string) {
        return false;
    }

    protected abstract CommandExecutionResult executeArg(Map<String, RegexPartialMatch> var1);

    @Override
    public final boolean isDeprecated(List<String> list) {
        if (list.size() != 1) {
            return false;
        }
        return this.isDeprecated(list.get(0));
    }

    @Override
    public String getHelpMessageForDeprecated(List<String> list) {
        return null;
    }

    protected boolean isDeprecated(String string) {
        return false;
    }
}

