/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilinesBracket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandSkinParamMultilines
extends CommandMultilinesBracket<UmlDiagram> {
    private static final Pattern p1 = Pattern.compile("^([\\w.]*(?:\\<\\<.*\\>\\>)?[\\w.]*)\\s+(?:(\\{)|(.*))$|^\\}?$");

    public CommandSkinParamMultilines(UmlDiagram umlDiagram) {
        super(umlDiagram, "(?i)^skinparam\\s*(?:\\s+([\\w.]*(?:\\<\\<.*\\>\\>)?[\\w.]*))?\\s*\\{$");
    }

    @Override
    protected boolean isLineConsistent(String string, int n) {
        string = string.trim();
        return p1.matcher(string).matches();
    }

    @Override
    public CommandExecutionResult execute(List<String> list) {
        Context context = new Context();
        Matcher matcher = this.getStartingPattern().matcher(list.get(0).trim());
        if (!matcher.find()) {
            throw new IllegalStateException();
        }
        if (matcher.group(1) != null) {
            context.push(matcher.group(1));
        }
        list = new ArrayList<String>(list.subList(1, list.size() - 1));
        StringUtils.trim(list, true);
        for (String string : list) {
            assert (string.length() > 0);
            if (string.equals("}")) {
                context.pop();
                continue;
            }
            Matcher matcher2 = p1.matcher(string);
            if (!matcher2.find()) {
                throw new IllegalStateException();
            }
            if (matcher2.group(2) != null) {
                context.push(matcher2.group(1));
                continue;
            }
            if (matcher2.group(3) != null) {
                String string2 = context.getFullParam() + matcher2.group(1);
                ((UmlDiagram)this.getSystem()).setParam(string2, matcher2.group(3));
                continue;
            }
            throw new IllegalStateException();
        }
        return CommandExecutionResult.ok();
    }

    static class Context {
        private List<String> strings = new ArrayList<String>();

        Context() {
        }

        public void push(String string) {
            this.strings.add(string);
        }

        public void pop() {
            this.strings.remove(this.strings.size() - 1);
        }

        public String getFullParam() {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : this.strings) {
                stringBuilder.append(string);
            }
            return stringBuilder.toString();
        }
    }
}

