/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.PSystem;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandControl;
import net.sourceforge.plantuml.command.regex.RegexConcat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommandMultilines2<S extends PSystem>
implements Command {
    private final S system;
    private final RegexConcat starting;
    private final Pattern ending;

    public CommandMultilines2(S s, RegexConcat regexConcat, String string) {
        if (!regexConcat.getPattern().startsWith("^") || !regexConcat.getPattern().endsWith("$")) {
            throw new IllegalArgumentException("Bad pattern " + regexConcat.getPattern());
        }
        if (!string.startsWith("(?i)^") || !string.endsWith("$")) {
            throw new IllegalArgumentException("Bad pattern " + string);
        }
        this.system = s;
        this.starting = regexConcat;
        this.ending = Pattern.compile(string);
    }

    @Override
    public String[] getDescription() {
        return new String[]{"START: " + this.starting.getPattern(), "END: " + this.ending.pattern()};
    }

    @Override
    public final CommandControl isValid(List<String> list) {
        if (this.isCommandForbidden()) {
            return CommandControl.NOT_OK;
        }
        boolean bl = this.starting.match(list.get(0).trim());
        if (!bl) {
            return CommandControl.NOT_OK;
        }
        if (list.size() == 1) {
            return CommandControl.OK_PARTIAL;
        }
        Matcher matcher = this.ending.matcher(list.get(list.size() - 1).trim());
        if (!matcher.matches()) {
            return CommandControl.OK_PARTIAL;
        }
        this.actionIfCommandValid();
        return CommandControl.OK;
    }

    protected boolean isCommandForbidden() {
        return false;
    }

    protected void actionIfCommandValid() {
    }

    protected S getSystem() {
        return this.system;
    }

    protected final RegexConcat getStartingPattern() {
        return this.starting;
    }

    protected final Pattern getEnding() {
        return this.ending;
    }

    @Override
    public boolean isDeprecated(List<String> list) {
        return false;
    }

    @Override
    public String getHelpMessageForDeprecated(List<String> list) {
        return null;
    }
}

