/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram.command;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.classdiagram.command.JavaClass;
import net.sourceforge.plantuml.cucadiagram.EntityType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JavaFile {
    private static final Pattern classDefinition = Pattern.compile("^(?:public\\s+|abstract\\s+|final\\s+)*(class|interface|enum)\\s+(\\w+)(?:.*\\b(extends|implements)\\s+([\\w\\s,]+))?");
    private static final Pattern packageDefinition = Pattern.compile("^package\\s+([\\w+.]+)\\s*;");
    private final List<JavaClass> all = new ArrayList<JavaClass>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaFile(File file) throws IOException {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            this.initFromReader(bufferedReader);
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
    }

    private void initFromReader(BufferedReader bufferedReader) throws IOException {
        String string;
        String string2 = null;
        while ((string = bufferedReader.readLine()) != null) {
            Matcher matcher = packageDefinition.matcher(string = string.trim());
            if (matcher.find()) {
                string2 = matcher.group(1);
                continue;
            }
            Matcher matcher2 = classDefinition.matcher(string);
            if (!matcher2.find()) continue;
            String string3 = matcher2.group(2);
            String string4 = matcher2.group(4);
            EntityType entityType = EntityType.valueOf(matcher2.group(1).toUpperCase());
            EntityType entityType2 = JavaFile.getParentType(entityType, matcher2.group(3));
            this.all.add(new JavaClass(string2, string3, string4, entityType, entityType2));
        }
    }

    static EntityType getParentType(EntityType entityType, String string) {
        if (string == null) {
            return null;
        }
        if (entityType == EntityType.CLASS) {
            if (string.equals("extends")) {
                return EntityType.CLASS;
            }
            return EntityType.INTERFACE;
        }
        return EntityType.INTERFACE;
    }

    public List<JavaClass> getJavaClasses() {
        return Collections.unmodifiableList(this.all);
    }
}

