/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram.command;

import java.util.Map;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.UniqueSequence;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexPartialMatch;
import net.sourceforge.plantuml.cucadiagram.Entity;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.objectdiagram.AbstractClassOrObjectDiagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CommandLinkLollipop2
extends SingleLineCommand2<AbstractClassOrObjectDiagram> {
    public CommandLinkLollipop2(AbstractClassOrObjectDiagram abstractClassOrObjectDiagram) {
        super(abstractClassOrObjectDiagram, CommandLinkLollipop2.getRegexConcat(abstractClassOrObjectDiagram.getUmlDiagramType()));
    }

    static RegexConcat getRegexConcat(UmlDiagramType umlDiagramType) {
        return new RegexConcat(new RegexLeaf("HEADER", "^(?:@([\\d.]+)\\s+)?"), new RegexLeaf("ENT1", "(?:" + CommandLinkLollipop2.optionalKeywords(umlDiagramType) + "\\s+)?" + "(\\.?[\\p{L}0-9_]+(?:\\.[\\p{L}0-9_]+)*|\"[^\"]+\")\\s*(\\<\\<.*\\>\\>)?"), new RegexLeaf("\\s*"), new RegexLeaf("FIRST_LABEL", "(?:\"([^\"]+)\")?"), new RegexLeaf("\\s*"), new RegexOr(new RegexLeaf("LOL_THEN_ENT", "\\(\\)([-=.]+)"), new RegexLeaf("ENT_THEN_LOL", "([-=.]+)\\(\\)")), new RegexLeaf("\\s*"), new RegexLeaf("SECOND_LABEL", "(?:\"([^\"]+)\")?"), new RegexLeaf("\\s*"), new RegexLeaf("ENT2", "(?:" + CommandLinkLollipop2.optionalKeywords(umlDiagramType) + "\\s+)?" + "(\\.?[\\p{L}0-9_]+(?:\\.[\\p{L}0-9_]+)*|\"[^\"]+\")\\s*(\\<\\<.*\\>\\>)?"), new RegexLeaf("\\s*"), new RegexOr(null, true, new RegexLeaf("LABEL_LINK", ":\\s*([^\"]+)"), new RegexLeaf("LABEL_LINK_XT", ":\\s*(\"[^\"]*\")?\\s*([^\"]*)\\s*(\"[^\"]*\")?")), new RegexLeaf("$"));
    }

    private static String optionalKeywords(UmlDiagramType umlDiagramType) {
        if (umlDiagramType == UmlDiagramType.CLASS) {
            return "(interface|enum|abstract\\s+class|abstract|class)";
        }
        if (umlDiagramType == UmlDiagramType.OBJECT) {
            return "(object)";
        }
        throw new IllegalArgumentException();
    }

    @Override
    protected CommandExecutionResult executeArg(Map<String, RegexPartialMatch> map) {
        Entity entity;
        Entity entity2;
        Entity entity3;
        String string = map.get("ENT1").get(1);
        String string2 = map.get("ENT2").get(1);
        String string3 = "lol" + UniqueSequence.getValue();
        if (map.get("LOL_THEN_ENT").get(0) != null) {
            entity3 = (Entity)((AbstractClassOrObjectDiagram)this.getSystem()).getOrCreateClass(string2);
            entity2 = ((AbstractClassOrObjectDiagram)this.getSystem()).createEntity(entity3.getCode() + string3, string, EntityType.LOLLIPOP);
            entity = entity3;
        } else {
            assert (map.get("ENT_THEN_LOL").get(0) != null);
            entity2 = (Entity)((AbstractClassOrObjectDiagram)this.getSystem()).getOrCreateClass(string);
            entity3 = ((AbstractClassOrObjectDiagram)this.getSystem()).createEntity(entity2.getCode() + string3, string2, EntityType.LOLLIPOP);
            entity = entity2;
        }
        LinkType linkType = this.getLinkType(map);
        String string4 = this.getQueue(map);
        int n = string4.length();
        if (n == 1 && ((AbstractClassOrObjectDiagram)this.getSystem()).getNbOfHozizontalLollipop(entity) > 1) {
            ++n;
        }
        String string5 = map.get("FIRST_LABEL").get(0);
        String string6 = map.get("SECOND_LABEL").get(0);
        String string7 = null;
        if (map.get("LABEL_LINK").get(0) != null) {
            string7 = map.get("LABEL_LINK").get(0);
        } else if (map.get("LABEL_LINK_XT").get(0) != null || map.get("LABEL_LINK_XT").get(1) != null || map.get("LABEL_LINK_XT").get(2) != null) {
            string7 = map.get("LABEL_LINK_XT").get(1);
            string5 = this.merge(string5, map.get("LABEL_LINK_XT").get(0));
            string6 = this.merge(map.get("LABEL_LINK_XT").get(2), string6);
        }
        Link link = new Link(entity2, entity3, linkType, string7, n, string5, string6, ((AbstractClassOrObjectDiagram)this.getSystem()).getLabeldistance(), ((AbstractClassOrObjectDiagram)this.getSystem()).getLabelangle());
        ((AbstractClassOrObjectDiagram)this.getSystem()).resetPragmaLabel();
        this.addLink(link, map.get("HEADER").get(0));
        return CommandExecutionResult.ok();
    }

    private String merge(String string, String string2) {
        if (string == null && string2 == null) {
            return null;
        }
        if (string == null && string2 != null) {
            return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string2);
        }
        if (string2 == null && string != null) {
            return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string);
        }
        return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string) + "\\n" + StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string2);
    }

    private void addLink(Link link, String string) {
        ((AbstractClassOrObjectDiagram)this.getSystem()).addLink(link);
        if (string == null) {
            LinkType linkType = link.getType();
        } else {
            link.setWeight(Double.parseDouble(string));
        }
    }

    private LinkType getLinkType(Map<String, RegexPartialMatch> map) {
        return new LinkType(LinkDecor.NONE, LinkDecor.NONE);
    }

    private String getQueue(Map<String, RegexPartialMatch> map) {
        if (map.get("LOL_THEN_ENT").get(0) != null) {
            return map.get("LOL_THEN_ENT").get(0).trim();
        }
        if (map.get("ENT_THEN_LOL").get(0) != null) {
            return map.get("ENT_THEN_LOL").get(0).trim();
        }
        throw new IllegalArgumentException();
    }
}

