/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.asciiart;

import java.util.List;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.asciiart.ComponentTextActiveLine;
import net.sourceforge.plantuml.asciiart.ComponentTextActor;
import net.sourceforge.plantuml.asciiart.ComponentTextArrow;
import net.sourceforge.plantuml.asciiart.ComponentTextDivider;
import net.sourceforge.plantuml.asciiart.ComponentTextGroupingBody;
import net.sourceforge.plantuml.asciiart.ComponentTextGroupingElse;
import net.sourceforge.plantuml.asciiart.ComponentTextGroupingHeader;
import net.sourceforge.plantuml.asciiart.ComponentTextGroupingTail;
import net.sourceforge.plantuml.asciiart.ComponentTextLine;
import net.sourceforge.plantuml.asciiart.ComponentTextNote;
import net.sourceforge.plantuml.asciiart.ComponentTextParticipant;
import net.sourceforge.plantuml.asciiart.ComponentTextSelfArrow;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Skin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextSkin
implements Skin {
    private final FileFormat fileFormat;

    public TextSkin(FileFormat fileFormat) {
        this.fileFormat = fileFormat;
    }

    @Override
    public Component createComponent(ComponentType componentType, ISkinParam iSkinParam, List<? extends CharSequence> list) {
        if (componentType == ComponentType.PARTICIPANT_HEAD || componentType == ComponentType.PARTICIPANT_TAIL) {
            return new ComponentTextParticipant(componentType, list, this.fileFormat);
        }
        if (componentType == ComponentType.ACTOR_HEAD || componentType == ComponentType.ACTOR_TAIL) {
            return new ComponentTextActor(componentType, list, this.fileFormat);
        }
        if (componentType.isArrow() && (componentType.getArrowConfiguration().isLeftToRightNormal() || componentType.getArrowConfiguration().isRightToLeftReverse())) {
            return new ComponentTextArrow(componentType, list, this.fileFormat);
        }
        if (componentType.isArrow() && componentType.getArrowConfiguration().isSelfArrow()) {
            return new ComponentTextSelfArrow(componentType, list, this.fileFormat);
        }
        if (componentType == ComponentType.PARTICIPANT_LINE) {
            return new ComponentTextLine(this.fileFormat);
        }
        if (componentType == ComponentType.CONTINUE_LINE) {
            return new ComponentTextLine(this.fileFormat);
        }
        if (componentType == ComponentType.DELAY_LINE) {
            return new ComponentTextLine(this.fileFormat);
        }
        if (componentType == ComponentType.ALIVE_BOX_CLOSE_CLOSE) {
            return new ComponentTextActiveLine(this.fileFormat);
        }
        if (componentType == ComponentType.ALIVE_BOX_CLOSE_OPEN) {
            return new ComponentTextActiveLine(this.fileFormat);
        }
        if (componentType == ComponentType.ALIVE_BOX_OPEN_CLOSE) {
            return new ComponentTextActiveLine(this.fileFormat);
        }
        if (componentType == ComponentType.ALIVE_BOX_OPEN_OPEN) {
            return new ComponentTextActiveLine(this.fileFormat);
        }
        if (componentType == ComponentType.NOTE) {
            return new ComponentTextNote(componentType, list, this.fileFormat);
        }
        if (componentType == ComponentType.DIVIDER) {
            return new ComponentTextDivider(componentType, list, this.fileFormat);
        }
        if (componentType == ComponentType.GROUPING_HEADER) {
            return new ComponentTextGroupingHeader(componentType, list, this.fileFormat);
        }
        if (componentType == ComponentType.GROUPING_BODY) {
            return new ComponentTextGroupingBody(componentType, list, this.fileFormat);
        }
        if (componentType == ComponentType.GROUPING_TAIL) {
            return new ComponentTextGroupingTail(componentType, list, this.fileFormat);
        }
        if (componentType == ComponentType.GROUPING_ELSE) {
            return new ComponentTextGroupingElse(componentType, list, this.fileFormat);
        }
        throw new UnsupportedOperationException(componentType.toString());
    }

    @Override
    public Object getProtocolVersion() {
        return 1;
    }
}

