/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram.command;

import java.util.Map;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.activitydiagram.ActivityDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexPartialMatch;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.HtmlColor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLinkActivity
extends SingleLineCommand2<ActivityDiagram> {
    public CommandLinkActivity(ActivityDiagram activityDiagram) {
        super(activityDiagram, CommandLinkActivity.getRegexConcat());
    }

    static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexOr("FIRST", true, new RegexLeaf("STAR", "(\\(\\*(top)?\\))"), new RegexLeaf("CODE", "([\\p{L}0-9_.]+)"), new RegexLeaf("BAR", "(?:==+)\\s*([\\p{L}0-9_.]+)\\s*(?:==+)"), new RegexLeaf("QUOTED", "\"([^\"]+)\"(?:\\s+as\\s+([\\p{L}0-9_.]+))?")), new RegexLeaf("\\s*"), new RegexLeaf("STEREOTYPE", "(\\<\\<.*\\>\\>)?"), new RegexLeaf("\\s*"), new RegexLeaf("BACKCOLOR", "(#\\w+)?"), new RegexLeaf("\\s*"), new RegexLeaf("ARROW", "([=-]+(?:\\*|left|right|up|down|le?|ri?|up?|do?)?[=-]*\\>)"), new RegexLeaf("\\s*"), new RegexLeaf("BRACKET", "(?:\\[([^\\]*]+[^\\]]*)\\])?"), new RegexLeaf("\\s*"), new RegexOr("FIRST2", new RegexLeaf("STAR2", "(\\(\\*(top)?\\))"), new RegexLeaf("OPENBRACKET2", "(\\{)"), new RegexLeaf("CODE2", "([\\p{L}0-9_.]+)"), new RegexLeaf("BAR2", "(?:==+)\\s*([\\p{L}0-9_.]+)\\s*(?:==+)"), new RegexLeaf("QUOTED2", "\"([^\"]+)\"(?:\\s+as\\s+([\\p{L}0-9_.]+))?")), new RegexLeaf("\\s*"), new RegexLeaf("STEREOTYPE2", "(\\<\\<.*\\>\\>)?"), new RegexLeaf("\\s*"), new RegexLeaf("BACKCOLOR2", "(#\\w+)?"), new RegexLeaf("$"));
    }

    @Override
    protected CommandExecutionResult executeArg(Map<String, RegexPartialMatch> map) {
        Direction direction;
        IEntity iEntity;
        IEntity iEntity2 = CommandLinkActivity.getEntity((ActivityDiagram)this.getSystem(), map, true);
        if (iEntity2 == null) {
            return CommandExecutionResult.error("No such activity");
        }
        if (map.get("STEREOTYPE").get(0) != null) {
            iEntity2.setStereotype(new Stereotype(map.get("STEREOTYPE").get(0)));
        }
        if (map.get("BACKCOLOR").get(0) != null) {
            iEntity2.setSpecificBackcolor(HtmlColor.getColorIfValid(map.get("BACKCOLOR").get(0)));
        }
        if ((iEntity = CommandLinkActivity.getEntity((ActivityDiagram)this.getSystem(), map, false)) == null) {
            return CommandExecutionResult.error("No such activity");
        }
        if (map.get("BACKCOLOR2").get(0) != null) {
            iEntity.setSpecificBackcolor(HtmlColor.getColorIfValid(map.get("BACKCOLOR2").get(0)));
        }
        if (map.get("STEREOTYPE2").get(0) != null) {
            iEntity.setStereotype(new Stereotype(map.get("STEREOTYPE2").get(0)));
        }
        String string = map.get("BRACKET").get(0);
        String string2 = StringUtils.manageArrowForCuca(map.get("ARROW").get(0));
        int n = string2.length() - 1;
        if (map.get("ARROW").get(0).contains("*")) {
            n = 2;
        }
        Link link = new Link(iEntity2, iEntity, new LinkType(LinkDecor.ARROW, LinkDecor.NONE), string, n);
        if (map.get("ARROW").get(0).contains("*")) {
            link.setConstraint(false);
        }
        if ((direction = StringUtils.getArrowDirection(map.get("ARROW").get(0))) == Direction.LEFT || direction == Direction.UP) {
            link = link.getInv();
        }
        ((ActivityDiagram)this.getSystem()).addLink(link);
        return CommandExecutionResult.ok();
    }

    static IEntity getEntity(ActivityDiagram activityDiagram, Map<String, RegexPartialMatch> map, boolean bl) {
        String string = bl ? "" : "2";
        RegexPartialMatch regexPartialMatch = map.get("OPENBRACKET" + string);
        if (regexPartialMatch != null && regexPartialMatch.get(0) != null) {
            return activityDiagram.createInnerActivity();
        }
        if (map.get("STAR" + string).get(0) != null) {
            if (bl) {
                if (map.get("STAR" + string).get(1) != null) {
                    activityDiagram.getStart().setTop(true);
                }
                return activityDiagram.getStart();
            }
            return activityDiagram.getEnd();
        }
        String string2 = map.get("CODE" + string).get(0);
        if (string2 != null) {
            return activityDiagram.getOrCreate(string2, string2, CommandLinkActivity.getTypeIfExisting(activityDiagram, string2));
        }
        String string3 = map.get("BAR" + string).get(0);
        if (string3 != null) {
            return activityDiagram.getOrCreate(string3, string3, EntityType.SYNCHRO_BAR);
        }
        RegexPartialMatch regexPartialMatch2 = map.get("QUOTED" + string);
        if (regexPartialMatch2.get(0) != null) {
            String string4 = regexPartialMatch2.get(1) == null ? regexPartialMatch2.get(0) : regexPartialMatch2.get(1);
            return activityDiagram.getOrCreate(string4, regexPartialMatch2.get(0), CommandLinkActivity.getTypeIfExisting(activityDiagram, string4));
        }
        String string5 = map.get("FIRST" + string).get(0);
        if (string5 == null) {
            return activityDiagram.getLastEntityConsulted();
        }
        throw new UnsupportedOperationException();
    }

    static EntityType getTypeIfExisting(ActivityDiagram activityDiagram, String string) {
        IEntity iEntity;
        if (activityDiagram.entityExist(string) && (iEntity = (IEntity)activityDiagram.entities().get(string)).getType() == EntityType.BRANCH) {
            return EntityType.BRANCH;
        }
        return EntityType.ACTIVITY;
    }

    static EntityType getTypeFromString(String string, EntityType entityType) {
        if (string == null) {
            return EntityType.ACTIVITY;
        }
        if (string.equals("*")) {
            return entityType;
        }
        if (string.startsWith("=")) {
            return EntityType.SYNCHRO_BAR;
        }
        throw new IllegalArgumentException();
    }
}

