/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FileFormat {
    PNG,
    SVG,
    EPS,
    EPS_TEXT,
    ATXT,
    UTXT,
    DOT,
    XMI_STANDARD,
    XMI_STAR,
    XMI_ARGO,
    PDF;


    public String getFileSuffix() {
        if (this.name().startsWith("XMI")) {
            return ".XMI";
        }
        if (this == EPS_TEXT) {
            return EPS.getFileSuffix();
        }
        return "." + this.name().toLowerCase();
    }

    public boolean isEps() {
        if (this == EPS) {
            return true;
        }
        return this == EPS_TEXT;
    }

    public String changeName(String string, int n) {
        if (n == 0) {
            return string.replaceAll("\\.\\w+$", this.getFileSuffix());
        }
        return string.replaceAll("\\.\\w+$", "_" + String.format("%03d", n) + this.getFileSuffix());
    }
}

