/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.function.user;

import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprTransform;
import com.hp.hpl.jena.sparql.expr.ExprTransformer;
import com.hp.hpl.jena.sparql.function.Function;
import com.hp.hpl.jena.sparql.function.FunctionFactory;
import com.hp.hpl.jena.sparql.function.FunctionRegistry;
import com.hp.hpl.jena.sparql.function.user.ExprTransformExpand;
import com.hp.hpl.jena.sparql.function.user.UserDefinedFunctionDefinition;
import com.hp.hpl.jena.sparql.lang.sparql_11.ParseException;
import com.hp.hpl.jena.sparql.lang.sparql_11.SPARQLParser11;
import com.hp.hpl.jena.sparql.sse.builders.ExprBuildException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class UserDefinedFunctionFactory
implements FunctionFactory {
    private static UserDefinedFunctionFactory factory = new UserDefinedFunctionFactory();
    private Map<String, UserDefinedFunctionDefinition> definitions = new HashMap<String, UserDefinedFunctionDefinition>();
    private boolean preserveDependencies = false;

    public static UserDefinedFunctionFactory getFactory() {
        return factory;
    }

    private UserDefinedFunctionFactory() {
    }

    public boolean getPreserveDependencies() {
        return this.preserveDependencies;
    }

    public void setPreserveDependencies(boolean allow) {
        this.preserveDependencies = allow;
    }

    @Override
    public Function create(String uri) {
        UserDefinedFunctionDefinition def = this.definitions.get(uri);
        if (def == null) {
            throw new ExprBuildException("Function <" + uri + "> not known by this function factory");
        }
        return def.newFunctionInstance();
    }

    public void add(String uri, Expr e2, List<Var> args) {
        if (!this.preserveDependencies) {
            e2 = ExprTransformer.transform((ExprTransform)new ExprTransformExpand(this.definitions), e2);
        }
        UserDefinedFunctionDefinition def = new UserDefinedFunctionDefinition(uri, e2, args);
        this.definitions.put(uri, def);
        FunctionRegistry.get().put(uri, this);
    }

    public void add(String uri, String expr, List<Var> args) throws ParseException {
        Expr e2 = new SPARQLParser11(new StringReader(expr)).Expression();
        if (!this.preserveDependencies) {
            e2 = ExprTransformer.transform((ExprTransform)new ExprTransformExpand(this.definitions), e2);
        }
        UserDefinedFunctionDefinition def = new UserDefinedFunctionDefinition(uri, e2, args);
        this.definitions.put(uri, def);
        FunctionRegistry.get().put(uri, this);
    }

    public void remove(String uri) {
        if (!this.definitions.containsKey(uri)) {
            throw new NoSuchElementException("No function definition is associated with the URI <" + uri + ">");
        }
        this.definitions.remove(uri);
        FunctionRegistry.get().remove(uri);
    }

    public UserDefinedFunctionDefinition get(String uri) {
        if (!this.definitions.containsKey(uri)) {
            return null;
        }
        return this.definitions.get(uri);
    }

    public boolean isRegistered(String uri) {
        return this.definitions.containsKey(uri);
    }

    public void clear() {
        for (String uri : this.definitions.keySet()) {
            FunctionRegistry.get().remove(uri);
        }
        this.definitions.clear();
    }
}

