/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util;

import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.util.Utils;
import org.apache.jena.atlas.logging.Log;

public class Loader {
    public static Class<?> loadClass(String classNameOrURI) {
        return Loader.loadClass(classNameOrURI, null);
    }

    public static Class<?> loadClass(String classNameOrURI, Class<?> requiredClass) {
        if (classNameOrURI == null) {
            throw new ARQInternalErrorException("Null classNameorIRI");
        }
        if (classNameOrURI.startsWith("http:")) {
            return null;
        }
        if (classNameOrURI.startsWith("urn:")) {
            return null;
        }
        String className = classNameOrURI;
        if (classNameOrURI.startsWith("java:")) {
            className = classNameOrURI.substring("java:".length());
        }
        Class<?> classObj = null;
        try {
            classObj = Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            Log.warn(Loader.class, "Class not found: " + className);
            return null;
        }
        if (requiredClass != null && !requiredClass.isAssignableFrom(classObj)) {
            Log.warn(Loader.class, "Class '" + className + "' found but not a " + Utils.classShortName(requiredClass));
            return null;
        }
        return classObj;
    }

    public static Object loadAndInstantiate(String uri, Class<?> requiredClass) {
        Class<?> classObj = Loader.loadClass(uri, requiredClass);
        if (classObj == null) {
            return null;
        }
        Object module = null;
        try {
            module = classObj.newInstance();
        }
        catch (Exception ex) {
            String className = uri.substring("java:".length());
            Log.warn(Loader.class, "Exception during instantiation '" + className + "': " + ex.getMessage());
            return null;
        }
        return module;
    }
}

