/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.transformer.impl;

import gov.loc.repository.bagit.Bag;
import gov.loc.repository.bagit.BagFactory;
import gov.loc.repository.bagit.Manifest;
import gov.loc.repository.bagit.ManifestHelper;
import gov.loc.repository.bagit.transformer.Completer;
import gov.loc.repository.bagit.transformer.impl.CompleterHelper;
import java.util.List;

public class TagManifestCompleter
implements Completer {
    private CompleterHelper helper;
    private BagFactory bagFactory;
    private Manifest.Algorithm tagManifestAlgorithm = Manifest.Algorithm.MD5;
    private String nonDefaultManifestSeparator = null;
    private List<String> limitUpdateFilepaths = null;
    private List<String> limitDeleteFilepaths = null;
    private List<String> limitAddFilepaths = null;
    private List<String> limitUpdateDirectories = null;
    private List<String> limitDeleteDirectories = null;
    private List<String> limitAddDirectories = null;

    public TagManifestCompleter(BagFactory bagFactory) {
        this.bagFactory = bagFactory;
        this.helper = new CompleterHelper();
    }

    public void setTagManifestAlgorithm(Manifest.Algorithm tagManifestAlgorithm) {
        this.tagManifestAlgorithm = tagManifestAlgorithm;
    }

    public void setLimitUpdateTagFilepaths(List<String> limitUpdateFiles) {
        this.limitUpdateFilepaths = limitUpdateFiles;
    }

    public void setLimitDeleteTagFilepaths(List<String> limitDeleteFiles) {
        this.limitDeleteFilepaths = limitDeleteFiles;
    }

    public void setLimitAddTagFilepaths(List<String> limitAddFiles) {
        this.limitAddFilepaths = limitAddFiles;
    }

    public void setLimitUpdateTagDirectories(List<String> limitUpdateDirectories) {
        this.limitUpdateDirectories = limitUpdateDirectories;
    }

    public void setLimitDeleteTagDirectories(List<String> limitDeleteDirectories) {
        this.limitDeleteDirectories = limitDeleteDirectories;
    }

    public void setLimitAddTagDirectories(List<String> limitAddDirectories) {
        this.limitAddDirectories = limitAddDirectories;
    }

    @Override
    public Bag complete(Bag bag) {
        Bag newBag = this.bagFactory.createBag(bag);
        newBag.putBagFiles(bag.getPayload());
        newBag.putBagFiles(bag.getTags());
        this.helper.cleanManifests(newBag, newBag.getTagManifests(), this.limitDeleteFilepaths, this.limitDeleteDirectories);
        for (Manifest manifest : newBag.getTagManifests()) {
            this.helper.regenerateManifest(newBag, manifest, true, this.limitUpdateFilepaths, this.limitUpdateDirectories);
        }
        this.helper.handleManifest(newBag, this.tagManifestAlgorithm, ManifestHelper.getTagManifestFilename(this.tagManifestAlgorithm, newBag.getBagConstants()), newBag.getTags(), this.nonDefaultManifestSeparator, this.limitAddFilepaths, this.limitAddDirectories);
        return newBag;
    }

    public String getNonDefaultManifestSeparator() {
        return this.nonDefaultManifestSeparator;
    }

    public void setNonDefaultManifestSeparator(String manifestSeparator) {
        this.nonDefaultManifestSeparator = manifestSeparator;
    }
}

