/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.datamanager.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ecoinformatics.datamanager.download.AuthenticatedEcogridEndPointInterface;
import org.ecoinformatics.datamanager.download.EcogridEndPointInterface;
import org.ecoinformatics.ecogrid.authenticatedqueryservice.AuthenticatedQueryServiceGetToStreamClient;
import org.ecoinformatics.ecogrid.queryservice.QueryServiceGetToStreamClient;

public class DocumentDownloadUtil {
    public static Log log = LogFactory.getLog(DocumentDownloadUtil.class);
    private PipedInputStream inputStream = null;
    private PipedOutputStream outputStream = null;

    private void init() {
        this.outputStream = new PipedOutputStream();
        this.inputStream = new PipedInputStream();
        try {
            this.outputStream.connect(this.inputStream);
        }
        catch (IOException e1) {
            log.error((Object)("could not connect piped streams! " + e1.getMessage()));
            e1.printStackTrace();
        }
    }

    public InputStream downloadDocument(final String id, final EcogridEndPointInterface endpoint) throws Exception {
        this.init();
        log.debug((Object)"starting the download");
        ExecutorService service = Executors.newSingleThreadExecutor();
        service.execute(new Runnable(){

            @Override
            public void run() {
                long startTime = System.currentTimeMillis();
                try {
                    if (endpoint instanceof AuthenticatedEcogridEndPointInterface) {
                        AuthenticatedQueryServiceGetToStreamClient authenticatedEcogridClient = new AuthenticatedQueryServiceGetToStreamClient(new URL(((AuthenticatedEcogridEndPointInterface)endpoint).getMetacatAuthenticatedEcogridEndPoint()));
                        authenticatedEcogridClient.get(id, ((AuthenticatedEcogridEndPointInterface)endpoint).getSessionId(), (OutputStream)DocumentDownloadUtil.this.outputStream);
                    } else {
                        QueryServiceGetToStreamClient ecogridClient = new QueryServiceGetToStreamClient(new URL(endpoint.getMetacatEcogridEndPoint()));
                        ecogridClient.get(id, (OutputStream)DocumentDownloadUtil.this.outputStream);
                    }
                    DocumentDownloadUtil.this.outputStream.close();
                    long endTime = System.currentTimeMillis();
                    log.debug((Object)(endTime - startTime + " ms to download document data"));
                    log.debug((Object)("Done downloading id=" + id));
                }
                catch (Exception e) {
                    log.error((Object)("Error getting document from ecogrid: " + e.getMessage()));
                    e.printStackTrace();
                }
            }
        });
        service.shutdown();
        service.awaitTermination(0L, TimeUnit.SECONDS);
        log.debug((Object)"done with the download");
        return this.inputStream;
    }
}

