/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.datamanager.download.document;

import java.io.InputStream;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ecoinformatics.datamanager.database.DatabaseConnectionPoolInterface;
import org.ecoinformatics.datamanager.database.DatabaseHandler;
import org.ecoinformatics.datamanager.database.SimpleDatabaseLoader;
import org.ecoinformatics.datamanager.database.VectorReader;
import org.ecoinformatics.datamanager.download.EcogridEndPointInterface;
import org.ecoinformatics.datamanager.parser.DataPackage;
import org.ecoinformatics.datamanager.parser.Entity;
import org.ecoinformatics.datamanager.parser.document.DocumentDataPackage;
import org.ecoinformatics.datamanager.parser.document.DocumentDataPackageParser;
import org.ecoinformatics.datamanager.util.DocumentDownloadUtil;

public class DocumentDataPackageHandler {
    public static Log log = LogFactory.getLog(DocumentDataPackageHandler.class);
    private String docId = null;
    private EcogridEndPointInterface ecogridEndPointInterface = null;
    private Map attributeMap = null;
    private boolean loaded = false;
    private DatabaseConnectionPoolInterface connectionPool = null;
    private DatabaseHandler databaseHandler = null;
    private DocumentDataPackageParser ddpp = null;

    public DocumentDataPackageHandler(DatabaseConnectionPoolInterface pool) {
        try {
            this.connectionPool = pool;
            this.databaseHandler = new DatabaseHandler(this.connectionPool.getDBAdapterName());
        }
        catch (Exception e) {
            log.debug((Object)("could not create DatabaseHandler: " + e.getMessage()));
            e.printStackTrace();
        }
    }

    private void downloadDocument() throws Exception {
        DocumentDownloadUtil ddu = new DocumentDownloadUtil();
        InputStream inputStream = ddu.downloadDocument(this.docId, this.ecogridEndPointInterface);
        log.debug((Object)"done with the download");
        long startTime = System.currentTimeMillis();
        this.ddpp = new DocumentDataPackageParser(this.docId);
        this.ddpp.setAttributeXPathMap(this.attributeMap);
        this.ddpp.parse(inputStream);
        this.loaded = true;
        long endTime = System.currentTimeMillis();
        log.debug((Object)(endTime - startTime + " ms to parse document data"));
        log.debug((Object)"downloaded data");
    }

    public DataPackage loadDataToDB() throws Exception {
        if (!this.isLoaded()) {
            this.downloadDocument();
        }
        this.ddpp.generateEntity();
        DataPackage dataPackage = null;
        Entity entity = null;
        dataPackage = this.ddpp.getDataPackage();
        entity = dataPackage.getEntityList()[0];
        this.databaseHandler.generateTable(entity);
        this.databaseHandler.dropTable(entity);
        this.databaseHandler.generateTable(entity);
        log.debug((Object)("created table for entity: " + entity.getDBTableName()));
        Vector rowData = ((DocumentDataPackage)dataPackage).getRecordRow();
        VectorReader dataReader = new VectorReader();
        dataReader.addOneRowDataVector(rowData);
        SimpleDatabaseLoader databaseLoader = new SimpleDatabaseLoader(this.connectionPool.getDBAdapterName(), entity, dataReader);
        if (!databaseLoader.doesDataExist(entity.getEntityIdentifier())) {
            databaseLoader.run();
        }
        log.debug((Object)"loaded data to db");
        return dataPackage;
    }

    public String getDocId() {
        return this.docId;
    }

    public void setDocId(String docId) {
        this.docId = docId;
    }

    public EcogridEndPointInterface getEcogridEndPointInterface() {
        return this.ecogridEndPointInterface;
    }

    public void setEcogridEndPointInterface(EcogridEndPointInterface ecogridEndPointInterface) {
        this.ecogridEndPointInterface = ecogridEndPointInterface;
    }

    public Map getAttributeMap() {
        return this.attributeMap;
    }

    public void setAttributeMap(Map attributeMap) {
        this.attributeMap = attributeMap;
    }

    public boolean isLoaded() {
        return this.loaded;
    }
}

