/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.util;

import java.io.Serializable;
import java.lang.reflect.Array;

public class List
implements Cloneable,
Serializable {
    private int DEFAULT_SIZE;
    private Object[] elements;
    private int initialSize;
    private int elementCount;

    public List() {
        this.initialSize = this.DEFAULT_SIZE = 11;
        this.elementCount = 0;
        this.elements = new Object[this.DEFAULT_SIZE];
    }

    public List(int size) {
        this.initialSize = this.DEFAULT_SIZE = 11;
        this.elementCount = 0;
        this.initialSize = size;
        this.elements = new Object[size];
    }

    public boolean add(Object obj) {
        if (this.elementCount == this.elements.length) {
            this.increaseSize();
        }
        this.elements[this.elementCount++] = obj;
        return true;
    }

    public boolean add(int index, Object obj) throws IndexOutOfBoundsException {
        if (index < 0 || index > this.elementCount) {
            throw new IndexOutOfBoundsException();
        }
        if (this.elementCount == this.elements.length) {
            this.increaseSize();
        }
        if (index == this.elementCount) {
            this.elements[this.elementCount++] = obj;
        } else {
            this.shiftUp(index);
            this.elements[index] = obj;
            ++this.elementCount;
        }
        return true;
    }

    public void clear() {
        int i = 0;
        while (i < this.elementCount) {
            this.elements[i] = null;
            ++i;
        }
        this.elementCount = 0;
    }

    public Object clone() {
        Object obj = null;
        try {
            obj = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return obj;
    }

    public boolean contains(Object obj) {
        return this.indexOf(obj) >= 0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof List)) {
            return false;
        }
        List list = (List)obj;
        if (list.size() != this.size()) {
            return false;
        }
        int i = 0;
        while (i < this.size()) {
            Object e1 = this.get(i);
            Object e2 = list.get(i);
            if (!(e1 == null ? e2 == null : e1.equals(e2))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Object get(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.elementCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.elements[index];
    }

    public int hashCode() {
        int hashCode = 1;
        int i = 0;
        while (i < this.elementCount) {
            Object obj = this.elements[i];
            hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
            ++i;
        }
        return hashCode;
    }

    public int indexOf(Object obj) {
        if (obj == null) {
            int i = 0;
            while (i < this.elementCount) {
                if (this.elements[i] == null) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.elementCount) {
                if (obj.equals(this.elements[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public int lastIndexOf(Object obj) {
        if (obj == null) {
            int i = this.elementCount - 1;
            while (i >= 0) {
                if (this.elements[i] == null) {
                    return i;
                }
                --i;
            }
        } else {
            int i = this.elementCount - 1;
            while (i >= 0) {
                if (obj.equals(this.elements[i])) {
                    return i;
                }
                --i;
            }
        }
        return -1;
    }

    public Object remove(int index) {
        if (index < 0 || index > this.elementCount) {
            return null;
        }
        Object obj = this.elements[index];
        this.shiftDown(index + 1);
        --this.elementCount;
        return obj;
    }

    public boolean remove(Object obj) {
        int index = this.indexOf(obj);
        if (index <= -1) {
            return false;
        }
        this.remove(index);
        return true;
    }

    public void trimToSize() {
        Object[] pointer = this.elements;
        this.elements = new Object[this.elementCount];
        System.arraycopy(pointer, 0, this.elements, 0, this.elementCount);
        Object var1_1 = null;
    }

    public Object set(int index, Object element) throws IndexOutOfBoundsException {
        if (index < 0 || index > this.elementCount) {
            throw new IndexOutOfBoundsException();
        }
        Object oldElement = null;
        if (index == this.elementCount) {
            this.add(element);
        } else {
            oldElement = this.elements[index];
            this.elements[index] = element;
        }
        return oldElement;
    }

    public int size() {
        return this.elementCount;
    }

    public List subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.size() || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException();
        }
        List list = new List(toIndex - fromIndex);
        int i = fromIndex;
        while (i < toIndex) {
            list.add(this.elements[i]);
            ++i;
        }
        return list;
    }

    public Object[] toArray() {
        Object[] objArray = new Object[this.elementCount];
        System.arraycopy(this.elements, 0, objArray, 0, this.elementCount);
        return objArray;
    }

    public Object[] toArray(Object[] dst) {
        return this.toArray(dst, 0);
    }

    public Object[] toArray(Object[] dst, int offset) {
        Object[] objArray = null;
        if (dst.length >= this.elementCount) {
            objArray = dst;
        } else {
            Class<?> dstType = dst.getClass();
            objArray = (Object[])Array.newInstance(dstType, this.elementCount);
        }
        System.arraycopy(this.elements, 0, objArray, offset, this.elementCount);
        return objArray;
    }

    private void increaseSize() {
        Object[] pointer = this.elements;
        int length = pointer.length > 0 ? pointer.length : 1;
        this.elements = new Object[length * 3 / 2 + 1];
        System.arraycopy(pointer, 0, this.elements, 0, pointer.length);
        Object var1_1 = null;
    }

    private void shiftDown(int index) {
        if (index <= 0 || index >= this.elementCount) {
            return;
        }
        System.arraycopy(this.elements, index, this.elements, index - 1, this.elementCount - index);
        this.elements[this.elementCount - 1] = null;
    }

    private void shiftUp(int index) {
        if (index == this.elementCount) {
            return;
        }
        if (this.elementCount == this.elements.length) {
            this.increaseSize();
        }
        System.arraycopy(this.elements, index, this.elements, index + 1, this.elementCount - index);
    }
}

