/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.iterator;

import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterProcessBinding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprException;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.ExprUtils;
import com.hp.hpl.jena.sparql.util.Utils;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.logging.Log;

public class QueryIterFilterExpr
extends QueryIterProcessBinding {
    private final Expr expr;

    public QueryIterFilterExpr(QueryIterator input, Expr expr, ExecutionContext context) {
        super(input, context);
        this.expr = expr;
    }

    @Override
    public Binding accept(Binding binding) {
        try {
            if (this.expr.isSatisfied(binding, super.getExecContext())) {
                return binding;
            }
            return null;
        }
        catch (ExprException ex) {
            Log.warn(this, "Expression Exception in " + this.expr, (Throwable)((Object)ex));
            return null;
        }
        catch (Exception ex) {
            Log.warn(this, "General exception in " + this.expr, (Throwable)ex);
            return null;
        }
    }

    @Override
    protected void details(IndentedWriter out, SerializationContext cxt) {
        out.print(Utils.className(this));
        out.print(" ");
        ExprUtils.fmtSPARQL(out, this.expr, cxt);
    }
}

