/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.server.conf;

import com.ibm.lsid.server.LSIDAuthorityService;
import com.ibm.lsid.server.LSIDDataService;
import com.ibm.lsid.server.LSIDMetadataService;
import com.ibm.lsid.server.LSIDServerException;
import com.ibm.lsid.server.LSIDService;
import com.ibm.lsid.server.LSIDServiceConfig;
import com.ibm.lsid.server.conf.LSIDConfigurationException;
import com.ibm.lsid.server.conf.LSIDServiceComponentHandler;
import com.ibm.lsid.server.conf.ServiceComponentHandler;
import com.ibm.lsid.server.conf.ServiceConfigurationConstants;
import com.ibm.lsid.server.impl.CachingAuthorityService;
import com.ibm.lsid.server.impl.CachingDataService;
import com.ibm.lsid.server.impl.CachingMetadataService;
import java.util.Vector;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CachingComponentHandler
implements ServiceComponentHandler,
ServiceConfigurationConstants {
    public LSIDService loadComponent(Element compElt, LSIDServiceConfig config) throws LSIDConfigurationException {
        try {
            String className = XPathAPI.selectSingleNode((Node)compElt, (String)"child::text()").getNodeValue();
            LSIDService service = null;
            try {
                service = (LSIDService)Thread.currentThread().getContextClassLoader().loadClass(className).newInstance();
                LSIDServiceComponentHandler.checkComponent(compElt.getLocalName(), service);
                service.initService(config);
            }
            catch (InstantiationException e) {
                throw new LSIDServerException(e, 500, "Could not load class: " + className);
            }
            catch (IllegalAccessException e) {
                throw new LSIDServerException(e, 500, "Could not load class: " + className);
            }
            catch (ClassNotFoundException e) {
                throw new LSIDServerException(e, 500, "Could not find class: " + className);
            }
            LSIDService cacheService = null;
            String type = compElt.getNodeName();
            if (type.equals("auth")) {
                cacheService = new CachingAuthorityService((LSIDAuthorityService)service);
            } else if (type.equals("meta")) {
                cacheService = new CachingMetadataService((LSIDMetadataService)service);
            } else if (type.equals("data")) {
                cacheService = new CachingDataService((LSIDDataService)service);
            }
            cacheService.initService(config);
            return cacheService;
        }
        catch (Exception e) {
            throw new LSIDConfigurationException(e, "Error loading service");
        }
    }

    public Vector knownServices() {
        Vector<String> v = new Vector<String>(3);
        v.add("meta");
        v.add("auth");
        v.add("data");
        return v;
    }
}

