/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.impl.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.sonatype.aether.RepositoryCache;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.collection.DependencyManager;
import org.sonatype.aether.collection.DependencySelector;
import org.sonatype.aether.collection.DependencyTraverser;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.impl.internal.GraphNode;
import org.sonatype.aether.impl.internal.ObjectPool;
import org.sonatype.aether.repository.ArtifactRepository;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.ArtifactDescriptorRequest;
import org.sonatype.aether.resolution.ArtifactDescriptorResult;
import org.sonatype.aether.resolution.VersionRangeRequest;
import org.sonatype.aether.resolution.VersionRangeResult;
import org.sonatype.aether.version.Version;
import org.sonatype.aether.version.VersionConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DataPool {
    private static final String ARTIFACT_POOL = DataPool.class.getName() + "$Artifact";
    private static final String DEPENDENCY_POOL = DataPool.class.getName() + "$Dependency";
    private static final String DESCRIPTORS = DataPool.class.getName() + "$Descriptors";
    private ObjectPool<Artifact> artifacts;
    private ObjectPool<Dependency> dependencies;
    private Map<Object, Descriptor> descriptors;
    private Map<Object, Constraint> constraints = new WeakHashMap<Object, Constraint>();
    private Map<Object, GraphNode> nodes = new HashMap<Object, GraphNode>();

    public DataPool(RepositorySystemSession session) {
        RepositoryCache cache = session.getCache();
        if (cache != null) {
            this.artifacts = (ObjectPool)cache.get(session, (Object)ARTIFACT_POOL);
            this.dependencies = (ObjectPool)cache.get(session, (Object)DEPENDENCY_POOL);
            this.descriptors = (Map)cache.get(session, (Object)DESCRIPTORS);
        }
        if (this.artifacts == null) {
            this.artifacts = new ObjectPool();
            if (cache != null) {
                cache.put(session, (Object)ARTIFACT_POOL, this.artifacts);
            }
        }
        if (this.dependencies == null) {
            this.dependencies = new ObjectPool();
            if (cache != null) {
                cache.put(session, (Object)DEPENDENCY_POOL, this.dependencies);
            }
        }
        if (this.descriptors == null) {
            this.descriptors = Collections.synchronizedMap(new WeakHashMap(256));
            if (cache != null) {
                cache.put(session, (Object)DESCRIPTORS, this.descriptors);
            }
        }
    }

    public Artifact intern(Artifact artifact) {
        return this.artifacts.intern(artifact);
    }

    public Dependency intern(Dependency dependency) {
        return this.dependencies.intern(dependency);
    }

    public Object toKey(ArtifactDescriptorRequest request) {
        return request.getArtifact();
    }

    public ArtifactDescriptorResult getDescriptor(Object key, ArtifactDescriptorRequest request) {
        Descriptor descriptor = this.descriptors.get(key);
        if (descriptor != null) {
            return descriptor.toResult(request);
        }
        return null;
    }

    public void putDescriptor(Object key, ArtifactDescriptorResult result) {
        this.descriptors.put(key, new Descriptor(result));
    }

    public Object toKey(VersionRangeRequest request) {
        return new ConstraintKey(request);
    }

    public VersionRangeResult getConstraint(Object key, VersionRangeRequest request) {
        Constraint constraint = this.constraints.get(key);
        if (constraint != null) {
            return constraint.toResult(request);
        }
        return null;
    }

    public void putConstraint(Object key, VersionRangeResult result) {
        this.constraints.put(key, new Constraint(result));
    }

    public Object toKey(Artifact artifact, List<RemoteRepository> repositories) {
        return new NodeKey(artifact, repositories);
    }

    public Object toKey(Artifact artifact, List<RemoteRepository> repositories, DependencySelector selector, DependencyManager manager, DependencyTraverser traverser) {
        return new GraphKey(artifact, repositories, selector, manager, traverser);
    }

    public GraphNode getNode(Object key) {
        return this.nodes.get(key);
    }

    public void putNode(Object key, GraphNode node) {
        this.nodes.put(key, node);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class GraphKey {
        private final Artifact artifact;
        private final List<RemoteRepository> repositories;
        private final DependencySelector selector;
        private final DependencyManager manager;
        private final DependencyTraverser traverser;
        private final int hashCode;

        public GraphKey(Artifact artifact, List<RemoteRepository> repositories, DependencySelector selector, DependencyManager manager, DependencyTraverser traverser) {
            this.artifact = artifact;
            this.repositories = repositories;
            this.selector = selector;
            this.manager = manager;
            this.traverser = traverser;
            int hash = 17;
            hash = hash * 31 + artifact.hashCode();
            hash = hash * 31 + ((Object)repositories).hashCode();
            hash = hash * 31 + selector.hashCode();
            hash = hash * 31 + manager.hashCode();
            this.hashCode = hash = hash * 31 + traverser.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof GraphKey)) {
                return false;
            }
            GraphKey that = (GraphKey)obj;
            return this.artifact.equals(that.artifact) && ((Object)this.repositories).equals(that.repositories) && this.selector.equals(that.selector) && this.manager.equals(that.manager) && this.traverser.equals(that.traverser);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NodeKey {
        private final Artifact artifact;
        private final List<RemoteRepository> repositories;
        private final int hashCode;

        public NodeKey(Artifact artifact, List<RemoteRepository> repositories) {
            this.artifact = artifact;
            this.repositories = repositories;
            int hash = 17;
            hash = hash * 31 + artifact.hashCode();
            this.hashCode = hash = hash * 31 + ((Object)repositories).hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof NodeKey)) {
                return false;
            }
            NodeKey that = (NodeKey)obj;
            return this.artifact.equals(that.artifact) && ((Object)this.repositories).equals(that.repositories);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConstraintKey {
        private final Artifact artifact;
        private final List<RemoteRepository> repositories;
        private final int hashCode;

        public ConstraintKey(VersionRangeRequest request) {
            this.artifact = request.getArtifact();
            this.repositories = request.getRepositories();
            this.hashCode = this.artifact.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ConstraintKey)) {
                return false;
            }
            ConstraintKey that = (ConstraintKey)obj;
            return this.artifact.equals(that.artifact) && ConstraintKey.equals(this.repositories, that.repositories);
        }

        private static boolean equals(Collection<RemoteRepository> repos1, Collection<RemoteRepository> repos2) {
            if (repos1.size() != repos2.size()) {
                return false;
            }
            Iterator<RemoteRepository> it1 = repos1.iterator();
            Iterator<RemoteRepository> it2 = repos2.iterator();
            while (it1.hasNext()) {
                RemoteRepository repo1 = it1.next();
                RemoteRepository repo2 = it2.next();
                if (repo1.isRepositoryManager() != repo2.isRepositoryManager()) {
                    return false;
                }
                if (repo1.isRepositoryManager()) {
                    if (ConstraintKey.equals(repo1.getMirroredRepositories(), repo2.getMirroredRepositories())) continue;
                    return false;
                }
                if (!repo1.getUrl().equals(repo2.getUrl())) {
                    return false;
                }
                if (repo1.getPolicy(true).isEnabled() != repo2.getPolicy(true).isEnabled()) {
                    return false;
                }
                if (repo1.getPolicy(false).isEnabled() == repo2.getPolicy(false).isEnabled()) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    static class Constraint {
        final Map<Version, ArtifactRepository> repositories;
        final VersionConstraint versionConstraint;

        public Constraint(VersionRangeResult result) {
            this.versionConstraint = result.getVersionConstraint();
            this.repositories = new LinkedHashMap<Version, ArtifactRepository>();
            for (Version version : result.getVersions()) {
                this.repositories.put(version, result.getRepository(version));
            }
        }

        public VersionRangeResult toResult(VersionRangeRequest request) {
            VersionRangeResult result = new VersionRangeResult(request);
            for (Map.Entry<Version, ArtifactRepository> entry : this.repositories.entrySet()) {
                result.addVersion(entry.getKey());
                result.setRepository(entry.getKey(), entry.getValue());
            }
            result.setVersionConstraint(this.versionConstraint);
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Descriptor {
        final Artifact artifact;
        final Map<String, Object> properties;
        final List<Artifact> relocations;
        final List<RemoteRepository> repositories;
        final List<Dependency> dependencies;
        final List<Dependency> managedDependencies;

        public Descriptor(ArtifactDescriptorResult result) {
            this.artifact = result.getArtifact();
            this.properties = result.getProperties();
            this.relocations = result.getRelocations();
            this.dependencies = result.getDependencies();
            this.managedDependencies = result.getManagedDependencies();
            this.repositories = Descriptor.clone(result.getRepositories());
        }

        public ArtifactDescriptorResult toResult(ArtifactDescriptorRequest request) {
            ArtifactDescriptorResult result = new ArtifactDescriptorResult(request);
            result.setArtifact(this.artifact);
            result.setProperties(this.properties);
            result.setRelocations(this.relocations);
            result.setDependencies(this.dependencies);
            result.setManagedDependencies(this.dependencies);
            result.setRepositories(Descriptor.clone(this.repositories));
            return result;
        }

        private static List<RemoteRepository> clone(List<RemoteRepository> repositories) {
            ArrayList<RemoteRepository> clones = new ArrayList<RemoteRepository>(repositories.size());
            for (RemoteRepository repository : repositories) {
                RemoteRepository clone = new RemoteRepository(repository);
                clone.setMirroredRepositories(new ArrayList(repository.getMirroredRepositories()));
                clones.add(clone);
            }
            return clones;
        }
    }
}

